(ns de.levering-it.electric.three.controls.first-person
  (:require [hyperfiddle.electric3 :as e]
            [hyperfiddle.electric-dom3 :as dom]
            [de.levering-it.electric.three :as th]
            [de.levering-it.electric.three.utils :as tu]))

(defn clamp [v min max]
  (Math/min (Math/max v min) max))

#?(:cljs (defn -first-person [dt ^js camera config dx dy keys]
           (let [sensitivity (or (:sensitivity config) 0.002)
                 speed (or (:speed config) 0.003)
                 look-direction (-> (th/vector3 0 0 -1)
                                  (.applyQuaternion (.-quaternion camera)))
                 position (.-position camera)
                 sperical (doto (th/spherical 0 0 0)
                            (.setFromVector3 look-direction))
                 phi (clamp (+ (.-phi sperical) (* dy sensitivity)) 0.05 3.09)
                 theta (+ (.-theta sperical) (* (- dx) sensitivity))
                 new-direction (doto (th/vector3 0 0 0)
                                 (.setFromSphericalCoords 1 phi theta))]
             (set! (.-y new-direction) 0)
             (.normalize new-direction)
             (when (or (get keys "w") (get keys "W"))
               (let [new-x (+ (.-x position) (* (.-x new-direction) dt speed))
                     new-z (+ (.-z position) (* (.-z new-direction) dt speed))]
                 (set! (.-x position) new-x)
                 (set! (.-z position) new-z)))
             (when (or (get keys "s") (get keys "S"))
               (let [new-x (- (.-x position) (* (.-x new-direction) dt speed))
                     new-z (- (.-z position) (* (.-z new-direction) dt speed))]
                 (set! (.-x position) new-x)
                 (set! (.-z position) new-z)))
             (when (or (get keys "a") (get keys "A"))
               (let [new-x (+ (.-x position) (* (.-z new-direction) dt speed))
                     new-z (- (.-z position) (* (.-x new-direction) dt speed))]
                 (set! (.-x position) new-x)
                 (set! (.-z position) new-z)))
             (when (or (get keys "d") (get keys "D"))
               (let [new-x (- (.-x position) (* (.-z new-direction) dt speed))
                     new-z (+ (.-z position) (* (.-x new-direction) dt speed))]
                 (set! (.-x position) new-x)
                 (set! (.-z position) new-z)))

             (let [target (doto (th/vector3 0 0 0)
                            (.setFromSphericalCoords 1 phi theta)
                            (.add position))]
               (.lookAt camera target)
               {:x (.-x position) :y (.-y position) :z (.-z position)}))))

(e/defn FirstPersonControls [camera opts]
  (let [pointer-lock (tu/PointerLock?)]
    (e/on-unmount #(when (= (.-pointerLockElement js/document)  dom/node)
                     (.exitPointerLock js/document)))
    (if pointer-lock
      (let [dxdy! (atom (tu/RelMove))
            dxdy (e/watch dxdy!)
            dx (first dxdy)
            dy (second dxdy)
            keys (e/client (binding [dom/node (.-body js/document)] (tu/KeyState)))]
        (e/client (let [pos ((tu/with-t->dt -first-person) (e/System-time-ms) camera opts dx dy keys)]
                    (reset! dxdy! [0 0])
                    pos)))
      (do
        (.requestPointerLock dom/node)
        (e/amb)))))