(ns de.axeclbr.waxbase)

(defn hexagon-corner [center size i]
  {:pre [(and (<= 0 i) (>= 5 i))]}
  (let [{x :x y :y} center
        angle-deg (+ (* 60 i) 30)
        angle-rad (* (/ Math/PI 180) angle-deg)]
    {:x (+ x (* (Math/cos angle-rad) size))
     :y (+ y (* (Math/sin angle-rad) size))}))

(defn hexagon-corners [center size]
  (let [corner-indizes (range 0 6)
        keys (map keyword (map str corner-indizes))
        vals (map #(hexagon-corner center size %) corner-indizes)]
    (zipmap keys vals)))

(defn hexagon [center size]
  {:type    'hexagon
   :center  center
   :size    size
   :corners (hexagon-corners center size)})
