(ns sqlosure.playground
  (:require [active.clojure.monad :as monad]
            [sqlosure.core :as sql]))

(defrecord Person [id first-name])

(def person-table
  (sql/table "person" [["id" sql/$integer-t]
                       ["firstName" sql/$string-t]]))

(declare query filter!)

(defn person-id=
  [id p]
  (sql/$= (sql/! p "id") id))

(defn find-by-id!
  [id]
  (filter! (partial person-id= id) person-table))

(defn filter!
  [predicate relation]
  (sql/query [rel (sql/<- relation)]
             (sql/restrict! (predicate rel))
             (sql/project rel)))
