(ns reacl-c-basics.vforms.core)

;; add/remove class .was-validated from form to hide/show errors
;; add noValidate for form; call checkValidity in onSubmit
;; mark item as is-invalid in onInvalid
;; show item's validationMessage in invalid-feedback (and when it changes?)

(dom/defn-dom form [attrs & content]
  (c/with-state-as [_ was-validated? :local false]
    (apply dom/form {:noValidate true
                     :class (if was-validated? "was-validated" "")
                     :onSubmit (fn [state ev]
                                 (if (.checkValidity (.-target ev))
                                   (c/merge-returned (c/return :state (assoc-in state [1] false))
                                                     (c/call (:onSubmit attrs) ev))
                                   (do (.preventDefault ev)
                                       (c/return :state (assoc-in state [1] true)))))}
           content)))

(def validation-success nil)

(defn validation-error [error]
  (assert (string? error))
  error)

(def validation-error-missing
  ::missing)

(dom/defn-dom input
  "A validated input. The state must be a tuple of the state an input of
that type would normally have and a validation result."
  [attrs & content]
  (if (:required attrs))
  
  (c/focus lens/first (apply forms/input attrs content)))

(dom/defn-dom error
  "Given a state of some value and a validation result, shows the error."
  []
  (c/with-state-as [_ error]
    (when (string? error) error)))

(dom/defn-dom input-bs [attrs & content]
  ;; if this.form.classList.contains("was-validated")?
  
  (c/with-state-as [_ error]
    ;; TODO: some may also want to use 'is-valid'?
    (apply input
           (if (some? error)
             (dom/merge-attributes {:class "is-invalid"} ;; TODO: only if 'submitted'
                                   attrs)
             attrs)
           content)))

(dom/defn-dom error-feedback-bs
  "Given a state of some value and a validation result, shows "
  [attrs]
  (dom/div (dom/merge-attributes {:class "invalid-feedback"}
                                 attrs)
           (error)))
