(ns reacl-c-basics.forms.resource
  
  )

;; TODO: only one-time load? load-after-save? or is the response of the put the new data? add a reload action?

#_(defn resource-form
  "A form item to edit a server resource. Renders as `(f stored-data
  saving?  saving-error)` with a state `[outer-state edited-data]`
  inside a dom/form. `stored-data` and `edited-data` will be nil
  initially. Use `submit` and `reset` buttons inside the form."
  [get-request post-request f]
  (let [content
        (fn [initially-loaded]
          (c/with-state-as [out local-state :local {:stored initially-loaded
                                                    :edited initially-loaded
                                                    :storing? false
                                                    :error nil}]
            (-> (forms/form {:onSubmit (fn [[st local-state] ev]
                                         (.preventDefault ev)
                                         (c/return :state [st (assoc local-state :storing? true)]
                                                   :action
                                                   (ajax/deliver (post-request (:edited local-state))
                                                                 ;; job-info: what is acutally stored
                                                                 (:edited local-state))))
                             :onReset (fn [[st local-state] ev]
                                        (.preventDefault ev)
                                        (c/return :state [st (-> local-state
                                                                 (assoc :edited (:stored local-state)))]))}
                            (c/focus (lens/pattern [lens/first ;; outer state
                                                    (lens/>> lens/second :edited)])
                                     (f (:stored local-state) (:storing? local-state) (:error local-state))))
                (ajax/delivery (fn [[st local-state] job]
                                 (case (ajax/delivery-job-status job)
                                   :completed
                                   (let [resp (ajax/delivery-job-response job)]
                                     (if (ajax/response-ok? resp)
                                       (let [actually-stored (ajax/delivery-job-info job)]
                                         (c/return :state [st (-> local-state
                                                                  (assoc :stored actually-stored
                                                                         :storing? false))]))
                                       (c/return :state [st (-> local-state
                                                                (assoc :error (ajax/response-value resp)
                                                                       :storing? false))])))
                                   (c/return)))))))]
    (with-fetch-result
      get-request
      content
      ;; while loading:
      (content nil))))
