// Compiled by ClojureScript 1.10.339 {}
goog.provide('active_viz.scale.linear_scale');
goog.require('cljs.core');
goog.require('active_viz.ticks');
goog.require('active.clojure.cljs.record');
goog.require('active_viz.scale.types');



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {active_viz.scale.types.ScaleFn}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
active_viz.scale.linear_scale.LinearScaleParams = (function (a,b,__meta,__extmap,__hash){
this.a = a;
this.b = b;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__9707__auto__,k__9708__auto__){
var self__ = this;
var this__9707__auto____$1 = this;
return this__9707__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__9708__auto__,null);
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__9709__auto__,k10510,else__9710__auto__){
var self__ = this;
var this__9709__auto____$1 = this;
var G__10514 = k10510;
var G__10514__$1 = (((G__10514 instanceof cljs.core.Keyword))?G__10514.fqn:null);
switch (G__10514__$1) {
case "a":
return self__.a;

break;
case "b":
return self__.b;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k10510,else__9710__auto__);

}
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__9717__auto__,writer__9718__auto__,opts__9719__auto__){
var self__ = this;
var this__9717__auto____$1 = this;
var pr_pair__9720__auto__ = ((function (this__9717__auto____$1){
return (function (keyval__9721__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__9718__auto__,cljs.core.pr_writer,""," ","",opts__9719__auto__,keyval__9721__auto__);
});})(this__9717__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__9718__auto__,pr_pair__9720__auto__,"#active-viz.scale.linear-scale.LinearScaleParams{",", ","}",opts__9719__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"a","a",-2123407586),self__.a],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"b","b",1482224470),self__.b],null))], null),self__.__extmap));
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__10509){
var self__ = this;
var G__10509__$1 = this;
return (new cljs.core.RecordIter((0),G__10509__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.Keyword(null,"b","b",1482224470)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__9705__auto__){
var self__ = this;
var this__9705__auto____$1 = this;
return self__.__meta;
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__9702__auto__){
var self__ = this;
var this__9702__auto____$1 = this;
return (new active_viz.scale.linear_scale.LinearScaleParams(self__.a,self__.b,self__.__meta,self__.__extmap,self__.__hash));
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__9711__auto__){
var self__ = this;
var this__9711__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__9703__auto__){
var self__ = this;
var this__9703__auto____$1 = this;
var h__4061__auto__ = self__.__hash;
if(!((h__4061__auto__ == null))){
return h__4061__auto__;
} else {
var h__4061__auto____$1 = ((function (h__4061__auto__,this__9703__auto____$1){
return (function (coll__9704__auto__){
return (-1801074233 ^ cljs.core.hash_unordered_coll.call(null,coll__9704__auto__));
});})(h__4061__auto__,this__9703__auto____$1))
.call(null,this__9703__auto____$1);
self__.__hash = h__4061__auto____$1;

return h__4061__auto____$1;
}
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this10511,other10512){
var self__ = this;
var this10511__$1 = this;
return ((!((other10512 == null))) && ((this10511__$1.constructor === other10512.constructor)) && (cljs.core._EQ_.call(null,this10511__$1.a,other10512.a)) && (cljs.core._EQ_.call(null,this10511__$1.b,other10512.b)) && (cljs.core._EQ_.call(null,this10511__$1.__extmap,other10512.__extmap)));
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.active_viz$scale$types$ScaleFn$ = cljs.core.PROTOCOL_SENTINEL;

active_viz.scale.linear_scale.LinearScaleParams.prototype.active_viz$scale$types$ScaleFn$call$arity$3 = (function (_,___$1,param){
var self__ = this;
var ___$2 = this;
return ((param * self__.a) + self__.b);
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.active_viz$scale$types$ScaleFn$call_inverse$arity$3 = (function (_,___$1,param){
var self__ = this;
var ___$2 = this;
return ((param - self__.b) / self__.a);
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__9700__auto__,k__9701__auto__){
var self__ = this;
var this__9700__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"b","b",1482224470),null,new cljs.core.Keyword(null,"a","a",-2123407586),null], null), null),k__9701__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__9700__auto____$1),self__.__meta),k__9701__auto__);
} else {
return (new active_viz.scale.linear_scale.LinearScaleParams(self__.a,self__.b,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__9701__auto__)),null));
}
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__9698__auto__,k__9699__auto__,G__10509){
var self__ = this;
var this__9698__auto____$1 = this;
var pred__10515 = cljs.core.keyword_identical_QMARK_;
var expr__10516 = k__9699__auto__;
if(cljs.core.truth_(pred__10515.call(null,new cljs.core.Keyword(null,"a","a",-2123407586),expr__10516))){
return (new active_viz.scale.linear_scale.LinearScaleParams(G__10509,self__.b,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__10515.call(null,new cljs.core.Keyword(null,"b","b",1482224470),expr__10516))){
return (new active_viz.scale.linear_scale.LinearScaleParams(self__.a,G__10509,self__.__meta,self__.__extmap,null));
} else {
return (new active_viz.scale.linear_scale.LinearScaleParams(self__.a,self__.b,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__9699__auto__,G__10509),null));
}
}
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__9715__auto__){
var self__ = this;
var this__9715__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"a","a",-2123407586),self__.a,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"b","b",1482224470),self__.b,null))], null),self__.__extmap));
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__9706__auto__,G__10509){
var self__ = this;
var this__9706__auto____$1 = this;
return (new active_viz.scale.linear_scale.LinearScaleParams(self__.a,self__.b,G__10509,self__.__extmap,self__.__hash));
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__9712__auto__,entry__9713__auto__){
var self__ = this;
var this__9712__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__9713__auto__)){
return this__9712__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__9713__auto__,(0)),cljs.core._nth.call(null,entry__9713__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__9712__auto____$1,entry__9713__auto__);
}
});

active_viz.scale.linear_scale.LinearScaleParams.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.Symbol(null,"b","b",-1172211299,null)], null);
});

active_viz.scale.linear_scale.LinearScaleParams.cljs$lang$type = true;

active_viz.scale.linear_scale.LinearScaleParams.cljs$lang$ctorPrSeq = (function (this__9793__auto__){
return (new cljs.core.List(null,"active-viz.scale.linear-scale/LinearScaleParams",null,(1),null));
});

active_viz.scale.linear_scale.LinearScaleParams.cljs$lang$ctorPrWriter = (function (this__9793__auto__,writer__9794__auto__){
return cljs.core._write.call(null,writer__9794__auto__,"active-viz.scale.linear-scale/LinearScaleParams");
});

if(cljs.core._EQ_.call(null,false,new cljs.core.Keyword(null,"arrow-constructor?","arrow-constructor?",-1068727936).cljs$core$IFn$_invoke$arity$1(null))){
} else {
/**
 * Positional factory function for active-viz.scale.linear-scale/LinearScaleParams.
 */
active_viz.scale.linear_scale.__GT_LinearScaleParams = (function active_viz$scale$linear_scale$__GT_LinearScaleParams(a,b){
return (new active_viz.scale.linear_scale.LinearScaleParams(a,b,null,null,null));
});
}

/**
 * Factory function for active-viz.scale.linear-scale/LinearScaleParams, taking a map of keywords to field values.
 */
active_viz.scale.linear_scale.map__GT_LinearScaleParams = (function active_viz$scale$linear_scale$map__GT_LinearScaleParams(G__10513){
var extmap__9615__auto__ = (function (){var G__10518 = cljs.core.dissoc.call(null,G__10513,new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.Keyword(null,"b","b",1482224470));
if(cljs.core.record_QMARK_.call(null,G__10513)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__10518);
} else {
return G__10518;
}
})();
return (new active_viz.scale.linear_scale.LinearScaleParams(new cljs.core.Keyword(null,"a","a",-2123407586).cljs$core$IFn$_invoke$arity$1(G__10513),new cljs.core.Keyword(null,"b","b",1482224470).cljs$core$IFn$_invoke$arity$1(G__10513),null,cljs.core.not_empty.call(null,extmap__9615__auto__),null));
});

/**
 * Is object a `LinearScaleParams` record? See [[active-viz.scale.linear-scale/make-linear-scale-params]].
 */
active_viz.scale.linear_scale.linear_scale_params_QMARK_ = (function active_viz$scale$linear_scale$linear_scale_params_QMARK_(x__9795__auto__){
return (x__9795__auto__ instanceof active_viz.scale.linear_scale.LinearScaleParams);
});

/**
 * Construct a `LinearScaleParams` record.
 * 
 * `a`: access via [[active-viz.scale.linear-scale/linear-scale-a]]
 * `b`: access via [[active-viz.scale.linear-scale/linear-scale-b]]
 */
active_viz.scale.linear_scale.make_linear_scale_params = (function active_viz$scale$linear_scale$make_linear_scale_params(a,b){
return (new active_viz.scale.linear_scale.LinearScaleParams(a,b,null,null,null));
});



/**
 * Lens for the `a` field from a [[LinearScaleParams]] record. See [[active-viz.scale.linear-scale/make-linear-scale-params]].
 */
active_viz.scale.linear_scale.linear_scale_a = active.clojure.lens.lens.call(null,(function (rec__9774__auto__){
if((rec__9774__auto__ instanceof active_viz.scale.linear_scale.LinearScaleParams)){
} else {
throw (new Error("Wrong record type (rec__9774__auto__) passed to accessor (linear-scale-a)."));
}

return rec__9774__auto__.a;
}),(function (data__9775__auto__,v__9776__auto__){
return (new active_viz.scale.linear_scale.LinearScaleParams(v__9776__auto__,active_viz.scale.linear_scale.linear_scale_b.call(null,data__9775__auto__),null,null,null));
}));


/**
 * Lens for the `b` field from a [[LinearScaleParams]] record. See [[active-viz.scale.linear-scale/make-linear-scale-params]].
 */
active_viz.scale.linear_scale.linear_scale_b = active.clojure.lens.lens.call(null,(function (rec__9774__auto__){
if((rec__9774__auto__ instanceof active_viz.scale.linear_scale.LinearScaleParams)){
} else {
throw (new Error("Wrong record type (rec__9774__auto__) passed to accessor (linear-scale-b)."));
}

return rec__9774__auto__.b;
}),(function (data__9775__auto__,v__9776__auto__){
return (new active_viz.scale.linear_scale.LinearScaleParams(active_viz.scale.linear_scale.linear_scale_a.call(null,data__9775__auto__),v__9776__auto__,null,null,null));
}));



active_viz.scale.linear_scale.make_linear_scale = (function active_viz$scale$linear_scale$make_linear_scale(p__10520,p__10521){
var vec__10522 = p__10520;
var domain_min = cljs.core.nth.call(null,vec__10522,(0),null);
var domain_max = cljs.core.nth.call(null,vec__10522,(1),null);
var vec__10525 = p__10521;
var range_min = cljs.core.nth.call(null,vec__10525,(0),null);
var range_max = cljs.core.nth.call(null,vec__10525,(1),null);
var domain_spread = (domain_max - domain_min);
var range_spread = (range_max - range_min);
var a = (range_spread / domain_spread);
var b = (range_min - (domain_min * a));
return active_viz.scale.types.make_scale.call(null,domain_min,domain_max,range_min,range_max,active_viz.scale.linear_scale.make_linear_scale_params.call(null,a,b),active_viz.scale.types.nop);
});
active_viz.scale.linear_scale.to_ticks = (function active_viz$scale$linear_scale$to_ticks(p__10528){
var map__10529 = p__10528;
var map__10529__$1 = ((((!((map__10529 == null)))?(((((map__10529.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10529.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__10529):map__10529);
var lstep = cljs.core.get.call(null,map__10529__$1,new cljs.core.Keyword(null,"lstep","lstep",-1243990033));
var lmin = cljs.core.get.call(null,map__10529__$1,new cljs.core.Keyword(null,"lmin","lmin",2139111947));
var lmax = cljs.core.get.call(null,map__10529__$1,new cljs.core.Keyword(null,"lmax","lmax",-1390660950));
var current = lmin;
var acc = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [lmin], null);
while(true){
var next = (lstep + cljs.core.first.call(null,acc));
if((next > lmax)){
return acc;
} else {
var G__10531 = next;
var G__10532 = cljs.core.cons.call(null,next,acc);
current = G__10531;
acc = G__10532;
continue;
}
break;
}
});
active_viz.scale.linear_scale.ticks = (function active_viz$scale$linear_scale$ticks(domain_min,domain_max,num_ticks){
var G__10533 = active_viz.ticks.nice_ticks.call(null,domain_min,domain_max,num_ticks);
if((G__10533 == null)){
return null;
} else {
return active_viz.scale.linear_scale.to_ticks.call(null,G__10533);
}
});
active_viz.scale.linear_scale.linear_scale__GT_ticks = (function active_viz$scale$linear_scale$linear_scale__GT_ticks(scale,num_ticks){
return active_viz.scale.linear_scale.ticks.call(null,active_viz.scale.types.scale_domain_min.call(null,scale),active_viz.scale.types.scale_domain_max.call(null,scale),num_ticks);
});

//# sourceMappingURL=linear_scale.js.map
