// Compiled by ClojureScript 1.10.339 {}
goog.provide('active_viz.interpolation.monotone_cubic_interpolation');
goog.require('cljs.core');
goog.require('active_viz.interpolation.util');
/**
 * Compute the normalized tangent vector from the slopes. Note that if x is
 *   not monotonic, it's possible that the slope will be infinite, so we protect
 *   against NaN by setting the coordinate to zero.
 */
active_viz.interpolation.monotone_cubic_interpolation.normalize_tagents = (function active_viz$interpolation$monotone_cubic_interpolation$normalize_tagents(points,m,smoothness){
var f = (function active_viz$interpolation$monotone_cubic_interpolation$normalize_tagents_$_f(p_1,p_PLUS_1,m__$1){
var vec__12263 = p_1;
var x1 = cljs.core.nth.call(null,vec__12263,(0),null);
var _ = cljs.core.nth.call(null,vec__12263,(1),null);
var vec__12266 = p_PLUS_1;
var x2 = cljs.core.nth.call(null,vec__12266,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__12266,(1),null);
var q = (smoothness * (Math.pow(m__$1,(2)) + (1)));
var s = ((x2 - x1) / q);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [active_viz.interpolation.util.number_or_zero.call(null,s),active_viz.interpolation.util.number_or_zero.call(null,(m__$1 * s))], null);
});
var c = cljs.core.count.call(null,m);
return cljs.core.map_indexed.call(null,((function (c){
return (function (idx,m_SINGLEQUOTE_){
if(cljs.core._EQ_.call(null,(0),idx)){
return f.call(null,cljs.core.first.call(null,points),cljs.core.get.call(null,points,(idx + (1))),m_SINGLEQUOTE_);
} else {
if(cljs.core._EQ_.call(null,(idx - (1)),c)){
return f.call(null,cljs.core.get.call(null,points,(idx - (1))),cljs.core.last.call(null,points),m_SINGLEQUOTE_);
} else {
return f.call(null,cljs.core.get.call(null,points,(idx - (1))),cljs.core.get.call(null,points,(idx + (1))),m_SINGLEQUOTE_);

}
}
});})(c))
,m);
});
/**
 * Interpolates the given points using Fritsch-Carlson Monotone cubic Hermite interpolation. 
 * 
 * 
 *   Expects at least 3 points sorted by the x coordinate. 
 * 
 * 
 *   An optional parameter "smoothness" can be specified to adjust smoothing. A value between 2 and 10 is
 *   recommended, where 2 is very smooth and 10 less smooth. 
 * 
 *   Note: A proper smoothing factor depends on the data-scale described by points. Defaults to 6. 
 * 
 * 
 *   Returns an array of tangent vectors (which is a vector of length 2). 
 * 
 * 
 *   For details, see http://en.wikipedia.org/wiki/Monotone_cubic_interpolation
 */
active_viz.interpolation.monotone_cubic_interpolation.interpolate = (function active_viz$interpolation$monotone_cubic_interpolation$interpolate(var_args){
var args__4534__auto__ = [];
var len__4531__auto___12286 = arguments.length;
var i__4532__auto___12287 = (0);
while(true){
if((i__4532__auto___12287 < len__4531__auto___12286)){
args__4534__auto__.push((arguments[i__4532__auto___12287]));

var G__12288 = (i__4532__auto___12287 + (1));
i__4532__auto___12287 = G__12288;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((1) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((1)),(0),null)):null);
return active_viz.interpolation.monotone_cubic_interpolation.interpolate.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4535__auto__);
});

active_viz.interpolation.monotone_cubic_interpolation.interpolate.cljs$core$IFn$_invoke$arity$variadic = (function (points,p__12271){
var vec__12272 = p__12271;
var smoothness = cljs.core.nth.call(null,vec__12272,(0),null);
var smoothness__$1 = (function (){var or__3949__auto__ = smoothness;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return (6);
}
})();
var points__$1 = ((cljs.core.vector_QMARK_.call(null,points))?points:cljs.core.vec.call(null,points));
var fds = active_viz.interpolation.util.finite_differences.call(null,points__$1);
var p_PLUS_fds = cljs.core.map.call(null,cljs.core.vector,points__$1,fds);
var vec__12275 = cljs.core.first.call(null,p_PLUS_fds);
var p0 = cljs.core.nth.call(null,vec__12275,(0),null);
var m0 = cljs.core.nth.call(null,vec__12275,(1),null);
var p_PLUS_fds_STAR_ = cljs.core.rest.call(null,p_PLUS_fds);
var $ = p_PLUS_fds_STAR_;
var $__$1 = cljs.core.reduce.call(null,((function ($,smoothness__$1,points__$1,fds,p_PLUS_fds,vec__12275,p0,m0,p_PLUS_fds_STAR_,vec__12272,smoothness){
return (function (p__12278,p__12279){
var vec__12280 = p__12278;
var acc = cljs.core.nth.call(null,vec__12280,(0),null);
var prev_point = cljs.core.nth.call(null,vec__12280,(1),null);
var vec__12283 = p__12279;
var point = cljs.core.nth.call(null,vec__12283,(0),null);
var m = cljs.core.nth.call(null,vec__12283,(1),null);
var prev_m = cljs.core.first.call(null,acc);
var acc_STAR_ = cljs.core.rest.call(null,acc);
var d = active_viz.interpolation.util.slope.call(null,prev_point,point);
if((active_viz.interpolation.util.eps > Math.abs(d))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cons.call(null,(0),cljs.core.cons.call(null,(0),acc_STAR_)),point], null);
} else {
var a = (prev_m / d);
var b = (m / d);
var s = ((b * b) + (a * a));
if((s > (9))){
var s__$1 = ((d * (3)) / Math.sqrt(s));
var m_prev_STAR_ = (s__$1 * a);
var m_STAR_ = (s__$1 * b);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cons.call(null,m_STAR_,cljs.core.cons.call(null,m_prev_STAR_,acc_STAR_)),point], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cons.call(null,m,acc),point], null);
}
}
});})($,smoothness__$1,points__$1,fds,p_PLUS_fds,vec__12275,p0,m0,p_PLUS_fds_STAR_,vec__12272,smoothness))
,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [m0], null),p0], null),$);
var $__$2 = cljs.core.first.call(null,$__$1);
var $__$3 = cljs.core.reverse.call(null,$__$2);
return active_viz.interpolation.monotone_cubic_interpolation.normalize_tagents.call(null,cljs.core.vec.call(null,points__$1),$__$3,smoothness__$1);
});

active_viz.interpolation.monotone_cubic_interpolation.interpolate.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
active_viz.interpolation.monotone_cubic_interpolation.interpolate.cljs$lang$applyTo = (function (seq12269){
var G__12270 = cljs.core.first.call(null,seq12269);
var seq12269__$1 = cljs.core.next.call(null,seq12269);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12270,seq12269__$1);
});


//# sourceMappingURL=monotone_cubic_interpolation.js.map
