// Compiled by ClojureScript 1.10.339 {}
goog.provide('active_viz.interpolation.util');
goog.require('cljs.core');
active_viz.interpolation.util.eps = Number.EPSILON;
/**
 * Computes the slope described by two points
 */
active_viz.interpolation.util.slope = (function active_viz$interpolation$util$slope(p__7577,p__7578){
var vec__7579 = p__7577;
var x1 = cljs.core.nth.call(null,vec__7579,(0),null);
var y1 = cljs.core.nth.call(null,vec__7579,(1),null);
var vec__7582 = p__7578;
var x2 = cljs.core.nth.call(null,vec__7582,(0),null);
var y2 = cljs.core.nth.call(null,vec__7582,(1),null);
return ((y2 - y1) / (x2 - x1));
});
/**
 * Computes the 3 point differences for each point
 *   https://en.wikipedia.org/wiki/Cubic_Hermite_spline#Finite_difference 
 */
active_viz.interpolation.util.finite_differences = (function active_viz$interpolation$util$finite_differences(points){
var p0 = cljs.core.first.call(null,points);
var p1 = cljs.core.second.call(null,points);
var points_STAR_ = cljs.core.drop.call(null,(2),points);
var d = active_viz.interpolation.util.slope.call(null,p0,p1);
return cljs.core.reverse.call(null,cljs.core.first.call(null,cljs.core.reduce.call(null,((function (p0,p1,points_STAR_,d){
return (function (p__7585,point){
var vec__7586 = p__7585;
var acc = cljs.core.nth.call(null,vec__7586,(0),null);
var prev_point = cljs.core.nth.call(null,vec__7586,(1),null);
var d__$1 = cljs.core.first.call(null,acc);
var d_STAR_ = ((d__$1 + active_viz.interpolation.util.slope.call(null,prev_point,point)) / (2));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cons.call(null,d_STAR_,acc),point], null);
});})(p0,p1,points_STAR_,d))
,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [d], null),p1], null),points)));
});
/**
 * If n is NaN it returns 0 else n
 */
active_viz.interpolation.util.number_or_zero = (function active_viz$interpolation$util$number_or_zero(n){
if(cljs.core.truth_(Number.isNaN(n))){
return (0);
} else {
return n;
}
});
active_viz.interpolation.util.distance = (function active_viz$interpolation$util$distance(p__7589,p__7590){
var vec__7591 = p__7589;
var x1 = cljs.core.nth.call(null,vec__7591,(0),null);
var y1 = cljs.core.nth.call(null,vec__7591,(1),null);
var vec__7594 = p__7590;
var x2 = cljs.core.nth.call(null,vec__7594,(0),null);
var y2 = cljs.core.nth.call(null,vec__7594,(1),null);
return Math.sqrt((Math.pow((x2 - x1),(2)) + Math.pow((y2 - y1),(2))));
});
active_viz.interpolation.util.angle = (function active_viz$interpolation$util$angle(p__7597,p__7598){
var vec__7599 = p__7597;
var x1 = cljs.core.nth.call(null,vec__7599,(0),null);
var y1 = cljs.core.nth.call(null,vec__7599,(1),null);
var vec__7602 = p__7598;
var x2 = cljs.core.nth.call(null,vec__7602,(0),null);
var y2 = cljs.core.nth.call(null,vec__7602,(1),null);
return Math.atan2((y2 - y1),(x2 - x1));
});

//# sourceMappingURL=util.js.map
