(ns active-viz.util
  (:require [active.clojure.record :as rec :refer-macros [define-record-type]]))


(define-record-type Scale
  (make-scale domain-min domain-max range-min range-max scale-fn)
  scale?
  [domain-min scale-domain-min
   domain-max scale-domain-max
   range-min scale-range-min
   range-max scale-range-max
   scale-fn scale-scale-fn])


(defn combine [scale1 scale2]
  (make-scale
    (scale-domain-min scale2)
    (scale-domain-max scale2)
    (scale-range-min scale1)
    (scale-range-max scale1)
    (comp (scale-scale-fn scale1) (scale-scale-fn scale2))))



(defn invert-scale-range [scale]
  (let [min          (scale-range-min scale)
        max          (scale-range-max scale)
        min+max      (+ min max)
        scale-fn     #(- min+max %)
        invert-scale (make-scale min max min max scale-fn)]
    (combine invert-scale scale)))



(defn pad-scale [scale padding]
  (let [prev-min      (scale-range-min scale)
        prev-max      (scale-range-max scale)
        min           (+ padding prev-min)
        max           (+ padding prev-max)
        scale-fn      #(+ padding %)
        padding-scale (make-scale prev-min prev-max min max scale-fn)]
    (combine padding-scale scale)))



(defn pad-zero [scale]
  (let [m (min
            (scale-range-min scale)
            (scale-range-max scale))]
    (if (> 0 m)
      (pad-scale scale (inc (Math/abs m)))
      scale)))


