// Compiled by ClojureScript 1.10.339 {}
goog.provide('active_viz.scale.types');
goog.require('cljs.core');
goog.require('active.clojure.record');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
active_viz.scale.types.Scale = (function (domain_min,domain_max,range_min,range_max,params,succ,__meta,__extmap,__hash){
this.domain_min = domain_min;
this.domain_max = domain_max;
this.range_min = range_min;
this.range_max = range_max;
this.params = params;
this.succ = succ;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
active_viz.scale.types.Scale.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4203__auto__,k__4204__auto__){
var self__ = this;
var this__4203__auto____$1 = this;
return this__4203__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4204__auto__,null);
});

active_viz.scale.types.Scale.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4205__auto__,k8531,else__4206__auto__){
var self__ = this;
var this__4205__auto____$1 = this;
var G__8535 = k8531;
var G__8535__$1 = (((G__8535 instanceof cljs.core.Keyword))?G__8535.fqn:null);
switch (G__8535__$1) {
case "domain-min":
return self__.domain_min;

break;
case "domain-max":
return self__.domain_max;

break;
case "range-min":
return self__.range_min;

break;
case "range-max":
return self__.range_max;

break;
case "params":
return self__.params;

break;
case "succ":
return self__.succ;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k8531,else__4206__auto__);

}
});

active_viz.scale.types.Scale.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4217__auto__,writer__4218__auto__,opts__4219__auto__){
var self__ = this;
var this__4217__auto____$1 = this;
var pr_pair__4220__auto__ = ((function (this__4217__auto____$1){
return (function (keyval__4221__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4218__auto__,cljs.core.pr_writer,""," ","",opts__4219__auto__,keyval__4221__auto__);
});})(this__4217__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__4218__auto__,pr_pair__4220__auto__,"#active-viz.scale.types.Scale{",", ","}",opts__4219__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"domain-min","domain-min",-1046273935),self__.domain_min],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"domain-max","domain-max",150908843),self__.domain_max],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"range-min","range-min",-797195752),self__.range_min],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"range-max","range-max",-1850570674),self__.range_max],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"params","params",710516235),self__.params],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"succ","succ",1386276271),self__.succ],null))], null),self__.__extmap));
});

active_viz.scale.types.Scale.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__8530){
var self__ = this;
var G__8530__$1 = this;
return (new cljs.core.RecordIter((0),G__8530__$1,6,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"domain-min","domain-min",-1046273935),new cljs.core.Keyword(null,"domain-max","domain-max",150908843),new cljs.core.Keyword(null,"range-min","range-min",-797195752),new cljs.core.Keyword(null,"range-max","range-max",-1850570674),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"succ","succ",1386276271)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

active_viz.scale.types.Scale.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4201__auto__){
var self__ = this;
var this__4201__auto____$1 = this;
return self__.__meta;
});

active_viz.scale.types.Scale.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4198__auto__){
var self__ = this;
var this__4198__auto____$1 = this;
return (new active_viz.scale.types.Scale(self__.domain_min,self__.domain_max,self__.range_min,self__.range_max,self__.params,self__.succ,self__.__meta,self__.__extmap,self__.__hash));
});

active_viz.scale.types.Scale.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4207__auto__){
var self__ = this;
var this__4207__auto____$1 = this;
return (6 + cljs.core.count.call(null,self__.__extmap));
});

active_viz.scale.types.Scale.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4199__auto__){
var self__ = this;
var this__4199__auto____$1 = this;
var h__4061__auto__ = self__.__hash;
if(!((h__4061__auto__ == null))){
return h__4061__auto__;
} else {
var h__4061__auto____$1 = ((function (h__4061__auto__,this__4199__auto____$1){
return (function (coll__4200__auto__){
return (703032104 ^ cljs.core.hash_unordered_coll.call(null,coll__4200__auto__));
});})(h__4061__auto__,this__4199__auto____$1))
.call(null,this__4199__auto____$1);
self__.__hash = h__4061__auto____$1;

return h__4061__auto____$1;
}
});

active_viz.scale.types.Scale.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this8532,other8533){
var self__ = this;
var this8532__$1 = this;
return ((!((other8533 == null))) && ((this8532__$1.constructor === other8533.constructor)) && (cljs.core._EQ_.call(null,this8532__$1.domain_min,other8533.domain_min)) && (cljs.core._EQ_.call(null,this8532__$1.domain_max,other8533.domain_max)) && (cljs.core._EQ_.call(null,this8532__$1.range_min,other8533.range_min)) && (cljs.core._EQ_.call(null,this8532__$1.range_max,other8533.range_max)) && (cljs.core._EQ_.call(null,this8532__$1.params,other8533.params)) && (cljs.core._EQ_.call(null,this8532__$1.succ,other8533.succ)) && (cljs.core._EQ_.call(null,this8532__$1.__extmap,other8533.__extmap)));
});

active_viz.scale.types.Scale.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4212__auto__,k__4213__auto__){
var self__ = this;
var this__4212__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"params","params",710516235),null,new cljs.core.Keyword(null,"domain-max","domain-max",150908843),null,new cljs.core.Keyword(null,"range-max","range-max",-1850570674),null,new cljs.core.Keyword(null,"succ","succ",1386276271),null,new cljs.core.Keyword(null,"domain-min","domain-min",-1046273935),null,new cljs.core.Keyword(null,"range-min","range-min",-797195752),null], null), null),k__4213__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4212__auto____$1),self__.__meta),k__4213__auto__);
} else {
return (new active_viz.scale.types.Scale(self__.domain_min,self__.domain_max,self__.range_min,self__.range_max,self__.params,self__.succ,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4213__auto__)),null));
}
});

active_viz.scale.types.Scale.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4210__auto__,k__4211__auto__,G__8530){
var self__ = this;
var this__4210__auto____$1 = this;
var pred__8536 = cljs.core.keyword_identical_QMARK_;
var expr__8537 = k__4211__auto__;
if(cljs.core.truth_(pred__8536.call(null,new cljs.core.Keyword(null,"domain-min","domain-min",-1046273935),expr__8537))){
return (new active_viz.scale.types.Scale(G__8530,self__.domain_max,self__.range_min,self__.range_max,self__.params,self__.succ,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__8536.call(null,new cljs.core.Keyword(null,"domain-max","domain-max",150908843),expr__8537))){
return (new active_viz.scale.types.Scale(self__.domain_min,G__8530,self__.range_min,self__.range_max,self__.params,self__.succ,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__8536.call(null,new cljs.core.Keyword(null,"range-min","range-min",-797195752),expr__8537))){
return (new active_viz.scale.types.Scale(self__.domain_min,self__.domain_max,G__8530,self__.range_max,self__.params,self__.succ,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__8536.call(null,new cljs.core.Keyword(null,"range-max","range-max",-1850570674),expr__8537))){
return (new active_viz.scale.types.Scale(self__.domain_min,self__.domain_max,self__.range_min,G__8530,self__.params,self__.succ,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__8536.call(null,new cljs.core.Keyword(null,"params","params",710516235),expr__8537))){
return (new active_viz.scale.types.Scale(self__.domain_min,self__.domain_max,self__.range_min,self__.range_max,G__8530,self__.succ,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__8536.call(null,new cljs.core.Keyword(null,"succ","succ",1386276271),expr__8537))){
return (new active_viz.scale.types.Scale(self__.domain_min,self__.domain_max,self__.range_min,self__.range_max,self__.params,G__8530,self__.__meta,self__.__extmap,null));
} else {
return (new active_viz.scale.types.Scale(self__.domain_min,self__.domain_max,self__.range_min,self__.range_max,self__.params,self__.succ,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4211__auto__,G__8530),null));
}
}
}
}
}
}
});

active_viz.scale.types.Scale.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4215__auto__){
var self__ = this;
var this__4215__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"domain-min","domain-min",-1046273935),self__.domain_min,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"domain-max","domain-max",150908843),self__.domain_max,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"range-min","range-min",-797195752),self__.range_min,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"range-max","range-max",-1850570674),self__.range_max,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"params","params",710516235),self__.params,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"succ","succ",1386276271),self__.succ,null))], null),self__.__extmap));
});

active_viz.scale.types.Scale.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4202__auto__,G__8530){
var self__ = this;
var this__4202__auto____$1 = this;
return (new active_viz.scale.types.Scale(self__.domain_min,self__.domain_max,self__.range_min,self__.range_max,self__.params,self__.succ,G__8530,self__.__extmap,self__.__hash));
});

active_viz.scale.types.Scale.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4208__auto__,entry__4209__auto__){
var self__ = this;
var this__4208__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4209__auto__)){
return this__4208__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4209__auto__,(0)),cljs.core._nth.call(null,entry__4209__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4208__auto____$1,entry__4209__auto__);
}
});

active_viz.scale.types.Scale.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"domain-min","domain-min",594257592,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"minimum domain value"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"domain-max","domain-max",1791440370,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"maximum domain value"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"range-min","range-min",843335775,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"minimum target range value. Expected to be numerical."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"range-max","range-max",-210039147,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"maximum target range value. Expected to be numerical."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"params","params",-1943919534,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"mapping params from domain to range, defining the type of scale"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"succ","succ",-1268159498,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"successor of the scale, when combined"], null))], null);
});

active_viz.scale.types.Scale.cljs$lang$type = true;

active_viz.scale.types.Scale.cljs$lang$ctorPrSeq = (function (this__4240__auto__){
return (new cljs.core.List(null,"active-viz.scale.types/Scale",null,(1),null));
});

active_viz.scale.types.Scale.cljs$lang$ctorPrWriter = (function (this__4240__auto__,writer__4241__auto__){
return cljs.core._write.call(null,writer__4241__auto__,"active-viz.scale.types/Scale");
});

/**
 * Positional factory function for active-viz.scale.types/Scale.
 */
active_viz.scale.types.__GT_Scale = (function active_viz$scale$types$__GT_Scale(domain_min,domain_max,range_min,range_max,params,succ){
return (new active_viz.scale.types.Scale(domain_min,domain_max,range_min,range_max,params,succ,null,null,null));
});

/**
 * Factory function for active-viz.scale.types/Scale, taking a map of keywords to field values.
 */
active_viz.scale.types.map__GT_Scale = (function active_viz$scale$types$map__GT_Scale(G__8534){
var extmap__4236__auto__ = (function (){var G__8539 = cljs.core.dissoc.call(null,G__8534,new cljs.core.Keyword(null,"domain-min","domain-min",-1046273935),new cljs.core.Keyword(null,"domain-max","domain-max",150908843),new cljs.core.Keyword(null,"range-min","range-min",-797195752),new cljs.core.Keyword(null,"range-max","range-max",-1850570674),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"succ","succ",1386276271));
if(cljs.core.record_QMARK_.call(null,G__8534)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__8539);
} else {
return G__8539;
}
})();
return (new active_viz.scale.types.Scale(new cljs.core.Keyword(null,"domain-min","domain-min",-1046273935).cljs$core$IFn$_invoke$arity$1(G__8534),new cljs.core.Keyword(null,"domain-max","domain-max",150908843).cljs$core$IFn$_invoke$arity$1(G__8534),new cljs.core.Keyword(null,"range-min","range-min",-797195752).cljs$core$IFn$_invoke$arity$1(G__8534),new cljs.core.Keyword(null,"range-max","range-max",-1850570674).cljs$core$IFn$_invoke$arity$1(G__8534),new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(G__8534),new cljs.core.Keyword(null,"succ","succ",1386276271).cljs$core$IFn$_invoke$arity$1(G__8534),null,cljs.core.not_empty.call(null,extmap__4236__auto__),null));
});


/**
 * Is object a `Scale` record? See [[active-viz.scale.types/make-scale]].
 */
active_viz.scale.types.scale_QMARK_ = (function active_viz$scale$types$scale_QMARK_(x__8461__auto__){
return (x__8461__auto__ instanceof active_viz.scale.types.Scale);
});

/**
 * Construct a `Scale` (A scale represents a function from a domain described by `domain-min` and `domain-max` into a
 *   a target range between `range-min` and `range-max`. The range values must be numerical.
 *   Domain boundaries as well as range boundaries are expected to be ordered correctly.
 *   The actual mapping is defined in `scale-fn`) record.
 * 
 * `domain-min` (minimum domain value): access via [[active-viz.scale.types/scale-domain-min]]
 * `domain-max` (maximum domain value): access via [[active-viz.scale.types/scale-domain-max]]
 * `range-min` (minimum target range value. Expected to be numerical.): access via [[active-viz.scale.types/scale-range-min]]
 * `range-max` (maximum target range value. Expected to be numerical.): access via [[active-viz.scale.types/scale-range-max]]
 * `params` (mapping params from domain to range, defining the type of scale): access via [[active-viz.scale.types/scale-params]]
 * `succ` (successor of the scale, when combined): access via [[active-viz.scale.types/scale-succ]]
 */
active_viz.scale.types.make_scale = (function active_viz$scale$types$make_scale(domain_min,domain_max,range_min,range_max,params,succ){
return (new active_viz.scale.types.Scale(domain_min,domain_max,range_min,range_max,params,succ,null,null,null));
});







/**
 * Lens for the `domain-min` field (minimum domain value) from a [[Scale]] record. See [[active-viz.scale.types/make-scale]].
 */
active_viz.scale.types.scale_domain_min = active.clojure.lens.lens.call(null,(function (rec__8458__auto__){
active.clojure.record.check_type.call(null,active_viz.scale.types.Scale,rec__8458__auto__);

return rec__8458__auto__.domain_min;
}),(function (data__8459__auto__,v__8460__auto__){
return active_viz.scale.types.make_scale.call(null,v__8460__auto__,active_viz.scale.types.scale_domain_max.call(null,data__8459__auto__),active_viz.scale.types.scale_range_min.call(null,data__8459__auto__),active_viz.scale.types.scale_range_max.call(null,data__8459__auto__),active_viz.scale.types.scale_params.call(null,data__8459__auto__),active_viz.scale.types.scale_succ.call(null,data__8459__auto__));
}));


/**
 * Lens for the `domain-max` field (maximum domain value) from a [[Scale]] record. See [[active-viz.scale.types/make-scale]].
 */
active_viz.scale.types.scale_domain_max = active.clojure.lens.lens.call(null,(function (rec__8458__auto__){
active.clojure.record.check_type.call(null,active_viz.scale.types.Scale,rec__8458__auto__);

return rec__8458__auto__.domain_max;
}),(function (data__8459__auto__,v__8460__auto__){
return active_viz.scale.types.make_scale.call(null,active_viz.scale.types.scale_domain_min.call(null,data__8459__auto__),v__8460__auto__,active_viz.scale.types.scale_range_min.call(null,data__8459__auto__),active_viz.scale.types.scale_range_max.call(null,data__8459__auto__),active_viz.scale.types.scale_params.call(null,data__8459__auto__),active_viz.scale.types.scale_succ.call(null,data__8459__auto__));
}));


/**
 * Lens for the `range-min` field (minimum target range value. Expected to be numerical.) from a [[Scale]] record. See [[active-viz.scale.types/make-scale]].
 */
active_viz.scale.types.scale_range_min = active.clojure.lens.lens.call(null,(function (rec__8458__auto__){
active.clojure.record.check_type.call(null,active_viz.scale.types.Scale,rec__8458__auto__);

return rec__8458__auto__.range_min;
}),(function (data__8459__auto__,v__8460__auto__){
return active_viz.scale.types.make_scale.call(null,active_viz.scale.types.scale_domain_min.call(null,data__8459__auto__),active_viz.scale.types.scale_domain_max.call(null,data__8459__auto__),v__8460__auto__,active_viz.scale.types.scale_range_max.call(null,data__8459__auto__),active_viz.scale.types.scale_params.call(null,data__8459__auto__),active_viz.scale.types.scale_succ.call(null,data__8459__auto__));
}));


/**
 * Lens for the `range-max` field (maximum target range value. Expected to be numerical.) from a [[Scale]] record. See [[active-viz.scale.types/make-scale]].
 */
active_viz.scale.types.scale_range_max = active.clojure.lens.lens.call(null,(function (rec__8458__auto__){
active.clojure.record.check_type.call(null,active_viz.scale.types.Scale,rec__8458__auto__);

return rec__8458__auto__.range_max;
}),(function (data__8459__auto__,v__8460__auto__){
return active_viz.scale.types.make_scale.call(null,active_viz.scale.types.scale_domain_min.call(null,data__8459__auto__),active_viz.scale.types.scale_domain_max.call(null,data__8459__auto__),active_viz.scale.types.scale_range_min.call(null,data__8459__auto__),v__8460__auto__,active_viz.scale.types.scale_params.call(null,data__8459__auto__),active_viz.scale.types.scale_succ.call(null,data__8459__auto__));
}));


/**
 * Lens for the `params` field (mapping params from domain to range, defining the type of scale) from a [[Scale]] record. See [[active-viz.scale.types/make-scale]].
 */
active_viz.scale.types.scale_params = active.clojure.lens.lens.call(null,(function (rec__8458__auto__){
active.clojure.record.check_type.call(null,active_viz.scale.types.Scale,rec__8458__auto__);

return rec__8458__auto__.params;
}),(function (data__8459__auto__,v__8460__auto__){
return active_viz.scale.types.make_scale.call(null,active_viz.scale.types.scale_domain_min.call(null,data__8459__auto__),active_viz.scale.types.scale_domain_max.call(null,data__8459__auto__),active_viz.scale.types.scale_range_min.call(null,data__8459__auto__),active_viz.scale.types.scale_range_max.call(null,data__8459__auto__),v__8460__auto__,active_viz.scale.types.scale_succ.call(null,data__8459__auto__));
}));


/**
 * Lens for the `succ` field (successor of the scale, when combined) from a [[Scale]] record. See [[active-viz.scale.types/make-scale]].
 */
active_viz.scale.types.scale_succ = active.clojure.lens.lens.call(null,(function (rec__8458__auto__){
active.clojure.record.check_type.call(null,active_viz.scale.types.Scale,rec__8458__auto__);

return rec__8458__auto__.succ;
}),(function (data__8459__auto__,v__8460__auto__){
return active_viz.scale.types.make_scale.call(null,active_viz.scale.types.scale_domain_min.call(null,data__8459__auto__),active_viz.scale.types.scale_domain_max.call(null,data__8459__auto__),active_viz.scale.types.scale_range_min.call(null,data__8459__auto__),active_viz.scale.types.scale_range_max.call(null,data__8459__auto__),active_viz.scale.types.scale_params.call(null,data__8459__auto__),v__8460__auto__);
}));


/**
 * @interface
 */
active_viz.scale.types.ScaleFn = function(){};

active_viz.scale.types.call = (function active_viz$scale$types$call(this$,scale,param){
if(((!((this$ == null))) && (!((this$.active_viz$scale$types$ScaleFn$call$arity$3 == null))))){
return this$.active_viz$scale$types$ScaleFn$call$arity$3(this$,scale,param);
} else {
var x__4243__auto__ = (((this$ == null))?null:this$);
var m__4244__auto__ = (active_viz.scale.types.call[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,this$,scale,param);
} else {
var m__4244__auto____$1 = (active_viz.scale.types.call["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,this$,scale,param);
} else {
throw cljs.core.missing_protocol.call(null,"ScaleFn.call",this$);
}
}
}
});

active_viz.scale.types.call_inverse = (function active_viz$scale$types$call_inverse(this$,scale,param){
if(((!((this$ == null))) && (!((this$.active_viz$scale$types$ScaleFn$call_inverse$arity$3 == null))))){
return this$.active_viz$scale$types$ScaleFn$call_inverse$arity$3(this$,scale,param);
} else {
var x__4243__auto__ = (((this$ == null))?null:this$);
var m__4244__auto__ = (active_viz.scale.types.call_inverse[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,this$,scale,param);
} else {
var m__4244__auto____$1 = (active_viz.scale.types.call_inverse["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,this$,scale,param);
} else {
throw cljs.core.missing_protocol.call(null,"ScaleFn.call-inverse",this$);
}
}
}
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {active_viz.scale.types.ScaleFn}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
active_viz.scale.types.Nop = (function (__meta,__extmap,__hash){
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
active_viz.scale.types.Nop.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4203__auto__,k__4204__auto__){
var self__ = this;
var this__4203__auto____$1 = this;
return this__4203__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4204__auto__,null);
});

active_viz.scale.types.Nop.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4205__auto__,k8542,else__4206__auto__){
var self__ = this;
var this__4205__auto____$1 = this;
var G__8546 = k8542;
switch (G__8546) {
default:
return cljs.core.get.call(null,self__.__extmap,k8542,else__4206__auto__);

}
});

active_viz.scale.types.Nop.prototype.active_viz$scale$types$ScaleFn$ = cljs.core.PROTOCOL_SENTINEL;

active_viz.scale.types.Nop.prototype.active_viz$scale$types$ScaleFn$call$arity$3 = (function (_,___$1,param){
var self__ = this;
var ___$2 = this;
return param;
});

active_viz.scale.types.Nop.prototype.active_viz$scale$types$ScaleFn$call_inverse$arity$3 = (function (_,___$1,param){
var self__ = this;
var ___$2 = this;
return param;
});

active_viz.scale.types.Nop.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4217__auto__,writer__4218__auto__,opts__4219__auto__){
var self__ = this;
var this__4217__auto____$1 = this;
var pr_pair__4220__auto__ = ((function (this__4217__auto____$1){
return (function (keyval__4221__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4218__auto__,cljs.core.pr_writer,""," ","",opts__4219__auto__,keyval__4221__auto__);
});})(this__4217__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__4218__auto__,pr_pair__4220__auto__,"#active-viz.scale.types.Nop{",", ","}",opts__4219__auto__,cljs.core.concat.call(null,cljs.core.PersistentVector.EMPTY,self__.__extmap));
});

active_viz.scale.types.Nop.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__8541){
var self__ = this;
var G__8541__$1 = this;
return (new cljs.core.RecordIter((0),G__8541__$1,0,cljs.core.PersistentVector.EMPTY,(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

active_viz.scale.types.Nop.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4201__auto__){
var self__ = this;
var this__4201__auto____$1 = this;
return self__.__meta;
});

active_viz.scale.types.Nop.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4198__auto__){
var self__ = this;
var this__4198__auto____$1 = this;
return (new active_viz.scale.types.Nop(self__.__meta,self__.__extmap,self__.__hash));
});

active_viz.scale.types.Nop.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4207__auto__){
var self__ = this;
var this__4207__auto____$1 = this;
return (0 + cljs.core.count.call(null,self__.__extmap));
});

active_viz.scale.types.Nop.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4199__auto__){
var self__ = this;
var this__4199__auto____$1 = this;
var h__4061__auto__ = self__.__hash;
if(!((h__4061__auto__ == null))){
return h__4061__auto__;
} else {
var h__4061__auto____$1 = ((function (h__4061__auto__,this__4199__auto____$1){
return (function (coll__4200__auto__){
return (-1767918979 ^ cljs.core.hash_unordered_coll.call(null,coll__4200__auto__));
});})(h__4061__auto__,this__4199__auto____$1))
.call(null,this__4199__auto____$1);
self__.__hash = h__4061__auto____$1;

return h__4061__auto____$1;
}
});

active_viz.scale.types.Nop.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this8543,other8544){
var self__ = this;
var this8543__$1 = this;
return ((!((other8544 == null))) && ((this8543__$1.constructor === other8544.constructor)) && (cljs.core._EQ_.call(null,this8543__$1.__extmap,other8544.__extmap)));
});

active_viz.scale.types.Nop.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4212__auto__,k__4213__auto__){
var self__ = this;
var this__4212__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,cljs.core.PersistentHashSet.EMPTY,k__4213__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4212__auto____$1),self__.__meta),k__4213__auto__);
} else {
return (new active_viz.scale.types.Nop(self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4213__auto__)),null));
}
});

active_viz.scale.types.Nop.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4210__auto__,k__4211__auto__,G__8541){
var self__ = this;
var this__4210__auto____$1 = this;
var pred__8547 = cljs.core.keyword_identical_QMARK_;
var expr__8548 = k__4211__auto__;
return (new active_viz.scale.types.Nop(self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4211__auto__,G__8541),null));
});

active_viz.scale.types.Nop.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4215__auto__){
var self__ = this;
var this__4215__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core.PersistentVector.EMPTY,self__.__extmap));
});

active_viz.scale.types.Nop.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4202__auto__,G__8541){
var self__ = this;
var this__4202__auto____$1 = this;
return (new active_viz.scale.types.Nop(G__8541,self__.__extmap,self__.__hash));
});

active_viz.scale.types.Nop.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4208__auto__,entry__4209__auto__){
var self__ = this;
var this__4208__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4209__auto__)){
return this__4208__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4209__auto__,(0)),cljs.core._nth.call(null,entry__4209__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4208__auto____$1,entry__4209__auto__);
}
});

active_viz.scale.types.Nop.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

active_viz.scale.types.Nop.cljs$lang$type = true;

active_viz.scale.types.Nop.cljs$lang$ctorPrSeq = (function (this__4240__auto__){
return (new cljs.core.List(null,"active-viz.scale.types/Nop",null,(1),null));
});

active_viz.scale.types.Nop.cljs$lang$ctorPrWriter = (function (this__4240__auto__,writer__4241__auto__){
return cljs.core._write.call(null,writer__4241__auto__,"active-viz.scale.types/Nop");
});

/**
 * Positional factory function for active-viz.scale.types/Nop.
 */
active_viz.scale.types.__GT_Nop = (function active_viz$scale$types$__GT_Nop(){
return (new active_viz.scale.types.Nop(null,null,null));
});

/**
 * Factory function for active-viz.scale.types/Nop, taking a map of keywords to field values.
 */
active_viz.scale.types.map__GT_Nop = (function active_viz$scale$types$map__GT_Nop(G__8545){
var extmap__4236__auto__ = (function (){var G__8550 = cljs.core.dissoc.call(null,G__8545);
if(cljs.core.record_QMARK_.call(null,G__8545)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__8550);
} else {
return G__8550;
}
})();
return (new active_viz.scale.types.Nop(null,cljs.core.not_empty.call(null,extmap__4236__auto__),null));
});


/**
 * Is object a `Nop` record? See [[active-viz.scale.types/make-nop]].
 */
active_viz.scale.types.nop_QMARK_ = (function active_viz$scale$types$nop_QMARK_(x__8461__auto__){
return (x__8461__auto__ instanceof active_viz.scale.types.Nop);
});

/**
 * Construct a `Nop` record.
 */
active_viz.scale.types.make_nop = (function active_viz$scale$types$make_nop(){
return (new active_viz.scale.types.Nop(null,null,null));
});

active_viz.scale.types.nop = active_viz.scale.types.make_nop.call(null);

//# sourceMappingURL=types.js.map
