// Compiled by ClojureScript 1.10.339 {}
goog.provide('active_viz.scale.util');
goog.require('cljs.core');
goog.require('active.clojure.record');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
active_viz.scale.util.Scale = (function (domain_min,domain_max,range_min,range_max,scale_fn,__meta,__extmap,__hash){
this.domain_min = domain_min;
this.domain_max = domain_max;
this.range_min = range_min;
this.range_max = range_max;
this.scale_fn = scale_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
active_viz.scale.util.Scale.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4203__auto__,k__4204__auto__){
var self__ = this;
var this__4203__auto____$1 = this;
return this__4203__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4204__auto__,null);
});

active_viz.scale.util.Scale.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4205__auto__,k8580,else__4206__auto__){
var self__ = this;
var this__4205__auto____$1 = this;
var G__8584 = k8580;
var G__8584__$1 = (((G__8584 instanceof cljs.core.Keyword))?G__8584.fqn:null);
switch (G__8584__$1) {
case "domain-min":
return self__.domain_min;

break;
case "domain-max":
return self__.domain_max;

break;
case "range-min":
return self__.range_min;

break;
case "range-max":
return self__.range_max;

break;
case "scale-fn":
return self__.scale_fn;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k8580,else__4206__auto__);

}
});

active_viz.scale.util.Scale.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4217__auto__,writer__4218__auto__,opts__4219__auto__){
var self__ = this;
var this__4217__auto____$1 = this;
var pr_pair__4220__auto__ = ((function (this__4217__auto____$1){
return (function (keyval__4221__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4218__auto__,cljs.core.pr_writer,""," ","",opts__4219__auto__,keyval__4221__auto__);
});})(this__4217__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__4218__auto__,pr_pair__4220__auto__,"#active-viz.scale.util.Scale{",", ","}",opts__4219__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"domain-min","domain-min",-1046273935),self__.domain_min],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"domain-max","domain-max",150908843),self__.domain_max],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"range-min","range-min",-797195752),self__.range_min],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"range-max","range-max",-1850570674),self__.range_max],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"scale-fn","scale-fn",1221388760),self__.scale_fn],null))], null),self__.__extmap));
});

active_viz.scale.util.Scale.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__8579){
var self__ = this;
var G__8579__$1 = this;
return (new cljs.core.RecordIter((0),G__8579__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"domain-min","domain-min",-1046273935),new cljs.core.Keyword(null,"domain-max","domain-max",150908843),new cljs.core.Keyword(null,"range-min","range-min",-797195752),new cljs.core.Keyword(null,"range-max","range-max",-1850570674),new cljs.core.Keyword(null,"scale-fn","scale-fn",1221388760)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

active_viz.scale.util.Scale.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4201__auto__){
var self__ = this;
var this__4201__auto____$1 = this;
return self__.__meta;
});

active_viz.scale.util.Scale.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4198__auto__){
var self__ = this;
var this__4198__auto____$1 = this;
return (new active_viz.scale.util.Scale(self__.domain_min,self__.domain_max,self__.range_min,self__.range_max,self__.scale_fn,self__.__meta,self__.__extmap,self__.__hash));
});

active_viz.scale.util.Scale.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4207__auto__){
var self__ = this;
var this__4207__auto____$1 = this;
return (5 + cljs.core.count.call(null,self__.__extmap));
});

active_viz.scale.util.Scale.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4199__auto__){
var self__ = this;
var this__4199__auto____$1 = this;
var h__4061__auto__ = self__.__hash;
if(!((h__4061__auto__ == null))){
return h__4061__auto__;
} else {
var h__4061__auto____$1 = ((function (h__4061__auto__,this__4199__auto____$1){
return (function (coll__4200__auto__){
return (-1178476811 ^ cljs.core.hash_unordered_coll.call(null,coll__4200__auto__));
});})(h__4061__auto__,this__4199__auto____$1))
.call(null,this__4199__auto____$1);
self__.__hash = h__4061__auto____$1;

return h__4061__auto____$1;
}
});

active_viz.scale.util.Scale.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this8581,other8582){
var self__ = this;
var this8581__$1 = this;
return ((!((other8582 == null))) && ((this8581__$1.constructor === other8582.constructor)) && (cljs.core._EQ_.call(null,this8581__$1.domain_min,other8582.domain_min)) && (cljs.core._EQ_.call(null,this8581__$1.domain_max,other8582.domain_max)) && (cljs.core._EQ_.call(null,this8581__$1.range_min,other8582.range_min)) && (cljs.core._EQ_.call(null,this8581__$1.range_max,other8582.range_max)) && (cljs.core._EQ_.call(null,this8581__$1.scale_fn,other8582.scale_fn)) && (cljs.core._EQ_.call(null,this8581__$1.__extmap,other8582.__extmap)));
});

active_viz.scale.util.Scale.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4212__auto__,k__4213__auto__){
var self__ = this;
var this__4212__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"domain-max","domain-max",150908843),null,new cljs.core.Keyword(null,"range-max","range-max",-1850570674),null,new cljs.core.Keyword(null,"domain-min","domain-min",-1046273935),null,new cljs.core.Keyword(null,"scale-fn","scale-fn",1221388760),null,new cljs.core.Keyword(null,"range-min","range-min",-797195752),null], null), null),k__4213__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4212__auto____$1),self__.__meta),k__4213__auto__);
} else {
return (new active_viz.scale.util.Scale(self__.domain_min,self__.domain_max,self__.range_min,self__.range_max,self__.scale_fn,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4213__auto__)),null));
}
});

active_viz.scale.util.Scale.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4210__auto__,k__4211__auto__,G__8579){
var self__ = this;
var this__4210__auto____$1 = this;
var pred__8585 = cljs.core.keyword_identical_QMARK_;
var expr__8586 = k__4211__auto__;
if(cljs.core.truth_(pred__8585.call(null,new cljs.core.Keyword(null,"domain-min","domain-min",-1046273935),expr__8586))){
return (new active_viz.scale.util.Scale(G__8579,self__.domain_max,self__.range_min,self__.range_max,self__.scale_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__8585.call(null,new cljs.core.Keyword(null,"domain-max","domain-max",150908843),expr__8586))){
return (new active_viz.scale.util.Scale(self__.domain_min,G__8579,self__.range_min,self__.range_max,self__.scale_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__8585.call(null,new cljs.core.Keyword(null,"range-min","range-min",-797195752),expr__8586))){
return (new active_viz.scale.util.Scale(self__.domain_min,self__.domain_max,G__8579,self__.range_max,self__.scale_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__8585.call(null,new cljs.core.Keyword(null,"range-max","range-max",-1850570674),expr__8586))){
return (new active_viz.scale.util.Scale(self__.domain_min,self__.domain_max,self__.range_min,G__8579,self__.scale_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__8585.call(null,new cljs.core.Keyword(null,"scale-fn","scale-fn",1221388760),expr__8586))){
return (new active_viz.scale.util.Scale(self__.domain_min,self__.domain_max,self__.range_min,self__.range_max,G__8579,self__.__meta,self__.__extmap,null));
} else {
return (new active_viz.scale.util.Scale(self__.domain_min,self__.domain_max,self__.range_min,self__.range_max,self__.scale_fn,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4211__auto__,G__8579),null));
}
}
}
}
}
});

active_viz.scale.util.Scale.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4215__auto__){
var self__ = this;
var this__4215__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"domain-min","domain-min",-1046273935),self__.domain_min,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"domain-max","domain-max",150908843),self__.domain_max,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"range-min","range-min",-797195752),self__.range_min,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"range-max","range-max",-1850570674),self__.range_max,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"scale-fn","scale-fn",1221388760),self__.scale_fn,null))], null),self__.__extmap));
});

active_viz.scale.util.Scale.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4202__auto__,G__8579){
var self__ = this;
var this__4202__auto____$1 = this;
return (new active_viz.scale.util.Scale(self__.domain_min,self__.domain_max,self__.range_min,self__.range_max,self__.scale_fn,G__8579,self__.__extmap,self__.__hash));
});

active_viz.scale.util.Scale.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4208__auto__,entry__4209__auto__){
var self__ = this;
var this__4208__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4209__auto__)){
return this__4208__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4209__auto__,(0)),cljs.core._nth.call(null,entry__4209__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4208__auto____$1,entry__4209__auto__);
}
});

active_viz.scale.util.Scale.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"domain-min","domain-min",594257592,null),new cljs.core.Symbol(null,"domain-max","domain-max",1791440370,null),new cljs.core.Symbol(null,"range-min","range-min",843335775,null),new cljs.core.Symbol(null,"range-max","range-max",-210039147,null),new cljs.core.Symbol(null,"scale-fn","scale-fn",-1433047009,null)], null);
});

active_viz.scale.util.Scale.cljs$lang$type = true;

active_viz.scale.util.Scale.cljs$lang$ctorPrSeq = (function (this__4240__auto__){
return (new cljs.core.List(null,"active-viz.scale.util/Scale",null,(1),null));
});

active_viz.scale.util.Scale.cljs$lang$ctorPrWriter = (function (this__4240__auto__,writer__4241__auto__){
return cljs.core._write.call(null,writer__4241__auto__,"active-viz.scale.util/Scale");
});

/**
 * Positional factory function for active-viz.scale.util/Scale.
 */
active_viz.scale.util.__GT_Scale = (function active_viz$scale$util$__GT_Scale(domain_min,domain_max,range_min,range_max,scale_fn){
return (new active_viz.scale.util.Scale(domain_min,domain_max,range_min,range_max,scale_fn,null,null,null));
});

/**
 * Factory function for active-viz.scale.util/Scale, taking a map of keywords to field values.
 */
active_viz.scale.util.map__GT_Scale = (function active_viz$scale$util$map__GT_Scale(G__8583){
var extmap__4236__auto__ = (function (){var G__8588 = cljs.core.dissoc.call(null,G__8583,new cljs.core.Keyword(null,"domain-min","domain-min",-1046273935),new cljs.core.Keyword(null,"domain-max","domain-max",150908843),new cljs.core.Keyword(null,"range-min","range-min",-797195752),new cljs.core.Keyword(null,"range-max","range-max",-1850570674),new cljs.core.Keyword(null,"scale-fn","scale-fn",1221388760));
if(cljs.core.record_QMARK_.call(null,G__8583)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__8588);
} else {
return G__8588;
}
})();
return (new active_viz.scale.util.Scale(new cljs.core.Keyword(null,"domain-min","domain-min",-1046273935).cljs$core$IFn$_invoke$arity$1(G__8583),new cljs.core.Keyword(null,"domain-max","domain-max",150908843).cljs$core$IFn$_invoke$arity$1(G__8583),new cljs.core.Keyword(null,"range-min","range-min",-797195752).cljs$core$IFn$_invoke$arity$1(G__8583),new cljs.core.Keyword(null,"range-max","range-max",-1850570674).cljs$core$IFn$_invoke$arity$1(G__8583),new cljs.core.Keyword(null,"scale-fn","scale-fn",1221388760).cljs$core$IFn$_invoke$arity$1(G__8583),null,cljs.core.not_empty.call(null,extmap__4236__auto__),null));
});


/**
 * Is object a `Scale` record? See [[active-viz.scale.util/make-scale]].
 */
active_viz.scale.util.scale_QMARK_ = (function active_viz$scale$util$scale_QMARK_(x__8514__auto__){
return (x__8514__auto__ instanceof active_viz.scale.util.Scale);
});

/**
 * Construct a `Scale` (A scale represents a function from a domain described by `domain-min` and `domain-max` into a
 *   a target range between `range-min` and `range-max`. The range values must be numerical.
 *   Domain boundaries as well as range boundaries are expected to be ordered correctly.
 *   The actual mapping is defined in `scale-fn`) record.
 * 
 * `domain-min`: access via [[active-viz.scale.util/scale-domain-min]]
 * `domain-max`: access via [[active-viz.scale.util/scale-domain-max]]
 * `range-min`: access via [[active-viz.scale.util/scale-range-min]]
 * `range-max`: access via [[active-viz.scale.util/scale-range-max]]
 * `scale-fn`: access via [[active-viz.scale.util/scale-scale-fn]]
 */
active_viz.scale.util.make_scale = (function active_viz$scale$util$make_scale(domain_min,domain_max,range_min,range_max,scale_fn){
return (new active_viz.scale.util.Scale(domain_min,domain_max,range_min,range_max,scale_fn,null,null,null));
});






/**
 * Access `domain-min` field from a [[Scale]] record. See [[active-viz.scale.util/make-scale]].
 */
active_viz.scale.util.scale_domain_min = (function active_viz$scale$util$scale_domain_min(rec__8511__auto__){
active.clojure.record.check_type.call(null,active_viz.scale.util.Scale,rec__8511__auto__);

return rec__8511__auto__.domain_min;
});

/**
 * Access `domain-max` field from a [[Scale]] record. See [[active-viz.scale.util/make-scale]].
 */
active_viz.scale.util.scale_domain_max = (function active_viz$scale$util$scale_domain_max(rec__8511__auto__){
active.clojure.record.check_type.call(null,active_viz.scale.util.Scale,rec__8511__auto__);

return rec__8511__auto__.domain_max;
});

/**
 * Access `range-min` field from a [[Scale]] record. See [[active-viz.scale.util/make-scale]].
 */
active_viz.scale.util.scale_range_min = (function active_viz$scale$util$scale_range_min(rec__8511__auto__){
active.clojure.record.check_type.call(null,active_viz.scale.util.Scale,rec__8511__auto__);

return rec__8511__auto__.range_min;
});

/**
 * Access `range-max` field from a [[Scale]] record. See [[active-viz.scale.util/make-scale]].
 */
active_viz.scale.util.scale_range_max = (function active_viz$scale$util$scale_range_max(rec__8511__auto__){
active.clojure.record.check_type.call(null,active_viz.scale.util.Scale,rec__8511__auto__);

return rec__8511__auto__.range_max;
});

/**
 * Access `scale-fn` field from a [[Scale]] record. See [[active-viz.scale.util/make-scale]].
 */
active_viz.scale.util.scale_scale_fn = (function active_viz$scale$util$scale_scale_fn(rec__8511__auto__){
active.clojure.record.check_type.call(null,active_viz.scale.util.Scale,rec__8511__auto__);

return rec__8511__auto__.scale_fn;
});
/**
 * Combines two scales. The resulting scale maps the domain of scale1 to the
 *   range of scale2. `scale-fn` is simply the composition of both scales' `scale-fn`s
 */
active_viz.scale.util.combine = (function active_viz$scale$util$combine(scale1,scale2){
return active_viz.scale.util.make_scale.call(null,active_viz.scale.util.scale_domain_min.call(null,scale2),active_viz.scale.util.scale_domain_max.call(null,scale2),active_viz.scale.util.scale_range_min.call(null,scale1),active_viz.scale.util.scale_range_max.call(null,scale1),cljs.core.comp.call(null,active_viz.scale.util.scale_scale_fn.call(null,scale1),active_viz.scale.util.scale_scale_fn.call(null,scale2)));
});
/**
 * Inverts the range of a scaling, including the invertion of the scale-fn, for the specified range.
 *   This is done by calculating the center of this range and mirroring target values.
 */
active_viz.scale.util.invert_scale_range = (function active_viz$scale$util$invert_scale_range(scale){
var min = active_viz.scale.util.scale_range_min.call(null,scale);
var max = active_viz.scale.util.scale_range_max.call(null,scale);
var min_PLUS_max = (min + max);
var scale_fn = ((function (min,max,min_PLUS_max){
return (function (p1__8590_SHARP_){
return (min_PLUS_max - p1__8590_SHARP_);
});})(min,max,min_PLUS_max))
;
var invert_scale = active_viz.scale.util.make_scale.call(null,min,max,min,max,scale_fn);
return active_viz.scale.util.combine.call(null,invert_scale,scale);
});
/**
 * Pads a scale in the sense of adding a offset defined in `padding` to the target range.
 */
active_viz.scale.util.pad_scale = (function active_viz$scale$util$pad_scale(scale,padding){
var prev_min = active_viz.scale.util.scale_range_min.call(null,scale);
var prev_max = active_viz.scale.util.scale_range_max.call(null,scale);
var min = (padding + prev_min);
var max = (padding + prev_max);
var scale_fn = ((function (prev_min,prev_max,min,max){
return (function (p1__8591_SHARP_){
return (padding + p1__8591_SHARP_);
});})(prev_min,prev_max,min,max))
;
var padding_scale = active_viz.scale.util.make_scale.call(null,prev_min,prev_max,min,max,scale_fn);
return active_viz.scale.util.combine.call(null,padding_scale,scale);
});
/**
 * Pads a range so that it maps to positive values, starting at zero.
 */
active_viz.scale.util.pad_zero = (function active_viz$scale$util$pad_zero(scale){
var negate = (function active_viz$scale$util$pad_zero_$_negate(v){
return ((-1) * v);
});
return active_viz.scale.util.pad_scale.call(null,scale,negate.call(null,(function (){var x__4040__auto__ = active_viz.scale.util.scale_range_min.call(null,scale);
var y__4041__auto__ = active_viz.scale.util.scale_range_max.call(null,scale);
return ((x__4040__auto__ < y__4041__auto__) ? x__4040__auto__ : y__4041__auto__);
})()));
});

//# sourceMappingURL=util.js.map
