(ns active-riemann.system
  (:require [clojure.string :as string])
  (:import [oshi SystemInfo]))

(defonce s (SystemInfo.))

(defn collect-system-cpu-usage
  [callback-fn]
  (loop [previous-ticks (.getSystemCpuLoadTicks (.getProcessor (.getHardware s)))]
    (Thread/sleep 1000)
    (callback-fn (.getSystemCpuLoadBetweenTicks (.getProcessor (.getHardware s)) previous-ticks))
    (recur (.getSystemCpuLoadTicks (.getProcessor (.getHardware s))))))

(defn collect-memory-usage
  [callback-fn]
  (loop []
    (Thread/sleep 1000)
    (callback-fn (double (- 1 (/ (.getAvailable (.getMemory (.getHardware s))) (.getTotal (.getMemory (.getHardware s)))))))
    (recur)))

(defn collect-swap-usage
  [callback-fn]
  (loop []
    (Thread/sleep 1000)
    (callback-fn (double (/ (.getSwapUsed (.getVirtualMemory (.getMemory (.getHardware s)))) (.getSwapTotal (.getVirtualMemory (.getMemory (.getHardware s)))))))
    (recur)))

(defn get-process-by-pid
  [pid]
  (try (.getProcess (.getOperatingSystem s) pid)
       (catch Throwable _
         nil)))

(defn get-process-by-pidfile
  [pidfile]
  (try
    (get-process-by-pid (Integer/parseInt (string/trim (slurp pidfile))))
    (catch Throwable _
      nil)))

(defn collect-process-info
  [get-process-fn callback-fn]
  (loop [previous-process (get-process-fn)]
    (Thread/sleep 1000)
    (if-let [process (get-process-fn)]
      (do
        (callback-fn {:pid (.getProcessID process)
                      :name (.getName process)
                      :cpu-usage (.getProcessCpuLoadBetweenTicks process previous-process)
                      :virtual-size (.getVirtualSize process)
                      :thread-count (.getThreadCount process)})
        (recur process))
      (recur nil))))

(def current-pid
  "Get current process PID"
  (memoize
   (fn []
     (-> (java.lang.management.ManagementFactory/getRuntimeMXBean)
         (.getName)
         (string/split #"@")
         (first)
         (Integer/parseInt)))))

(collect-process-info #(get-process-by-pid (current-pid)) println)
