(ns ^:no-doc active.data.http.ring
  (:require [active.data.translate.core :as core]))

;; TODO: remove these until someone needs them?

(defn wrap-format-request [format & [request-realm]]
  (let [fallback (when request-realm (core/translator-from request-realm format))]
    (fn [handler]
      (fn [request]
        ;; TODO: a way to turn it off? no fallback/no body?
        (let [from (if-let [realm (:realm request)]
                     (core/translator-from realm format)
                     fallback)]
          (-> (update request :body from)
              (handler)))))))

(defn wrap-format-response [format & [response-realm]]
  (let [fallback (when response-realm (core/translator-to response-realm format))]
    (fn [handler]
      (fn [request]
        ;; TODO: a way to turn it off? no fallback/no body? only if status 200?
        (let [to (if-let [realm (:response-realm request)]
                   (core/translator-to realm format)
                   fallback)]
          (-> (handler request)
              (update :body to)))))))
