(ns ^:no-doc active.clojure.monad.maybe
  "Maybe monad config"
  (:require [active.clojure.monad.commands :as commands]
            [active.clojure.monad.internals :as internals]))

(def just internals/return) ;; an alias

(commands/declare-command ^:private nothing-cmd [])

(def nothing (nothing-cmd))

(def ^:private maybe-command-impls
  {(var internals/return) (fn [v] [v])
   #'nothing-cmd (fn [] nil)
   (var internals/bind) (commands/recursive (fn [eval m f]
                                              (if-let [[v] (eval m)]
                                                (f v)
                                                nothing)))})

(def maybe-command-config
  (commands/command-config maybe-command-impls))
