// Compiled by ClojureScript 1.10.238 {}
goog.provide('active.clojure.mock_monad');
goog.require('cljs.core');
goog.require('active.clojure.monad');
goog.require('active.clojure.cljs.record');
goog.require('active.clojure.macro');
goog.require('cljs.test');



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
active.clojure.mock_monad.Mock = (function (check_BANG_,get_result,__meta,__extmap,__hash){
this.check_BANG_ = check_BANG_;
this.get_result = get_result;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
active.clojure.mock_monad.Mock.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__12596__auto__,k__12597__auto__){
var self__ = this;
var this__12596__auto____$1 = this;
return this__12596__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__12597__auto__,null);
});

active.clojure.mock_monad.Mock.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__12598__auto__,k16792,else__12599__auto__){
var self__ = this;
var this__12598__auto____$1 = this;
var G__16796 = k16792;
var G__16796__$1 = (((G__16796 instanceof cljs.core.Keyword))?G__16796.fqn:null);
switch (G__16796__$1) {
case "check!":
return self__.check_BANG_;

break;
case "get-result":
return self__.get_result;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k16792,else__12599__auto__);

}
});

active.clojure.mock_monad.Mock.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__12606__auto__,writer__12607__auto__,opts__12608__auto__){
var self__ = this;
var this__12606__auto____$1 = this;
var pr_pair__12609__auto__ = ((function (this__12606__auto____$1){
return (function (keyval__12610__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__12607__auto__,cljs.core.pr_writer,""," ","",opts__12608__auto__,keyval__12610__auto__);
});})(this__12606__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__12607__auto__,pr_pair__12609__auto__,"#active.clojure.mock-monad.Mock{",", ","}",opts__12608__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"check!","check!",906148316),self__.check_BANG_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"get-result","get-result",-1453831924),self__.get_result],null))], null),self__.__extmap));
});

active.clojure.mock_monad.Mock.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__16791){
var self__ = this;
var G__16791__$1 = this;
return (new cljs.core.RecordIter((0),G__16791__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"check!","check!",906148316),new cljs.core.Keyword(null,"get-result","get-result",-1453831924)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

active.clojure.mock_monad.Mock.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__12594__auto__){
var self__ = this;
var this__12594__auto____$1 = this;
return self__.__meta;
});

active.clojure.mock_monad.Mock.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__12591__auto__){
var self__ = this;
var this__12591__auto____$1 = this;
return (new active.clojure.mock_monad.Mock(self__.check_BANG_,self__.get_result,self__.__meta,self__.__extmap,self__.__hash));
});

active.clojure.mock_monad.Mock.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__12600__auto__){
var self__ = this;
var this__12600__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

active.clojure.mock_monad.Mock.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__12592__auto__){
var self__ = this;
var this__12592__auto____$1 = this;
var h__4030__auto__ = self__.__hash;
if(!((h__4030__auto__ == null))){
return h__4030__auto__;
} else {
var h__4030__auto____$1 = ((function (h__4030__auto__,this__12592__auto____$1){
return (function (coll__12593__auto__){
return (-1734637662 ^ cljs.core.hash_unordered_coll.call(null,coll__12593__auto__));
});})(h__4030__auto__,this__12592__auto____$1))
.call(null,this__12592__auto____$1);
self__.__hash = h__4030__auto____$1;

return h__4030__auto____$1;
}
});

active.clojure.mock_monad.Mock.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this16793,other16794){
var self__ = this;
var this16793__$1 = this;
return ((!((other16794 == null))) && ((this16793__$1.constructor === other16794.constructor)) && (cljs.core._EQ_.call(null,this16793__$1.check_BANG_,other16794.check_BANG_)) && (cljs.core._EQ_.call(null,this16793__$1.get_result,other16794.get_result)) && (cljs.core._EQ_.call(null,this16793__$1.__extmap,other16794.__extmap)));
});

active.clojure.mock_monad.Mock.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__12589__auto__,k__12590__auto__){
var self__ = this;
var this__12589__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get-result","get-result",-1453831924),null,new cljs.core.Keyword(null,"check!","check!",906148316),null], null), null),k__12590__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__12589__auto____$1),self__.__meta),k__12590__auto__);
} else {
return (new active.clojure.mock_monad.Mock(self__.check_BANG_,self__.get_result,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__12590__auto__)),null));
}
});

active.clojure.mock_monad.Mock.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__12587__auto__,k__12588__auto__,G__16791){
var self__ = this;
var this__12587__auto____$1 = this;
var pred__16797 = cljs.core.keyword_identical_QMARK_;
var expr__16798 = k__12588__auto__;
if(cljs.core.truth_(pred__16797.call(null,new cljs.core.Keyword(null,"check!","check!",906148316),expr__16798))){
return (new active.clojure.mock_monad.Mock(G__16791,self__.get_result,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__16797.call(null,new cljs.core.Keyword(null,"get-result","get-result",-1453831924),expr__16798))){
return (new active.clojure.mock_monad.Mock(self__.check_BANG_,G__16791,self__.__meta,self__.__extmap,null));
} else {
return (new active.clojure.mock_monad.Mock(self__.check_BANG_,self__.get_result,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__12588__auto__,G__16791),null));
}
}
});

active.clojure.mock_monad.Mock.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__12604__auto__){
var self__ = this;
var this__12604__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"check!","check!",906148316),self__.check_BANG_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"get-result","get-result",-1453831924),self__.get_result],null))], null),self__.__extmap));
});

active.clojure.mock_monad.Mock.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__12595__auto__,G__16791){
var self__ = this;
var this__12595__auto____$1 = this;
return (new active.clojure.mock_monad.Mock(self__.check_BANG_,self__.get_result,G__16791,self__.__extmap,self__.__hash));
});

active.clojure.mock_monad.Mock.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__12601__auto__,entry__12602__auto__){
var self__ = this;
var this__12601__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__12602__auto__)){
return this__12601__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__12602__auto__,(0)),cljs.core._nth.call(null,entry__12602__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__12601__auto____$1,entry__12602__auto__);
}
});

active.clojure.mock_monad.Mock.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"check!","check!",-1748287453,null),new cljs.core.Symbol(null,"get-result","get-result",186699603,null)], null);
});

active.clojure.mock_monad.Mock.cljs$lang$type = true;

active.clojure.mock_monad.Mock.cljs$lang$ctorPrSeq = (function (this__12682__auto__){
return (new cljs.core.List(null,"active.clojure.mock-monad/Mock",null,(1),null));
});

active.clojure.mock_monad.Mock.cljs$lang$ctorPrWriter = (function (this__12682__auto__,writer__12683__auto__){
return cljs.core._write.call(null,writer__12683__auto__,"active.clojure.mock-monad/Mock");
});

if(cljs.core._EQ_.call(null,false,new cljs.core.Keyword(null,"arrow-constructor?","arrow-constructor?",-1068727936).cljs$core$IFn$_invoke$arity$1(null))){
} else {
active.clojure.mock_monad.__GT_Mock = (function active$clojure$mock_monad$__GT_Mock(check_BANG_,get_result){
return (new active.clojure.mock_monad.Mock(check_BANG_,get_result,null,null,null));
});
}

active.clojure.mock_monad.map__GT_Mock = (function active$clojure$mock_monad$map__GT_Mock(G__16795){
return (new active.clojure.mock_monad.Mock(new cljs.core.Keyword(null,"check!","check!",906148316).cljs$core$IFn$_invoke$arity$1(G__16795),new cljs.core.Keyword(null,"get-result","get-result",-1453831924).cljs$core$IFn$_invoke$arity$1(G__16795),null,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,G__16795,new cljs.core.Keyword(null,"check!","check!",906148316),new cljs.core.Keyword(null,"get-result","get-result",-1453831924))),null));
});

/**
 * Is object a `Mock` record? See [[active.clojure.mock-monad/mock]].
 */
active.clojure.mock_monad.mock_QMARK_ = (function active$clojure$mock_monad$mock_QMARK_(x__12684__auto__){
return (x__12684__auto__ instanceof active.clojure.mock_monad.Mock);
});

/**
 * Construct a `Mock` record.
 * 
 * `check!`: access via [[active.clojure.mock-monad/mock-check!]]
 * `get-result`: access via [[active.clojure.mock-monad/mock-get-result]]
 */
active.clojure.mock_monad.mock = (function active$clojure$mock_monad$mock(check_BANG_,get_result){
return (new active.clojure.mock_monad.Mock(check_BANG_,get_result,null,null,null));
});



/**
 * Lens for the `check!` field from a [[Mock]] record. See [[active.clojure.mock-monad/mock]].
 */
active.clojure.mock_monad.mock_check_BANG_ = active.clojure.lens.lens.call(null,(function (rec__12663__auto__){
if((rec__12663__auto__ instanceof active.clojure.mock_monad.Mock)){
} else {
throw (new Error("Wrong record type (rec__12663__auto__) passed to accessor (mock-check!)."));
}

return rec__12663__auto__.check_BANG_;
}),(function (data__12664__auto__,v__12665__auto__){
return (new active.clojure.mock_monad.Mock(v__12665__auto__,active.clojure.mock_monad.mock_get_result.call(null,data__12664__auto__),null,null,null));
}));


/**
 * Lens for the `get-result` field from a [[Mock]] record. See [[active.clojure.mock-monad/mock]].
 */
active.clojure.mock_monad.mock_get_result = active.clojure.lens.lens.call(null,(function (rec__12663__auto__){
if((rec__12663__auto__ instanceof active.clojure.mock_monad.Mock)){
} else {
throw (new Error("Wrong record type (rec__12663__auto__) passed to accessor (mock-get-result)."));
}

return rec__12663__auto__.get_result;
}),(function (data__12664__auto__,v__12665__auto__){
return (new active.clojure.mock_monad.Mock(active.clojure.mock_monad.mock_check_BANG_.call(null,data__12664__auto__),v__12665__auto__,null,null,null));
}));



active.clojure.mock_monad.mocked_result = (function active$clojure$mock_monad$mocked_result(mock,m){
return active.clojure.mock_monad.mock_get_result.call(null,mock).call(null,m);
});
active.clojure.mock_monad.check_mock_BANG_ = (function active$clojure$mock_monad$check_mock_BANG_(mock,m){
return active.clojure.mock_monad.mock_check_BANG_.call(null,mock).call(null,m);
});
active.clojure.mock_monad.run_mock_commands = (function active$clojure$mock_monad$run_mock_commands(run_any,env,state,m){
var vec__16801 = new cljs.core.Keyword("active.clojure.mock-monad","mocks","active.clojure.mock-monad/mocks",-1750332842).cljs$core$IFn$_invoke$arity$1(state);
var seq__16802 = cljs.core.seq.call(null,vec__16801);
var first__16803 = cljs.core.first.call(null,seq__16802);
var seq__16802__$1 = cljs.core.next.call(null,seq__16802);
var mock = first__16803;
var r_mocks = seq__16802__$1;
if(cljs.core.truth_(mock)){
active.clojure.mock_monad.check_mock_BANG_.call(null,mock,m);

var nstate = cljs.core.assoc.call(null,state,new cljs.core.Keyword("active.clojure.mock-monad","mocks","active.clojure.mock-monad/mocks",-1750332842),r_mocks);
return run_any.call(null,env,nstate,active.clojure.mock_monad.mocked_result.call(null,mock,m));
} else {
try{var values__14117__auto___16805 = (new cljs.core.List(null,null,(new cljs.core.List(null,active.clojure.monad.reify_command.call(null,m),null,(1),null)),(2),null));
var result__14118__auto___16806 = cljs.core.apply.call(null,cljs.core._EQ_,values__14117__auto___16805);
if(cljs.core.truth_(result__14118__auto___16806)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),null,cljs.core.list(new cljs.core.Symbol("monad","reify-command","monad/reify-command",-1386368946,null),new cljs.core.Symbol(null,"m","m",-1021758608,null))),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__14117__auto___16805),new cljs.core.Keyword(null,"message","message",-406056002),"Unexpected command after end of mock list."], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),null,cljs.core.list(new cljs.core.Symbol("monad","reify-command","monad/reify-command",-1386368946,null),new cljs.core.Symbol(null,"m","m",-1021758608,null))),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__14117__auto___16805),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),"Unexpected command after end of mock list."], null));
}

}catch (e16804){var t__14162__auto___16807 = e16804;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),null,cljs.core.list(new cljs.core.Symbol("monad","reify-command","monad/reify-command",-1386368946,null),new cljs.core.Symbol(null,"m","m",-1021758608,null))),new cljs.core.Keyword(null,"actual","actual",107306363),t__14162__auto___16807,new cljs.core.Keyword(null,"message","message",-406056002),"Unexpected command after end of mock list."], null));
}
return active.clojure.monad.unknown_command;
}
});
active.clojure.mock_monad.mock_commands = (function active$clojure$mock_monad$mock_commands(mocks){
return active.clojure.monad.make_monad_command_config.call(null,active.clojure.mock_monad.run_mock_commands,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("active.clojure.mock-monad","mocks","active.clojure.mock-monad/mocks",-1750332842),mocks], null));
});
var ret__4533__auto___16811 = (function (){
active.clojure.mock_monad.m_is = (function active$clojure$mock_monad$m_is(var_args){
var args__4502__auto__ = [];
var len__4499__auto___16812 = arguments.length;
var i__4500__auto___16813 = (0);
while(true){
if((i__4500__auto___16813 < len__4499__auto___16812)){
args__4502__auto__.push((arguments[i__4500__auto___16813]));

var G__16814 = (i__4500__auto___16813 + (1));
i__4500__auto___16813 = G__16814;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((2) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((2)),(0),null)):null);
return active.clojure.mock_monad.m_is.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4503__auto__);
});

active.clojure.mock_monad.m_is.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,forms){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("active.clojure.monad","return","active.clojure.monad/return",-684481939,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("active.clojure.mock-monad","is","active.clojure.mock-monad/is",-648551989,null),null,(1),null)),forms))),null,(1),null)))));
});

active.clojure.mock_monad.m_is.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
active.clojure.mock_monad.m_is.cljs$lang$applyTo = (function (seq16808){
var G__16809 = cljs.core.first.call(null,seq16808);
var seq16808__$1 = cljs.core.next.call(null,seq16808);
var G__16810 = cljs.core.first.call(null,seq16808__$1);
var seq16808__$2 = cljs.core.next.call(null,seq16808__$1);
var self__4486__auto__ = this;
return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16809,G__16810,seq16808__$2);
});

return null;
})()
;
active.clojure.mock_monad.m_is.cljs$lang$macro = true;

active.clojure.mock_monad.check_mocks_empty = cljs.core.with_meta.call(null,active.clojure.monad.free_bind.call(null,active.clojure.monad.get_state_component.call(null,new cljs.core.Keyword("active.clojure.mock-monad","mocks","active.clojure.mock-monad/mocks",-1750332842)),(function (mocks){
var rmocks = cljs.core.map.call(null,active.clojure.monad.reify_command,mocks);
return cljs.core.with_meta.call(null,active.clojure.monad.free_bind.call(null,active.clojure.monad.return$.call(null,(function (){try{var values__14117__auto__ = (new cljs.core.List(null,rmocks,null,(1),null));
var result__14118__auto__ = cljs.core.apply.call(null,cljs.core.empty_QMARK_,values__14117__auto__);
if(cljs.core.truth_(result__14118__auto__)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"empty?","empty?",76408555,null),new cljs.core.Symbol(null,"rmocks","rmocks",504479490,null)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core.empty_QMARK_,values__14117__auto__),new cljs.core.Keyword(null,"message","message",-406056002),"Did not see expected mocked commands."], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"empty?","empty?",76408555,null),new cljs.core.Symbol(null,"rmocks","rmocks",504479490,null)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"empty?","empty?",76408555,null),values__14117__auto__),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),"Did not see expected mocked commands."], null));
}

return result__14118__auto__;
}catch (e16815){var t__14162__auto__ = e16815;
return cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"empty?","empty?",76408555,null),new cljs.core.Symbol(null,"rmocks","rmocks",504479490,null)),new cljs.core.Keyword(null,"actual","actual",107306363),t__14162__auto__,new cljs.core.Keyword(null,"message","message",-406056002),"Did not see expected mocked commands."], null));
}})()),((function (rmocks){
return (function (___16204__auto__){
return active.clojure.monad.return$.call(null,null);
});})(rmocks))
),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Users/crestani/activegroup/active-clojure/src/active/clojure/mock_monad.cljc",new cljs.core.Keyword(null,"line","line",212345235),53,new cljs.core.Keyword(null,"column","column",2078222095),4,new cljs.core.Keyword(null,"end-line","end-line",1837326455),57,new cljs.core.Keyword(null,"end-column","end-column",1425389514),69,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"___16204__auto__","___16204__auto__",2030552547,null),cljs.core.list(new cljs.core.Symbol(null,"if-cljs","if-cljs",-1413791510,null),cljs.core.list(new cljs.core.Symbol("monad","return","monad/return",180772607,null),cljs.core.list(new cljs.core.Symbol(null,"is","is",2009660525,null),cljs.core.list(new cljs.core.Symbol(null,"empty?","empty?",76408555,null),new cljs.core.Symbol(null,"rmocks","rmocks",504479490,null)),"Did not see expected mocked commands.")),cljs.core.list(new cljs.core.Symbol(null,"m-is","m-is",-857069635,null),cljs.core.list(new cljs.core.Symbol(null,"empty?","empty?",76408555,null),new cljs.core.Symbol(null,"rmocks","rmocks",504479490,null)),"Did not see expected mocked commands."))], null)], null));
})),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Users/crestani/activegroup/active-clojure/src/active/clojure/mock_monad.cljc",new cljs.core.Keyword(null,"line","line",212345235),51,new cljs.core.Keyword(null,"column","column",2078222095),11,new cljs.core.Keyword(null,"end-line","end-line",1837326455),51,new cljs.core.Keyword(null,"end-column","end-column",1425389514),46,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"mocks","mocks",250715519,null),cljs.core.list(new cljs.core.Symbol("monad","get-state-component","monad/get-state-component",198638210,null),new cljs.core.Keyword("active.clojure.mock-monad","mocks","active.clojure.mock-monad/mocks",-1750332842))], null)], null));
/**
 * If `(= m-expected m)` returns true for a command `m`, then execute `m-replacement` instead.
 */
active.clojure.mock_monad.mock_effect = (function active$clojure$mock_monad$mock_effect(m_expected,m_replacement){
return active.clojure.mock_monad.mock.call(null,(function (m){
try{var values__14117__auto__ = (new cljs.core.List(null,active.clojure.monad.reify_command.call(null,m_expected),(new cljs.core.List(null,active.clojure.monad.reify_command.call(null,m),null,(1),null)),(2),null));
var result__14118__auto__ = cljs.core.apply.call(null,cljs.core._EQ_,values__14117__auto__);
if(cljs.core.truth_(result__14118__auto__)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("monad","reify-command","monad/reify-command",-1386368946,null),new cljs.core.Symbol(null,"m-expected","m-expected",-753421608,null)),cljs.core.list(new cljs.core.Symbol("monad","reify-command","monad/reify-command",-1386368946,null),new cljs.core.Symbol(null,"m","m",-1021758608,null))),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__14117__auto__),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("monad","reify-command","monad/reify-command",-1386368946,null),new cljs.core.Symbol(null,"m-expected","m-expected",-753421608,null)),cljs.core.list(new cljs.core.Symbol("monad","reify-command","monad/reify-command",-1386368946,null),new cljs.core.Symbol(null,"m","m",-1021758608,null))),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__14117__auto__),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

return result__14118__auto__;
}catch (e16816){var t__14162__auto__ = e16816;
return cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("monad","reify-command","monad/reify-command",-1386368946,null),new cljs.core.Symbol(null,"m-expected","m-expected",-753421608,null)),cljs.core.list(new cljs.core.Symbol("monad","reify-command","monad/reify-command",-1386368946,null),new cljs.core.Symbol(null,"m","m",-1021758608,null))),new cljs.core.Keyword(null,"actual","actual",107306363),t__14162__auto__,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}}),cljs.core.constantly.call(null,m_replacement));
});
/**
 * If `(= m-expected m)` returns true for a command `m`, then return `value` instead.
 */
active.clojure.mock_monad.mock_result = (function active$clojure$mock_monad$mock_result(m_expected,value){
return active.clojure.mock_monad.mock_effect.call(null,m_expected,active.clojure.monad.return$.call(null,value));
});
active.clojure.mock_monad.mock_ignore = active.clojure.mock_monad.mock.call(null,cljs.core.constantly.call(null,null),cljs.core.constantly.call(null,active.clojure.monad.return$.call(null,null)));
active.clojure.mock_monad.mock_execute_monad = (function active$clojure$mock_monad$mock_execute_monad(var_args){
var G__16818 = arguments.length;
switch (G__16818) {
case 2:
return active.clojure.mock_monad.mock_execute_monad.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return active.clojure.mock_monad.mock_execute_monad.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

active.clojure.mock_monad.mock_execute_monad.cljs$core$IFn$_invoke$arity$2 = (function (mocks,m){
return active.clojure.mock_monad.mock_execute_monad.call(null,active.clojure.monad.null_monad_command_config.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY),mocks,m);
});

active.clojure.mock_monad.mock_execute_monad.cljs$core$IFn$_invoke$arity$3 = (function (command_config,mocks,m){
try{return active.clojure.monad.run_free_reader_state_exception.call(null,active.clojure.monad.combine_monad_command_configs.call(null,command_config,active.clojure.mock_monad.mock_commands.call(null,mocks)),cljs.core.with_meta.call(null,active.clojure.monad.free_bind.call(null,m,(function (res){
return cljs.core.with_meta.call(null,active.clojure.monad.free_bind.call(null,active.clojure.mock_monad.check_mocks_empty,(function (___16204__auto__){
return active.clojure.monad.return$.call(null,res);
})),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Users/crestani/activegroup/active-clojure/src/active/clojure/mock_monad.cljc",new cljs.core.Keyword(null,"line","line",212345235),91,new cljs.core.Keyword(null,"column","column",2078222095),11,new cljs.core.Keyword(null,"end-line","end-line",1837326455),91,new cljs.core.Keyword(null,"end-column","end-column",1425389514),28,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"___16204__auto__","___16204__auto__",2030552547,null),new cljs.core.Symbol(null,"check-mocks-empty","check-mocks-empty",607083264,null)], null)], null));
})),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Users/crestani/activegroup/active-clojure/src/active/clojure/mock_monad.cljc",new cljs.core.Keyword(null,"line","line",212345235),89,new cljs.core.Keyword(null,"column","column",2078222095),16,new cljs.core.Keyword(null,"end-line","end-line",1837326455),89,new cljs.core.Keyword(null,"end-column","end-column",1425389514),17,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"res","res",245523648,null),new cljs.core.Symbol(null,"m","m",-1021758608,null)], null)], null)));
}catch (e16819){if((e16819 instanceof Error)){
var e = e16819;
return cljs.core.println.call(null,"e =",e);
} else {
throw e16819;

}
}});

active.clojure.mock_monad.mock_execute_monad.cljs$lang$maxFixedArity = 3;

/**
 * Run m under the given monad command configs, and the given mocked commands, returning the result of m.
 * `mocks` should be a sequence, whose values can be created by the
 *   `mock`, `mock-result` or `mock-effect` and other functions above, and are
 *   expected to appear in that order while executing `m`.
 */
active.clojure.mock_monad.mock_run_monad = (function active$clojure$mock_monad$mock_run_monad(var_args){
var G__16822 = arguments.length;
switch (G__16822) {
case 3:
return active.clojure.mock_monad.mock_run_monad.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return active.clojure.mock_monad.mock_run_monad.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

active.clojure.mock_monad.mock_run_monad.cljs$core$IFn$_invoke$arity$3 = (function (command_config,mocks,m){
try{return cljs.core.first.call(null,active.clojure.mock_monad.mock_execute_monad.call(null,command_config,mocks,m));
}catch (e16823){if((e16823 instanceof Error)){
var e = e16823;
return cljs.core.println.call(null,"e =",e);
} else {
throw e16823;

}
}});

active.clojure.mock_monad.mock_run_monad.cljs$core$IFn$_invoke$arity$2 = (function (mocks,m){
return active.clojure.mock_monad.mock_run_monad.call(null,active.clojure.monad.null_monad_command_config.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY),mocks,m);
});

active.clojure.mock_monad.mock_run_monad.cljs$lang$maxFixedArity = 3;

/**
 * Immediately calls f with a function of two arguments, `mocks` and
 *   `m`, which can be repeatedly called to evaluate monadic commands
 *   `m`, with mocked commands like in `test-run-monad`. The monad state
 *   is preserved from call to call.  Returns `[result state]`.
 */
active.clojure.mock_monad.with_mock_run_monad = (function active$clojure$mock_monad$with_mock_run_monad(command_config,f){
var state = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
return f.call(null,((function (state){
return (function (mocks,m){
var st1 = cljs.core.deref.call(null,state);
var vec__16825 = active.clojure.mock_monad.mock_run_monad.call(null,command_config,mocks,cljs.core.with_meta.call(null,active.clojure.monad.free_bind.call(null,active.clojure.monad.put_state_BANG_.call(null,cljs.core.assoc.call(null,st1,new cljs.core.Keyword("active.clojure.mock-monad","mocks","active.clojure.mock-monad/mocks",-1750332842),mocks)),((function (st1,state){
return (function (___16204__auto__){
return cljs.core.with_meta.call(null,active.clojure.monad.free_bind.call(null,m,((function (st1,state){
return (function (r){
return cljs.core.with_meta.call(null,active.clojure.monad.free_bind.call(null,active.clojure.monad.get_state.call(null),((function (st1,state){
return (function (st2){
return active.clojure.monad.return$.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [r,st2], null));
});})(st1,state))
),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Users/crestani/activegroup/active-clojure/src/active/clojure/mock_monad.cljc",new cljs.core.Keyword(null,"line","line",212345235),128,new cljs.core.Keyword(null,"column","column",2078222095),38,new cljs.core.Keyword(null,"end-line","end-line",1837326455),128,new cljs.core.Keyword(null,"end-column","end-column",1425389514),55,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"st2","st2",-1222930854,null),cljs.core.list(new cljs.core.Symbol("monad","get-state","monad/get-state",-1176614367,null))], null)], null));
});})(st1,state))
),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Users/crestani/activegroup/active-clojure/src/active/clojure/mock_monad.cljc",new cljs.core.Keyword(null,"line","line",212345235),127,new cljs.core.Keyword(null,"column","column",2078222095),36,new cljs.core.Keyword(null,"end-line","end-line",1837326455),127,new cljs.core.Keyword(null,"end-column","end-column",1425389514),37,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"r","r",1169147337,null),new cljs.core.Symbol(null,"m","m",-1021758608,null)], null)], null));
});})(st1,state))
),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Users/crestani/activegroup/active-clojure/src/active/clojure/mock_monad.cljc",new cljs.core.Keyword(null,"line","line",212345235),126,new cljs.core.Keyword(null,"column","column",2078222095),33,new cljs.core.Keyword(null,"end-line","end-line",1837326455),126,new cljs.core.Keyword(null,"end-column","end-column",1425389514),77,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"___16204__auto__","___16204__auto__",2030552547,null),cljs.core.list(new cljs.core.Symbol("monad","put-state!","monad/put-state!",-819003554,null),cljs.core.list(new cljs.core.Symbol(null,"assoc","assoc",2071440380,null),new cljs.core.Symbol(null,"st1","st1",700828932,null),new cljs.core.Keyword("active.clojure.mock-monad","mocks","active.clojure.mock-monad/mocks",-1750332842),new cljs.core.Symbol(null,"mocks","mocks",250715519,null)))], null)], null)));
var r = cljs.core.nth.call(null,vec__16825,(0),null);
var st2 = cljs.core.nth.call(null,vec__16825,(1),null);
cljs.core.reset_BANG_.call(null,state,st2);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [r,st2], null);
});})(state))
);
});
/**
 * Takes an `expectation` and the `monad-command-config-state` after running a mock.
 *   Applies `is` to the `=` of both, dissocing the ::mocks from the returned state.
 */
active.clojure.mock_monad.is_mocked_state = (function active$clojure$mock_monad$is_mocked_state(expectation,mock_result_state){
try{var values__14117__auto__ = (new cljs.core.List(null,expectation,(new cljs.core.List(null,cljs.core.dissoc.call(null,mock_result_state,new cljs.core.Keyword("active.clojure.mock-monad","mocks","active.clojure.mock-monad/mocks",-1750332842)),null,(1),null)),(2),null));
var result__14118__auto__ = cljs.core.apply.call(null,cljs.core._EQ_,values__14117__auto__);
if(cljs.core.truth_(result__14118__auto__)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"expectation","expectation",1390114806,null),cljs.core.list(new cljs.core.Symbol(null,"dissoc","dissoc",1039760994,null),new cljs.core.Symbol(null,"mock-result-state","mock-result-state",-419360520,null),new cljs.core.Keyword("active.clojure.mock-monad","mocks","active.clojure.mock-monad/mocks",-1750332842))),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__14117__auto__),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"expectation","expectation",1390114806,null),cljs.core.list(new cljs.core.Symbol(null,"dissoc","dissoc",1039760994,null),new cljs.core.Symbol(null,"mock-result-state","mock-result-state",-419360520,null),new cljs.core.Keyword("active.clojure.mock-monad","mocks","active.clojure.mock-monad/mocks",-1750332842))),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__14117__auto__),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

return result__14118__auto__;
}catch (e16828){var t__14162__auto__ = e16828;
return cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"expectation","expectation",1390114806,null),cljs.core.list(new cljs.core.Symbol(null,"dissoc","dissoc",1039760994,null),new cljs.core.Symbol(null,"mock-result-state","mock-result-state",-419360520,null),new cljs.core.Keyword("active.clojure.mock-monad","mocks","active.clojure.mock-monad/mocks",-1750332842))),new cljs.core.Keyword(null,"actual","actual",107306363),t__14162__auto__,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}});

//# sourceMappingURL=mock_monad.js.map
