/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.UGen;
import ddf.minim.ugens.Waves;

public class Flanger
extends UGen {
    public UGen.UGenInput audio = this.addAudio();
    public UGen.UGenInput delay;
    public UGen.UGenInput rate;
    public UGen.UGenInput depth;
    public UGen.UGenInput feedback;
    public UGen.UGenInput dry;
    public UGen.UGenInput wet;
    private float[] delayBuffer;
    private int outputFrame;
    private int bufferFrameLength;
    private float step;
    private float stepSize;
    private float prevFreq;
    private float oneOverSampleRate;

    public Flanger(float delayLength, float lfoRate, float delayDepth, float feedbackAmplitude, float dryAmplitude, float wetAmplitude) {
        this.delay = this.addControl(delayLength);
        this.rate = this.addControl(lfoRate);
        this.depth = this.addControl(delayDepth);
        this.feedback = this.addControl(feedbackAmplitude);
        this.dry = this.addControl(dryAmplitude);
        this.wet = this.addControl(wetAmplitude);
    }

    private void resetBuffer() {
        int sampleCount = (int)(100.0f * this.sampleRate() / 1000.0f);
        this.delayBuffer = new float[sampleCount * this.audio.channelCount()];
        this.outputFrame = 0;
        this.bufferFrameLength = sampleCount;
    }

    private float getRate() {
        float r = this.rate.getLastValue();
        return r > 0.001f ? r : 0.001f;
    }

    protected void sampleRateChanged() {
        this.resetBuffer();
        this.oneOverSampleRate = 1.0f / this.sampleRate();
        this.stepSize = this.getRate() * this.oneOverSampleRate;
        this.prevFreq = this.getRate();
        this.step = 0.25f;
    }

    private void updateStepSize() {
        float currFreq = this.getRate();
        if (this.prevFreq != currFreq) {
            this.stepSize = currFreq * this.oneOverSampleRate;
            this.prevFreq = currFreq;
        }
    }

    protected void channelCountChanged() {
        this.resetBuffer();
    }

    protected void uGenerate(float[] out) {
        float lfo = Waves.SINE.value(this.step);
        float dep = this.depth.getLastValue() * 0.5f;
        float delMS = this.delay.getLastValue() + (lfo * dep + dep);
        int delFrame = (int)(delMS * this.sampleRate() / 1000.0f);
        int i = 0;
        while (i < out.length) {
            int outputIndex = this.outputFrame * this.audio.channelCount() + i;
            float inSample = this.audio.getLastValues()[i];
            float wetSample = this.delayBuffer[outputIndex];
            int delIndex = ((this.outputFrame + delFrame) * this.audio.channelCount() + i) % this.delayBuffer.length;
            this.delayBuffer[delIndex] = inSample + wetSample * this.feedback.getLastValue();
            out[i] = inSample * this.dry.getLastValue() + wetSample * this.wet.getLastValue();
            ++i;
        }
        ++this.outputFrame;
        if (this.outputFrame == this.bufferFrameLength) {
            this.outputFrame = 0;
        }
        this.updateStepSize();
        this.step += this.stepSize;
        if (this.step > 1.0f) {
            this.step -= 1.0f;
        }
    }
}

