/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.UGen;
import java.util.Arrays;

public class Delay
extends UGen {
    public UGen.UGenInput audio = this.addAudio();
    public UGen.UGenInput delTime;
    public UGen.UGenInput delAmp;
    private float maxDelayTime;
    private double[] delayBuffer;
    private int delayBufferFrames;
    private int iBufferOut;
    private boolean feedBackOn;
    private boolean passAudioOn;

    public Delay() {
        this(0.25f, 0.5f, false, true);
    }

    public Delay(float maxDelayTime) {
        this(maxDelayTime, 0.5f, false, true);
    }

    public Delay(float maxDelayTime, float amplitudeFactor) {
        this(maxDelayTime, amplitudeFactor, false, true);
    }

    public Delay(float maxDelayTime, float amplitudeFactor, boolean feedBackOn) {
        this(maxDelayTime, amplitudeFactor, feedBackOn, true);
    }

    public Delay(float maxDelayTime, float amplitudeFactor, boolean feedBackOn, boolean passAudioOn) {
        this.maxDelayTime = maxDelayTime;
        this.delTime = this.addControl(maxDelayTime);
        this.delAmp = this.addControl(amplitudeFactor);
        this.feedBackOn = feedBackOn;
        this.passAudioOn = passAudioOn;
        this.iBufferOut = 0;
    }

    protected void sampleRateChanged() {
        this.allocateDelayBuffer();
    }

    protected void channelCountChanged() {
        this.allocateDelayBuffer();
    }

    void allocateDelayBuffer() {
        this.delayBufferFrames = (int)(this.maxDelayTime * this.sampleRate());
        this.delayBuffer = new double[this.delayBufferFrames * this.audio.channelCount()];
        this.iBufferOut = 0;
    }

    public void setDelTime(float delayTime) {
        this.delTime.setLastValue(delayTime);
    }

    public void setDelAmp(float delayAmplitude) {
        this.delAmp.setLastValue(delayAmplitude);
    }

    protected void uGenerate(float[] channels) {
        if (this.delayBuffer == null || this.delayBuffer.length == 0) {
            Arrays.fill(channels, 0.0f);
            return;
        }
        int delay = (int)(this.delTime.getLastValue() * this.sampleRate());
        int channelCount = this.channelCount();
        int i = 0;
        while (i < channelCount) {
            float in = this.audio.getLastValues()[i];
            int outSample = this.iBufferOut * channelCount + i;
            float out = this.delAmp.getLastValue() * (float)this.delayBuffer[outSample];
            this.delayBuffer[outSample] = 0.0;
            int inFrame = (this.iBufferOut + delay) % this.delayBufferFrames;
            int inSample = inFrame * channelCount + i;
            this.delayBuffer[inSample] = in;
            if (this.feedBackOn) {
                int n = inSample;
                this.delayBuffer[n] = this.delayBuffer[n] + (double)out;
            }
            if (this.passAudioOn) {
                out += in;
            }
            channels[i] = out;
            ++i;
        }
        this.iBufferOut = (this.iBufferOut + 1) % this.delayBufferFrames;
    }
}

