/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.ugens.Wavetable;

public class WavetableGenerator {
    private WavetableGenerator() {
    }

    public static Wavetable gen7(int size, float[] val, int[] dist) {
        int i;
        float[] waveform = new float[size];
        if (val.length - 1 != dist.length) {
            System.out.println("Input arrays of invalid sizes!");
            return null;
        }
        int sum = 0;
        for (i = 0; i < dist.length; ++i) {
            sum += dist[i];
        }
        if (size != sum) {
            System.out.println("Distances do not sum to size!");
            return null;
        }
        i = 0;
        for (int j = 1; j < val.length && i < waveform.length; i += dist[j - 1], ++j) {
            waveform[i] = val[j - 1];
            float m = (val[j] - val[j - 1]) / (float)dist[j - 1];
            for (int k = i + 1; k < i + dist[j - 1]; ++k) {
                waveform[k] = m * (float)(k - i) + val[j - 1];
            }
        }
        waveform[waveform.length - 1] = val[val.length - 1];
        return new Wavetable(waveform);
    }

    public static Wavetable gen9(int size, float[] partial, float[] amp, float[] phase) {
        if (partial.length != amp.length || partial.length != phase.length || amp.length != phase.length) {
            System.err.println("Input arrays of different size!");
            return null;
        }
        float[] waveform = new float[size];
        float index = 0.0f;
        for (int i = 0; i < size; ++i) {
            index = (float)i / (float)(size - 1);
            for (int j = 0; j < partial.length; ++j) {
                int n = i;
                waveform[n] = (float)((double)waveform[n] + (double)amp[j] * Math.sin(Math.PI * 2 * (double)partial[j] * (double)index + (double)phase[j]));
            }
        }
        return new Wavetable(waveform);
    }

    public static Wavetable gen10(int size, float[] amp) {
        float[] waveform = new float[size];
        float index = 0.0f;
        for (int i = 0; i < size; ++i) {
            index = (float)i / (float)(size - 1);
            for (int j = 0; j < amp.length; ++j) {
                int n = i;
                waveform[n] = (float)((double)waveform[n] + (double)amp[j] * Math.sin(Math.PI * 2 * (double)(j + 1) * (double)index));
            }
        }
        return new Wavetable(waveform);
    }
}

