/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.AudioSignal;
import ddf.minim.Minim;
import ddf.minim.UGen;
import java.util.ArrayList;
import java.util.Arrays;

public class Summer
extends UGen
implements AudioSignal {
    private ArrayList<UGen> m_ugens = new ArrayList();
    private float[] m_tickBuffer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addInput(UGen input) {
        input.setChannelCount(this.channelCount());
        ArrayList<UGen> arrayList = this.m_ugens;
        synchronized (arrayList) {
            this.m_ugens.add(input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeInput(UGen input) {
        Minim.debug("Bus::removeInput - Removing " + input + " to the m_ugens list of " + this);
        ArrayList<UGen> arrayList = this.m_ugens;
        synchronized (arrayList) {
            for (int i = 0; i < this.m_ugens.size(); ++i) {
                if (this.m_ugens.get(i) != input) continue;
                this.m_ugens.set(i, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sampleRateChanged() {
        ArrayList<UGen> arrayList = this.m_ugens;
        synchronized (arrayList) {
            for (int i = 0; i < this.m_ugens.size(); ++i) {
                UGen u = this.m_ugens.get(i);
                if (u == null) continue;
                u.setSampleRate(this.sampleRate());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelCountChanged() {
        ArrayList<UGen> arrayList = this.m_ugens;
        synchronized (arrayList) {
            for (int i = 0; i < this.m_ugens.size(); ++i) {
                UGen u = this.m_ugens.get(i);
                if (u == null) continue;
                u.setChannelCount(this.channelCount());
            }
        }
        this.m_tickBuffer = new float[this.channelCount()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uGenerate(float[] channels) {
        UGen u;
        int i;
        ArrayList<UGen> arrayList;
        if (this.m_tickBuffer == null || this.m_tickBuffer.length != channels.length) {
            this.m_tickBuffer = new float[channels.length];
            arrayList = this.m_ugens;
            synchronized (arrayList) {
                for (i = 0; i < this.m_ugens.size(); ++i) {
                    u = this.m_ugens.get(i);
                    if (u != null) {
                        u.setChannelCount(channels.length);
                        continue;
                    }
                    this.m_ugens.remove(i);
                    --i;
                }
            }
        }
        Arrays.fill(channels, 0.0f);
        arrayList = this.m_ugens;
        synchronized (arrayList) {
            for (i = 0; i < this.m_ugens.size(); ++i) {
                u = this.m_ugens.get(i);
                if (u != null) {
                    u.tick(this.m_tickBuffer);
                    this.processSampleFrame(this.m_tickBuffer, channels);
                    continue;
                }
                this.m_ugens.remove(i);
                --i;
            }
        }
    }

    protected void processSampleFrame(float[] in, float[] out) {
        for (int i = 0; i < out.length; ++i) {
            int n = i;
            out[n] = out[n] + in[i];
        }
    }

    public void generate(float[] mono) {
        float[] sample = new float[1];
        for (int i = 0; i < mono.length; ++i) {
            this.tick(sample);
            mono[i] = sample[0];
        }
    }

    public void generate(float[] left, float[] right) {
        float[] sample = new float[2];
        for (int i = 0; i < left.length; ++i) {
            this.tick(sample);
            left[i] = sample[0];
            right[i] = sample[1];
        }
    }
}

