/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.effects;

import ddf.minim.AudioEffect;
import ddf.minim.UGen;

public abstract class IIRFilter
extends UGen
implements AudioEffect {
    public final UGen.UGenInput audio;
    public final UGen.UGenInput cutoff;
    protected float[] a;
    protected float[] b;
    private float[][] in;
    private float[][] out;
    private float prevCutoff;

    public IIRFilter(float freq, float sampleRate) {
        this.setSampleRate(sampleRate);
        this.audio = new UGen.UGenInput(this, UGen.InputType.AUDIO);
        this.cutoff = new UGen.UGenInput(this, UGen.InputType.CONTROL);
        this.cutoff.setLastValue(freq);
        this.prevCutoff = -1.0f;
    }

    private final void initArrays(int numChannels) {
        int memSize = this.a.length >= this.b.length ? this.a.length : this.b.length;
        this.in = new float[numChannels][memSize];
        this.out = new float[numChannels][memSize];
    }

    public final synchronized void uGenerate(float[] channels) {
        if (this.cutoff.getLastValue() != this.prevCutoff) {
            this.calcCoeff();
            this.prevCutoff = this.cutoff.getLastValue();
        }
        if (this.in == null || this.in.length < channels.length || this.in[0].length < this.a.length && this.in[0].length < this.b.length) {
            this.initArrays(channels.length);
        }
        for (int i = 0; i < channels.length; ++i) {
            int ci;
            System.arraycopy(this.in[i], 0, this.in[i], 1, this.in[i].length - 1);
            this.in[i][0] = this.audio.getLastValues()[i];
            float y = 0.0f;
            for (ci = 0; ci < this.a.length; ++ci) {
                y += this.a[ci] * this.in[i][ci];
            }
            for (ci = 0; ci < this.b.length; ++ci) {
                y += this.b[ci] * this.out[i][ci];
            }
            System.arraycopy(this.out[i], 0, this.out[i], 1, this.out[i].length - 1);
            this.out[i][0] = y;
            channels[i] = y;
        }
    }

    public final synchronized void process(float[] signal) {
        this.setChannelCount(1);
        float[] tmp = new float[1];
        for (int i = 0; i < signal.length; ++i) {
            this.audio.setLastValue(signal[i]);
            this.uGenerate(tmp);
            signal[i] = tmp[0];
        }
    }

    public final synchronized void process(float[] sigLeft, float[] sigRight) {
        this.setChannelCount(2);
        float[] tmp = new float[2];
        for (int i = 0; i < sigLeft.length; ++i) {
            this.audio.getLastValues()[0] = sigLeft[i];
            this.audio.getLastValues()[1] = sigRight[i];
            this.uGenerate(tmp);
            sigLeft[i] = tmp[0];
            sigRight[i] = tmp[1];
        }
    }

    public final void setFreq(float f) {
        if (this.validFreq(f) && f != this.cutoff.getLastValue()) {
            this.prevCutoff = f;
            this.cutoff.setLastValue(f);
            this.calcCoeff();
        }
    }

    public boolean validFreq(float f) {
        return f > 0.0f;
    }

    public final float frequency() {
        return this.cutoff.getLastValue();
    }

    protected abstract void calcCoeff();

    public final void printCoeff() {
        int i;
        System.out.println("Filter coefficients: ");
        if (this.a != null) {
            for (i = 0; i < this.a.length; ++i) {
                System.out.print("  A" + i + ": " + this.a[i]);
            }
        }
        System.out.println();
        if (this.b != null) {
            for (i = 0; i < this.b.length; ++i) {
                System.out.print("  B" + (i + 1) + ": " + this.b[i]);
            }
            System.out.println();
        }
    }
}

