/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

import ddf.minim.AudioInput;
import ddf.minim.AudioOutput;
import ddf.minim.AudioPlayer;
import ddf.minim.AudioRecorder;
import ddf.minim.AudioSample;
import ddf.minim.AudioSnippet;
import ddf.minim.AudioSource;
import ddf.minim.MultiChannelBuffer;
import ddf.minim.Recordable;
import ddf.minim.javasound.JSMinim;
import ddf.minim.spi.AudioOut;
import ddf.minim.spi.AudioRecording;
import ddf.minim.spi.AudioRecordingStream;
import ddf.minim.spi.AudioStream;
import ddf.minim.spi.MinimServiceProvider;
import ddf.minim.spi.SampleRecorder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Mixer;
import org.tritonus.share.sampled.AudioUtils;

public class Minim {
    public static final int MONO = 1;
    public static final int STEREO = 2;
    public static final int LOOP_CONTINUOUSLY = -1;
    public static AudioFileFormat.Type WAV = AudioFileFormat.Type.WAVE;
    public static AudioFileFormat.Type AIFF = AudioFileFormat.Type.AIFF;
    public static AudioFileFormat.Type AIFC = AudioFileFormat.Type.AIFC;
    public static AudioFileFormat.Type AU = AudioFileFormat.Type.AU;
    public static AudioFileFormat.Type SND = AudioFileFormat.Type.SND;
    private static boolean DEBUG = false;
    private MinimServiceProvider mimp = null;
    private ArrayList<AudioSource> sources = new ArrayList();
    private ArrayList<AudioStream> streams = new ArrayList();

    public Minim(Object fileSystemHandler) {
        this(new JSMinim(fileSystemHandler));
        Class<?> superClass = fileSystemHandler.getClass().getSuperclass();
        if (superClass.getName() == "processing.core.PApplet") {
            try {
                Method registerDispose = superClass.getMethod("registerMethod", String.class, Object.class);
                registerDispose.invoke(fileSystemHandler, "dispose", this);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public Minim(MinimServiceProvider implementation) {
        this.mimp = implementation;
        this.mimp.start();
    }

    public static void error(String message) {
        System.out.println("=== Minim Error ===");
        System.out.println("=== " + message);
        System.out.println();
    }

    public static void debug(String message) {
        if (DEBUG) {
            String[] lines = message.split("\n");
            System.out.println("=== Minim Debug ===");
            for (int i = 0; i < lines.length; ++i) {
                System.out.println("=== " + lines[i]);
            }
            System.out.println();
        }
    }

    public void debugOn() {
        DEBUG = true;
        if (this.mimp != null) {
            this.mimp.debugOn();
        }
    }

    public void debugOff() {
        DEBUG = false;
        if (this.mimp != null) {
            this.mimp.debugOff();
        }
    }

    public void dispose() {
        this.stop();
    }

    public void stop() {
        Minim.debug("Stopping Minim...");
        for (AudioSource audioSource : this.sources) {
            audioSource.parent = null;
            audioSource.close();
        }
        this.sources.clear();
        for (AudioStream audioStream : this.streams) {
            audioStream.close();
        }
        this.mimp.stop();
    }

    void addSource(AudioSource s) {
        this.sources.add(s);
        s.parent = this;
    }

    void removeSource(AudioSource s) {
        this.sources.remove(s);
    }

    @Deprecated
    public void setInputMixer(Mixer mixer) {
        if (this.mimp instanceof JSMinim) {
            ((JSMinim)this.mimp).setInputMixer(mixer);
        }
    }

    @Deprecated
    public void setOutputMixer(Mixer mixer) {
        if (this.mimp instanceof JSMinim) {
            ((JSMinim)this.mimp).setOutputMixer(mixer);
        }
    }

    public AudioSample createSample(float[] sampleData, AudioFormat format) {
        return this.createSample(sampleData, format, 1024);
    }

    public AudioSample createSample(float[] sampleData, AudioFormat format, int bufferSize) {
        AudioSample sample = this.mimp.getAudioSample(sampleData, format, bufferSize);
        this.addSource(sample);
        return sample;
    }

    public AudioSample createSample(float[] leftSampleData, float[] rightSampleData, AudioFormat format) {
        return this.createSample(leftSampleData, rightSampleData, format, 1024);
    }

    public AudioSample createSample(float[] leftSampleData, float[] rightSampleData, AudioFormat format, int bufferSize) {
        AudioSample sample = this.mimp.getAudioSample(leftSampleData, rightSampleData, format, bufferSize);
        this.addSource(sample);
        return sample;
    }

    public AudioSample loadSample(String filename) {
        return this.loadSample(filename, 1024);
    }

    public AudioSample loadSample(String filename, int bufferSize) {
        AudioSample sample = this.mimp.getAudioSample(filename, bufferSize);
        this.addSource(sample);
        return sample;
    }

    @Deprecated
    public AudioSnippet loadSnippet(String filename) {
        AudioRecording c = this.mimp.getAudioRecording(filename);
        if (c != null) {
            return new AudioSnippet(c);
        }
        Minim.error("Couldn't load the file " + filename);
        return null;
    }

    public AudioPlayer loadFile(String filename) {
        return this.loadFile(filename, 1024);
    }

    public AudioPlayer loadFile(String filename, int bufferSize) {
        AudioPlayer player = null;
        AudioRecordingStream rec = this.mimp.getAudioRecordingStream(filename, bufferSize, false);
        if (rec != null) {
            AudioFormat format = rec.getFormat();
            AudioOut out = this.mimp.getAudioOutput(format.getChannels(), bufferSize, format.getSampleRate(), format.getSampleSizeInBits());
            if (out != null) {
                player = new AudioPlayer(rec, out);
            } else {
                rec.close();
            }
        }
        if (player != null) {
            this.addSource(player);
        } else {
            Minim.error("Couldn't load the file " + filename);
        }
        return player;
    }

    public AudioRecordingStream loadFileStream(String filename, int bufferSize, boolean inMemory) {
        AudioRecordingStream stream = this.mimp.getAudioRecordingStream(filename, bufferSize, inMemory);
        this.streams.add(stream);
        return stream;
    }

    public float loadFileIntoBuffer(String filename, MultiChannelBuffer outBuffer) {
        int readBufferSize = 4096;
        float sampleRate = 0.0f;
        AudioRecordingStream stream = this.mimp.getAudioRecordingStream(filename, 4096, false);
        if (stream != null) {
            long totalSamplesRead;
            int samplesRead;
            stream.play();
            sampleRate = stream.getFormat().getSampleRate();
            int channelCount = stream.getFormat().getChannels();
            MultiChannelBuffer readBuffer = new MultiChannelBuffer(channelCount, 4096);
            outBuffer.setChannelCount(channelCount);
            long totalSampleCount = stream.getSampleFrameLength();
            if (totalSampleCount == -1L) {
                totalSampleCount = AudioUtils.millis2Frames((int)stream.getMillisecondLength(), (AudioFormat)stream.getFormat());
            }
            Minim.debug("Total sample count for " + filename + " is " + totalSampleCount);
            outBuffer.setBufferSize((int)totalSampleCount);
            for (totalSamplesRead = 0L; totalSamplesRead < totalSampleCount; totalSamplesRead += (long)samplesRead) {
                if (totalSampleCount - totalSamplesRead < 4096L) {
                    readBuffer.setBufferSize((int)(totalSampleCount - totalSamplesRead));
                }
                if ((samplesRead = stream.read(readBuffer)) == 0) {
                    Minim.debug("loadSampleIntoBuffer: got 0 samples read");
                    break;
                }
                for (int i = 0; i < channelCount; ++i) {
                    for (int s = 0; s < samplesRead; ++s) {
                        outBuffer.setSample(i, (int)totalSamplesRead + s, readBuffer.getSample(i, s));
                    }
                }
            }
            if (totalSamplesRead != totalSampleCount) {
                outBuffer.setBufferSize((int)totalSamplesRead);
            }
            Minim.debug("loadSampleIntoBuffer: final output buffer size is " + outBuffer.getBufferSize());
            stream.close();
        } else {
            Minim.debug("Unable to load an AudioRecordingStream for " + filename);
        }
        return sampleRate;
    }

    public AudioRecorder createRecorder(Recordable source, String fileName) {
        return this.createRecorder(source, fileName, false);
    }

    public AudioRecorder createRecorder(Recordable source, String fileName, boolean buffered) {
        SampleRecorder rec = this.mimp.getSampleRecorder(source, fileName, buffered);
        if (rec != null) {
            return new AudioRecorder(source, rec);
        }
        Minim.error("Couldn't create an AudioRecorder for " + fileName + ".");
        return null;
    }

    public AudioInput getLineIn() {
        return this.getLineIn(2);
    }

    public AudioInput getLineIn(int type) {
        return this.getLineIn(type, 1024, 44100.0f, 16);
    }

    public AudioInput getLineIn(int type, int bufferSize) {
        return this.getLineIn(type, bufferSize, 44100.0f, 16);
    }

    public AudioInput getLineIn(int type, int bufferSize, float sampleRate) {
        return this.getLineIn(type, bufferSize, sampleRate, 16);
    }

    public AudioInput getLineIn(int type, int bufferSize, float sampleRate, int bitDepth) {
        AudioInput input = null;
        AudioStream stream = this.mimp.getAudioInput(type, bufferSize, sampleRate, bitDepth);
        if (stream != null) {
            AudioOut out = this.mimp.getAudioOutput(type, bufferSize, sampleRate, bitDepth);
            if (out != null) {
                input = new AudioInput(stream, out);
            } else {
                stream.close();
            }
        }
        if (input != null) {
            this.addSource(input);
        } else {
            Minim.error("Minim.getLineIn: attempt failed, could not secure an AudioInput.");
        }
        return input;
    }

    public AudioStream getInputStream(int type, int bufferSize, float sampleRate, int bitDepth) {
        AudioStream stream = this.mimp.getAudioInput(type, bufferSize, sampleRate, bitDepth);
        this.streams.add(stream);
        return stream;
    }

    public AudioOutput getLineOut() {
        return this.getLineOut(2);
    }

    public AudioOutput getLineOut(int type) {
        return this.getLineOut(type, 1024, 44100.0f, 16);
    }

    public AudioOutput getLineOut(int type, int bufferSize) {
        return this.getLineOut(type, bufferSize, 44100.0f, 16);
    }

    public AudioOutput getLineOut(int type, int bufferSize, float sampleRate) {
        return this.getLineOut(type, bufferSize, sampleRate, 16);
    }

    public AudioOutput getLineOut(int type, int bufferSize, float sampleRate, int bitDepth) {
        AudioOut out = this.mimp.getAudioOutput(type, bufferSize, sampleRate, bitDepth);
        if (out != null) {
            AudioOutput output = new AudioOutput(out);
            this.addSource(output);
            return output;
        }
        Minim.error("Minim.getLineOut: attempt failed, could not secure a LineOut.");
        return null;
    }
}

