/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.UGen;
import ddf.minim.ugens.Waveform;

public class WaveShaper
extends UGen {
    public UGen.UGenInput audio = new UGen.UGenInput(UGen.InputType.AUDIO);
    public UGen.UGenInput outAmplitude;
    public UGen.UGenInput mapAmplitude = new UGen.UGenInput(UGen.InputType.CONTROL);
    private boolean wrapMap;
    private Waveform mapShape;

    public WaveShaper(float outAmp, float mapAmp, Waveform mapShape) {
        this(outAmp, mapAmp, mapShape, false);
    }

    public WaveShaper(float outAmp, float mapAmp, Waveform mapShape, boolean wrapMap) {
        this.mapAmplitude.setLastValue(mapAmp);
        this.outAmplitude = new UGen.UGenInput(UGen.InputType.CONTROL);
        this.outAmplitude.setLastValue(outAmp);
        this.mapShape = mapShape;
        this.wrapMap = wrapMap;
    }

    protected void uGenerate(float[] channels) {
        for (int i = 0; i < channels.length; ++i) {
            float tmpIndex = this.mapAmplitude.getLastValue() * this.audio.getLastValues()[i] / 2.0f + 0.5f;
            if (this.wrapMap) {
                if ((tmpIndex %= 1.0f) < 0.0f) {
                    tmpIndex += 1.0f;
                }
            } else if (tmpIndex > 1.0f) {
                tmpIndex = 1.0f;
            } else if (tmpIndex < 0.0f) {
                tmpIndex = 0.0f;
            }
            channels[i] = this.outAmplitude.getLastValue() * this.mapShape.value(tmpIndex);
        }
    }
}

