/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.AudioOutput;
import ddf.minim.Minim;
import ddf.minim.UGen;

public class Damp
extends UGen {
    public UGen.UGenInput audio = new UGen.UGenInput(UGen.InputType.AUDIO);
    private float maxAmp;
    private float amp;
    private float dampTime;
    private float attackTime;
    private float beforeAmplitude;
    private float afterAmplitude;
    private float timeStepSize;
    private float now;
    private boolean isActivated;
    private boolean unpatchAfterDamp;
    private AudioOutput output;
    private UGen ugenOutput;

    public Damp() {
        this(0.0f, 1.0f, 1.0f, 0.0f, 0.0f);
    }

    public Damp(float dampTime) {
        this(0.0f, dampTime, 1.0f, 0.0f, 0.0f);
    }

    public Damp(float attackTime, float dampTime) {
        this(attackTime, dampTime, 1.0f, 0.0f, 0.0f);
    }

    public Damp(float attackTime, float dampTime, float maxAmp) {
        this(attackTime, dampTime, maxAmp, 0.0f, 0.0f);
    }

    public Damp(float attackTime, float dampTime, float maxAmp, float befAmp, float aftAmp) {
        this.attackTime = attackTime;
        this.dampTime = dampTime;
        this.maxAmp = maxAmp;
        this.beforeAmplitude = befAmp;
        this.afterAmplitude = aftAmp;
        this.isActivated = false;
        this.amp = this.beforeAmplitude;
        Minim.debug(" attackTime = " + attackTime + " dampTime = " + dampTime + " maxAmp = " + this.maxAmp + " now = " + this.now);
    }

    public void activate() {
        this.now = 0.0f;
        this.isActivated = true;
        this.amp = this.timeStepSize > this.attackTime ? this.maxAmp : 0.0f;
    }

    public void setAttackTime(float attackTime) {
        this.attackTime = attackTime;
    }

    public void setDampTime(float dampTime) {
        this.dampTime = dampTime;
    }

    public void setDampTimeFromDuration(float duration) {
        float tmpDampTime = duration - this.attackTime;
        if (tmpDampTime > 0.0f) {
            this.dampTime = tmpDampTime;
        } else {
            this.attackTime = duration / 2.0f;
            this.dampTime = duration / 2.0f;
        }
    }

    protected void sampleRateChanged() {
        this.timeStepSize = 1.0f / this.sampleRate();
    }

    public void unpatchAfterDamp(AudioOutput output) {
        this.unpatchAfterDamp = true;
        this.output = output;
    }

    public void unpatchAfterDamp(UGen output) {
        this.unpatchAfterDamp = true;
        this.ugenOutput = output;
    }

    protected void uGenerate(float[] channels) {
        if (!this.isActivated) {
            for (int i = 0; i < channels.length; ++i) {
                channels[i] = this.beforeAmplitude * this.audio.getLastValues()[i];
            }
        } else if (this.now >= this.dampTime + this.attackTime) {
            for (int i = 0; i < channels.length; ++i) {
                channels[i] = this.afterAmplitude * this.audio.getLastValues()[i];
            }
            if (this.unpatchAfterDamp) {
                if (this.output != null) {
                    this.unpatch(this.output);
                    this.output = null;
                } else if (this.ugenOutput != null) {
                    this.unpatch(this.ugenOutput);
                    this.ugenOutput = null;
                }
                this.unpatchAfterDamp = false;
                Minim.debug(" unpatching Damp ");
            }
        } else if (this.now >= this.attackTime) {
            this.amp += (this.afterAmplitude - this.amp) * this.timeStepSize / (this.dampTime + this.attackTime - this.now);
            for (int i = 0; i < channels.length; ++i) {
                channels[i] = this.amp * this.audio.getLastValues()[i];
            }
            this.now += this.timeStepSize;
        } else {
            this.amp += (this.maxAmp - this.amp) * this.timeStepSize / (this.attackTime - this.now);
            for (int i = 0; i < channels.length; ++i) {
                channels[i] = this.amp * this.audio.getLastValues()[i];
            }
            this.now += this.timeStepSize;
        }
    }
}

