/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.javasound;

import ddf.minim.Minim;
import ddf.minim.javasound.BasicMetaData;
import ddf.minim.javasound.FloatSampleBuffer;
import ddf.minim.javasound.JSMinim;
import ddf.minim.javasound.JSPCMAudioRecordingStream;
import ddf.minim.spi.AudioRecordingStream;
import ddf.minim.spi.SampleRecorder;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.SourceDataLine;
import org.tritonus.share.sampled.AudioSystemShadow;
import org.tritonus.share.sampled.AudioUtils;
import org.tritonus.share.sampled.file.AudioOutputStream;

final class JSStreamingSampleRecorder
implements SampleRecorder {
    private AudioOutputStream aos;
    private FloatSampleBuffer fsb;
    private String name;
    private AudioFileFormat.Type type;
    private AudioFormat format;
    private boolean recording;
    private JSMinim system;

    JSStreamingSampleRecorder(JSMinim sys, String fileName, AudioFileFormat.Type fileType, AudioFormat fileFormat, int bufferSize) {
        this.name = fileName;
        this.type = fileType;
        this.format = fileFormat;
        this.system = sys;
        try {
            this.aos = AudioSystemShadow.getAudioOutputStream((AudioFileFormat.Type)this.type, (AudioFormat)this.format, (long)-1L, (File)new File(this.name));
        }
        catch (IOException e) {
            this.system.error("Error obtaining new output stream: " + e.getMessage());
        }
        catch (IllegalArgumentException badarg) {
            this.system.error("Error obtaining new output stream for " + fileName + " with type " + this.type.toString() + " format " + this.format.toString() + " and bufferSize " + bufferSize + ".\n" + "The reason is " + badarg.getMessage());
        }
        this.fsb = new FloatSampleBuffer(this.format.getChannels(), bufferSize, this.format.getSampleRate());
        this.recording = false;
    }

    public String filePath() {
        return this.name;
    }

    public void beginRecord() {
        this.recording = true;
    }

    public void endRecord() {
        this.recording = false;
    }

    public boolean isRecording() {
        return this.recording;
    }

    public AudioRecordingStream save() {
        try {
            this.aos.close();
        }
        catch (IOException e) {
            Minim.error("AudioRecorder.save: An error occurred when trying to save the file:\n" + e.getMessage());
        }
        String filePath = this.filePath();
        AudioInputStream ais = this.system.getAudioInputStream(filePath);
        SourceDataLine sdl = this.system.getSourceDataLine(ais.getFormat(), 1024);
        long length = AudioUtils.frames2Millis((long)ais.getFrameLength(), (AudioFormat)this.format);
        BasicMetaData meta = new BasicMetaData(filePath, length, ais.getFrameLength());
        JSPCMAudioRecordingStream recording = new JSPCMAudioRecordingStream(this.system, meta, ais, sdl, 1024);
        return recording;
    }

    public void samples(float[] samp) {
        if (this.recording) {
            System.arraycopy(samp, 0, this.fsb.getChannel(0), 0, samp.length);
            byte[] raw = this.fsb.convertToByteArray(this.format);
            try {
                this.aos.write(raw, 0, raw.length);
            }
            catch (IOException e) {
                Minim.error("AudioRecorder: An error occurred while trying to write to the file:\n" + e.getMessage());
            }
        }
    }

    public void samples(float[] sampL, float[] sampR) {
        if (this.recording) {
            System.arraycopy(sampL, 0, this.fsb.getChannel(0), 0, sampL.length);
            System.arraycopy(sampR, 0, this.fsb.getChannel(1), 0, sampR.length);
            byte[] raw = this.fsb.convertToByteArray(this.format);
            try {
                this.aos.write(raw, 0, raw.length);
            }
            catch (IOException e) {
                Minim.error("AudioRecorder: An error occurred while trying to write to the file:\n" + e.getMessage());
            }
        }
    }
}

