/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.effects;

import ddf.minim.AudioEffect;
import ddf.minim.Minim;

public class Convolver
implements AudioEffect {
    protected float[] kernal;
    protected float[] outputL;
    protected float[] overlapL;
    protected float[] outputR;
    protected float[] overlapR;
    protected int sigLen;

    public Convolver(float[] k, int sigLength) {
        this.sigLen = sigLength;
        this.setKernal(k);
    }

    public void setKernal(float[] k) {
        this.kernal = new float[k.length];
        System.arraycopy(k, 0, this.kernal, 0, k.length);
        this.outputL = new float[this.sigLen + this.kernal.length - 1];
        this.outputR = new float[this.sigLen + this.kernal.length - 1];
        this.overlapL = new float[this.outputL.length - this.sigLen];
        this.overlapR = new float[this.outputR.length - this.sigLen];
    }

    public void process(float[] signal) {
        int i;
        if (signal.length != this.sigLen) {
            Minim.error("Convolver.process: signal.length does not equal sigLen, no processing will occurr.");
            return;
        }
        System.arraycopy(this.outputL, signal.length, this.overlapL, 0, this.overlapL.length);
        for (i = 0; i < this.outputL.length; ++i) {
            this.outputL[i] = 0.0f;
            for (int j = 0; j < this.kernal.length; ++j) {
                if (i - j < 0 || i - j > signal.length) continue;
                int n = i;
                this.outputL[n] = this.outputL[n] + this.kernal[j] * signal[i - j];
            }
        }
        System.arraycopy(this.outputL, 0, signal, 0, signal.length);
        for (i = 0; i < this.overlapL.length; ++i) {
            int n = i;
            signal[n] = signal[n] + this.overlapL[i];
        }
    }

    public void process(float[] sigLeft, float[] sigRight) {
        int i;
        if (sigLeft.length != this.sigLen || sigRight.length != this.sigLen) {
            Minim.error("Convolver.process: signal.length does not equal sigLen, no processing will occurr.");
            return;
        }
        System.arraycopy(this.outputL, sigLeft.length, this.overlapL, 0, this.overlapL.length);
        System.arraycopy(this.outputR, sigRight.length, this.overlapR, 0, this.overlapR.length);
        for (i = 0; i < this.outputL.length; ++i) {
            this.outputL[i] = 0.0f;
            this.outputR[i] = 0.0f;
            for (int j = 0; j < this.kernal.length; ++j) {
                if (i - j < 0 || i - j >= sigLeft.length) continue;
                int n = i;
                this.outputL[n] = this.outputL[n] + this.kernal[j] * sigLeft[i - j];
                int n2 = i;
                this.outputR[n2] = this.outputR[n2] + this.kernal[j] * sigRight[i - j];
            }
        }
        System.arraycopy(this.outputL, 0, sigLeft, 0, sigLeft.length);
        System.arraycopy(this.outputR, 0, sigRight, 0, sigRight.length);
        for (i = 0; i < this.overlapL.length; ++i) {
            int n = i;
            sigLeft[n] = sigLeft[n] + this.overlapL[i];
            int n3 = i;
            sigRight[n3] = sigRight[n3] + this.overlapR[i];
        }
    }
}

