/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.javasound;

import ddf.minim.AudioMetaData;
import ddf.minim.AudioSample;
import ddf.minim.Minim;
import ddf.minim.Recordable;
import ddf.minim.javasound.BasicMetaData;
import ddf.minim.javasound.FloatSampleBuffer;
import ddf.minim.javasound.JSAudioInput;
import ddf.minim.javasound.JSAudioOutput;
import ddf.minim.javasound.JSAudioRecording;
import ddf.minim.javasound.JSAudioRecordingClip;
import ddf.minim.javasound.JSAudioSample;
import ddf.minim.javasound.JSBaseAudioRecordingStream;
import ddf.minim.javasound.JSBufferedSampleRecorder;
import ddf.minim.javasound.JSMPEGAudioRecordingStream;
import ddf.minim.javasound.JSPCMAudioRecordingStream;
import ddf.minim.javasound.JSStreamingSampleRecorder;
import ddf.minim.javasound.MP3MetaData;
import ddf.minim.javasound.MpegAudioFileReader;
import ddf.minim.javasound.MpegAudioFileReaderWorkaround;
import ddf.minim.javasound.SampleSignal;
import ddf.minim.spi.AudioOut;
import ddf.minim.spi.AudioRecording;
import ddf.minim.spi.AudioRecordingStream;
import ddf.minim.spi.AudioStream;
import ddf.minim.spi.MinimServiceProvider;
import ddf.minim.spi.SampleRecorder;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.spi.mpeg.sampled.convert.MpegFormatConversionProvider;
import javazoom.spi.mpeg.sampled.file.MpegAudioFormat;
import org.tritonus.share.sampled.AudioUtils;
import org.tritonus.share.sampled.file.TAudioFileFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSMinim
implements MinimServiceProvider {
    private boolean debug = false;
    private Object fileLoader;
    private Method sketchPath;
    private Method createInput;
    private Mixer inputMixer;
    private Mixer outputMixer;

    public JSMinim(Object parent) {
        this.fileLoader = parent;
        this.inputMixer = null;
        this.outputMixer = null;
        String error = "";
        try {
            this.sketchPath = parent.getClass().getMethod("sketchPath", String.class);
            if (this.sketchPath.getReturnType() != String.class) {
                error = String.valueOf(error) + "The method sketchPath in the file loading object provided does not return a String!\n";
                this.sketchPath = null;
            }
        }
        catch (NoSuchMethodException ex) {
            error = String.valueOf(error) + "Couldn't find a sketchPath method on the file loading object provided!\n";
        }
        catch (Exception ex) {
            error = String.valueOf(error) + "Failed to get method sketchPath from file loading object provided!\n" + ex.getMessage() + "\n";
        }
        if (error.length() > 0) {
            error = String.valueOf(error) + "File recording will be disabled.";
            this.error(error);
        }
        error = "";
        try {
            this.createInput = parent.getClass().getMethod("createInput", String.class);
            if (this.createInput.getReturnType() != InputStream.class) {
                error = String.valueOf(error) + "The method createInput in the file loading object provided does not return an InputStream!\n";
                this.createInput = null;
            }
        }
        catch (NoSuchMethodException ex) {
            error = String.valueOf(error) + "Couldn't find a createInput method in the file loading object provided!\n";
        }
        catch (Exception ex) {
            error = String.valueOf(error) + "Failed to get method createInput from the file loading object provided!\n" + ex.getMessage() + "\n";
        }
        if (error.length() > 0) {
            error = String.valueOf(error) + "File loading will be disabled.";
            this.error(error);
        }
    }

    public void setInputMixer(Mixer mix) {
        this.inputMixer = mix;
    }

    public Mixer getInputMixer() {
        return this.inputMixer;
    }

    public void setOutputMixer(Mixer mix) {
        this.outputMixer = mix;
    }

    public Mixer getOutputMixer() {
        return this.outputMixer;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void debugOn() {
        this.debug = true;
    }

    @Override
    public void debugOff() {
        this.debug = false;
    }

    void debug(String s) {
        if (this.debug) {
            System.out.println("==== JavaSound Minim Debug ====");
            String[] lines = s.split("\n");
            int i = 0;
            while (i < lines.length) {
                System.out.println("==== " + lines[i]);
                ++i;
            }
            System.out.println();
        }
    }

    void error(String s) {
        System.out.println("==== JavaSound Minim Error ====");
        String[] lines = s.split("\n");
        int i = 0;
        while (i < lines.length) {
            System.out.println("==== " + lines[i]);
            ++i;
        }
        System.out.println();
    }

    @Override
    public SampleRecorder getSampleRecorder(Recordable source, String fileName, boolean buffered) {
        if (this.sketchPath == null) {
            return null;
        }
        String ext = fileName.substring(fileName.lastIndexOf(46) + 1).toLowerCase();
        this.debug("createRecorder: file extension is " + ext + ".");
        AudioFileFormat.Type fileType = null;
        if (ext.equals(Minim.WAV.getExtension())) {
            fileType = Minim.WAV;
        } else if (ext.equals(Minim.AIFF.getExtension()) || ext.equals("aif")) {
            fileType = Minim.AIFF;
        } else if (ext.equals(Minim.AIFC.getExtension())) {
            fileType = Minim.AIFC;
        } else if (ext.equals(Minim.AU.getExtension())) {
            fileType = Minim.AU;
        } else if (ext.equals(Minim.SND.getExtension())) {
            fileType = Minim.SND;
        } else {
            this.error("The extension " + ext + " is not a recognized audio file type.");
            return null;
        }
        SampleRecorder recorder = null;
        try {
            String destPath = (String)this.sketchPath.invoke(this.fileLoader, fileName);
            recorder = buffered ? new JSBufferedSampleRecorder(this, destPath, fileType, source.getFormat(), source.bufferSize()) : new JSStreamingSampleRecorder(this, destPath, fileType, source.getFormat(), source.bufferSize());
        }
        catch (Exception ex) {
            Minim.error("Couldn't invoke the sketchPath method: " + ex.getMessage());
        }
        return recorder;
    }

    @Override
    public AudioRecordingStream getAudioRecordingStream(String filename, int bufferSize, boolean inMemory) {
        JSBaseAudioRecordingStream mstream = null;
        AudioInputStream ais = this.getAudioInputStream(filename);
        if (inMemory && ais.markSupported()) {
            ais.mark((int)ais.getFrameLength() * ais.getFormat().getFrameSize());
        }
        this.debug("Reading from " + ais.getClass().toString());
        if (ais != null) {
            this.debug("File format is: " + ais.getFormat().toString());
            AudioFormat format = ais.getFormat();
            if (format instanceof MpegAudioFormat) {
                AudioFormat baseFormat = format;
                format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, baseFormat.getSampleRate(), 16, baseFormat.getChannels(), baseFormat.getChannels() * 2, baseFormat.getSampleRate(), false);
                AudioInputStream decAis = this.getAudioInputStream(format, ais);
                SourceDataLine line = this.getSourceDataLine(format, bufferSize);
                if (decAis != null && line != null) {
                    Long dur;
                    Map<String, Object> props = this.getID3Tags(filename);
                    long lengthInMillis = -1L;
                    if (props.containsKey("duration") && (dur = (Long)props.get("duration")) > 0L) {
                        lengthInMillis = dur / 1000L;
                    }
                    MP3MetaData meta = new MP3MetaData(filename, lengthInMillis, props);
                    mstream = new JSMPEGAudioRecordingStream(this, (AudioMetaData)meta, ais, decAis, line, bufferSize);
                }
            } else {
                SourceDataLine line = this.getSourceDataLine(format, bufferSize);
                if (line != null) {
                    long length = AudioUtils.frames2Millis((long)ais.getFrameLength(), (AudioFormat)format);
                    BasicMetaData meta = new BasicMetaData(filename, length, ais.getFrameLength());
                    mstream = new JSPCMAudioRecordingStream(this, meta, ais, line, bufferSize);
                }
            }
        }
        return mstream;
    }

    private Map<String, Object> getID3Tags(String filename) {
        this.debug("Getting the properties.");
        Map<String, Object> props = new HashMap<String, Object>();
        try {
            MpegAudioFileReader reader = new MpegAudioFileReader(this);
            InputStream stream = (InputStream)this.createInput.invoke(this.fileLoader, filename);
            AudioFileFormat baseFileFormat = reader.getAudioFileFormat(stream, stream.available());
            stream.close();
            if (baseFileFormat instanceof TAudioFileFormat) {
                TAudioFileFormat fileFormat = (TAudioFileFormat)baseFileFormat;
                props = fileFormat.properties();
                if (props.size() == 0) {
                    this.error("No file properties available for " + filename + ".");
                } else {
                    this.debug("File properties: " + props.toString());
                }
            }
        }
        catch (UnsupportedAudioFileException e) {
            this.error("Couldn't get the file format for " + filename + ": " + e.getMessage());
        }
        catch (IOException e) {
            this.error("Couldn't access " + filename + ": " + e.getMessage());
        }
        catch (Exception e) {
            this.error("Error invoking createInput on the file loader object: " + e.getMessage());
        }
        return props;
    }

    @Override
    public AudioStream getAudioInput(int type, int bufferSize, float sampleRate, int bitDepth) {
        if (bitDepth != 8 && bitDepth != 16) {
            throw new IllegalArgumentException("Unsupported bit depth, use either 8 or 16.");
        }
        AudioFormat format = new AudioFormat(sampleRate, bitDepth, type, true, false);
        TargetDataLine line = this.getTargetDataLine(format, bufferSize * 4);
        if (line != null) {
            return new JSAudioInput(line, bufferSize);
        }
        return null;
    }

    @Override
    public AudioSample getAudioSample(String filename, int bufferSize) {
        AudioInputStream ais = this.getAudioInputStream(filename);
        if (ais != null) {
            BasicMetaData meta = null;
            AudioFormat format = ais.getFormat();
            FloatSampleBuffer samples = null;
            if (format instanceof MpegAudioFormat) {
                AudioFormat baseFormat = format;
                format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, baseFormat.getSampleRate(), 16, baseFormat.getChannels(), baseFormat.getChannels() * 2, baseFormat.getSampleRate(), false);
                ais = this.getAudioInputStream(format, ais);
                Map<String, Object> props = this.getID3Tags(filename);
                long dur = (Long)props.get("duration");
                int toRead = (int)AudioUtils.millis2Bytes((long)(dur / 1000L), (AudioFormat)format);
                samples = this.loadFloatAudio(ais, toRead);
                meta = new MP3MetaData(filename, dur / 1000L, props);
            } else {
                samples = this.loadFloatAudio(ais, (int)ais.getFrameLength() * format.getFrameSize());
                long length = AudioUtils.frames2Millis((long)samples.getSampleCount(), (AudioFormat)format);
                meta = new BasicMetaData(filename, length, samples.getSampleCount());
            }
            AudioOut out = this.getAudioOutput(format.getChannels(), bufferSize, format.getSampleRate(), format.getSampleSizeInBits());
            if (out != null) {
                SampleSignal ssig = new SampleSignal(samples);
                out.setAudioSignal(ssig);
                return new JSAudioSample(meta, ssig, out);
            }
            this.error("Couldn't acquire an output.");
        }
        return null;
    }

    @Override
    public AudioSample getAudioSample(float[] samples, AudioFormat format, int bufferSize) {
        FloatSampleBuffer sample = new FloatSampleBuffer(1, samples.length, format.getSampleRate());
        System.arraycopy(samples, 0, sample.getChannel(0), 0, samples.length);
        return this.getAudioSampleImp(sample, format, bufferSize);
    }

    @Override
    public AudioSample getAudioSample(float[] left, float[] right, AudioFormat format, int bufferSize) {
        FloatSampleBuffer sample = new FloatSampleBuffer(2, left.length, format.getSampleRate());
        System.arraycopy(left, 0, sample.getChannel(0), 0, left.length);
        System.arraycopy(right, 0, sample.getChannel(1), 0, right.length);
        return this.getAudioSampleImp(sample, format, bufferSize);
    }

    private JSAudioSample getAudioSampleImp(FloatSampleBuffer samples, AudioFormat format, int bufferSize) {
        AudioOut out = this.getAudioOutput(samples.getChannelCount(), bufferSize, format.getSampleRate(), format.getSampleSizeInBits());
        if (out != null) {
            SampleSignal ssig = new SampleSignal(samples);
            out.setAudioSignal(ssig);
            long length = AudioUtils.frames2Millis((long)samples.getSampleCount(), (AudioFormat)format);
            BasicMetaData meta = new BasicMetaData(samples.toString(), length, samples.getSampleCount());
            return new JSAudioSample(meta, ssig, out);
        }
        this.error("Couldn't acquire an output.");
        return null;
    }

    @Override
    public AudioOut getAudioOutput(int type, int bufferSize, float sampleRate, int bitDepth) {
        if (bitDepth != 8 && bitDepth != 16) {
            throw new IllegalArgumentException("Unsupported bit depth, use either 8 or 16.");
        }
        AudioFormat format = new AudioFormat(sampleRate, bitDepth, type, true, false);
        SourceDataLine sdl = this.getSourceDataLine(format, bufferSize);
        if (sdl != null) {
            return new JSAudioOutput(sdl, bufferSize);
        }
        return null;
    }

    public AudioRecording getAudioRecordingClip(String filename) {
        Clip clip = null;
        BasicMetaData meta = null;
        AudioInputStream ais = this.getAudioInputStream(filename);
        if (ais != null) {
            DataLine.Info info;
            AudioFormat format = ais.getFormat();
            if (format instanceof MpegAudioFormat) {
                AudioFormat baseFormat = format;
                format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, baseFormat.getSampleRate(), 16, baseFormat.getChannels(), baseFormat.getChannels() * 2, baseFormat.getSampleRate(), false);
                ais = this.getAudioInputStream(format, ais);
            }
            if (AudioSystem.isLineSupported(info = new DataLine.Info(Clip.class, ais.getFormat()))) {
                try {
                    clip = (Clip)AudioSystem.getLine(info);
                    clip.open(ais);
                }
                catch (Exception e) {
                    this.error("Error obtaining Javasound Clip: " + e.getMessage());
                    return null;
                }
                Map<String, Object> props = this.getID3Tags(filename);
                long lengthInMillis = -1L;
                if (props.containsKey("duration")) {
                    Long dur = (Long)props.get("duration");
                    lengthInMillis = dur / 1000L;
                }
                meta = new MP3MetaData(filename, lengthInMillis, props);
            } else {
                this.error("File format not supported.");
                return null;
            }
        }
        if (meta == null) {
            meta = new BasicMetaData(filename, clip.getMicrosecondLength() / 1000L, -1L);
        }
        return new JSAudioRecordingClip(clip, meta);
    }

    @Override
    public AudioRecording getAudioRecording(String filename) {
        BasicMetaData meta = null;
        AudioInputStream ais = this.getAudioInputStream(filename);
        if (ais != null) {
            byte[] samples;
            AudioFormat format = ais.getFormat();
            if (format instanceof MpegAudioFormat) {
                AudioFormat baseFormat = format;
                format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, baseFormat.getSampleRate(), 16, baseFormat.getChannels(), baseFormat.getChannels() * 2, baseFormat.getSampleRate(), false);
                ais = this.getAudioInputStream(format, ais);
                Map<String, Object> props = this.getID3Tags(filename);
                long dur = (Long)props.get("duration");
                int toRead = (int)AudioUtils.millis2Bytes((long)(dur / 1000L), (AudioFormat)format);
                samples = this.loadByteAudio(ais, toRead);
                meta = new MP3MetaData(filename, dur / 1000L, props);
            } else {
                samples = this.loadByteAudio(ais, (int)ais.getFrameLength() * format.getFrameSize());
                long length = AudioUtils.bytes2Millis((long)samples.length, (AudioFormat)format);
                meta = new BasicMetaData(filename, length, samples.length);
            }
            SourceDataLine line = this.getSourceDataLine(format, 2048);
            if (line != null) {
                return new JSAudioRecording(this, samples, line, meta);
            }
        }
        return null;
    }

    private FloatSampleBuffer loadFloatAudio(AudioInputStream ais, int toRead) {
        FloatSampleBuffer samples = new FloatSampleBuffer();
        int totalRead = 0;
        byte[] rawBytes = new byte[toRead];
        try {
            while (totalRead < toRead) {
                int actualRead = ais.read(rawBytes, totalRead, toRead - totalRead);
                if (actualRead < 1) break;
                totalRead += actualRead;
            }
            ais.close();
        }
        catch (Exception ioe) {
            this.error("Error loading file into memory: " + ioe.getMessage());
        }
        this.debug("Needed to read " + toRead + " actually read " + totalRead);
        samples.initFromByteArray(rawBytes, 0, totalRead, ais.getFormat());
        return samples;
    }

    private byte[] loadByteAudio(AudioInputStream ais, int toRead) {
        int totalRead = 0;
        byte[] rawBytes = new byte[toRead];
        try {
            while (totalRead < toRead) {
                int actualRead = ais.read(rawBytes, totalRead, toRead - totalRead);
                if (actualRead < 1) break;
                totalRead += actualRead;
            }
            ais.close();
        }
        catch (Exception ioe) {
            this.error("Error loading file into memory: " + ioe.getMessage());
        }
        this.debug("Needed to read " + toRead + " actually read " + totalRead);
        return rawBytes;
    }

    AudioInputStream getAudioInputStream(String filename) {
        AudioInputStream ais = null;
        BufferedInputStream bis = null;
        if (filename.startsWith("http")) {
            try {
                ais = this.getAudioInputStream(new URL(filename));
            }
            catch (MalformedURLException e) {
                this.error("Bad URL: " + e.getMessage());
            }
            catch (UnsupportedAudioFileException e) {
                this.error("URL is in an unsupported audio file format: " + e.getMessage());
            }
            catch (IOException e) {
                Minim.error("Error reading the URL: " + e.getMessage());
            }
        } else {
            try {
                InputStream is = (InputStream)this.createInput.invoke(this.fileLoader, filename);
                this.debug("Base input stream is: " + is.toString());
                bis = new BufferedInputStream(is);
                ais = this.getAudioInputStream(bis);
                this.debug("Acquired AudioInputStream.\nIt is " + ais.getFrameLength() + " frames long.\n" + "Marking support: " + ais.markSupported());
            }
            catch (IOException ioe) {
                this.error("IOException: " + ioe.getMessage());
            }
            catch (UnsupportedAudioFileException uafe) {
                this.error("Unsupported Audio File: " + uafe.getMessage());
            }
            catch (Exception e) {
                this.error("Error invoking createInput on the file loader object: " + e.getMessage());
            }
        }
        return ais;
    }

    AudioInputStream getAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        return new MpegAudioFileReaderWorkaround(this).getAudioInputStream(url, null);
    }

    AudioInputStream getAudioInputStream(InputStream is) throws UnsupportedAudioFileException, IOException {
        try {
            return AudioSystem.getAudioInputStream(is);
        }
        catch (Exception iae) {
            this.debug("Using AppletMpegSPIWorkaround to get codec");
            return new MpegAudioFileReader(this).getAudioInputStream(is);
        }
    }

    AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioInputStream sourceStream) {
        try {
            return AudioSystem.getAudioInputStream(targetFormat, sourceStream);
        }
        catch (IllegalArgumentException iae) {
            this.debug("Using AppletMpegSPIWorkaround to get codec");
            try {
                Class.forName("javazoom.spi.mpeg.sampled.convert.MpegFormatConversionProvider");
                return new MpegFormatConversionProvider().getAudioInputStream(targetFormat, sourceStream);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalArgumentException("Mpeg codec not properly installed");
            }
        }
    }

    SourceDataLine getSourceDataLine(AudioFormat format, int bufferSize) {
        SourceDataLine line = null;
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
        if (AudioSystem.isLineSupported(info)) {
            try {
                line = this.outputMixer == null ? (SourceDataLine)AudioSystem.getLine(info) : (SourceDataLine)this.outputMixer.getLine(info);
                line.open(format, bufferSize * format.getFrameSize() * 4);
                if (line.isOpen()) {
                    this.debug("SourceDataLine is " + line.getClass().toString() + "\n" + "Buffer size is " + line.getBufferSize() + " bytes.\n" + "Format is " + line.getFormat().toString() + ".");
                    return line;
                }
            }
            catch (LineUnavailableException e) {
                this.error("Couldn't open the line: " + e.getMessage());
            }
        }
        this.error("Unable to return a SourceDataLine: unsupported format - " + format.toString());
        return line;
    }

    TargetDataLine getTargetDataLine(AudioFormat format, int bufferSize) {
        TargetDataLine line = null;
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, format);
        if (AudioSystem.isLineSupported(info)) {
            try {
                line = this.inputMixer == null ? (TargetDataLine)AudioSystem.getLine(info) : (TargetDataLine)this.inputMixer.getLine(info);
                line.open(format, bufferSize * format.getFrameSize());
                this.debug("TargetDataLine buffer size is " + line.getBufferSize() + "\n" + "TargetDataLine format is " + line.getFormat().toString() + "\n" + "TargetDataLine info is " + line.getLineInfo().toString());
            }
            catch (Exception e) {
                this.error("Error acquiring TargetDataLine: " + e.getMessage());
            }
        } else {
            this.error("Unable to return a TargetDataLine: unsupported format - " + format.toString());
        }
        return line;
    }
}

