[![CI](https://github.com/day8/lein-cofx/workflows/ci/badge.svg)](https://github.com/day8/lein-cofx/actions?workflow=ci)
[![CD](https://github.com/day8/lein-cofx/workflows/cd/badge.svg)](https://github.com/day8/lein-cofx/actions?workflow=cd)
[![GitHub tag (latest by date)](https://img.shields.io/github/v/tag/day8/lein-cofx?style=flat)](https://github.com/day8/lein-cofx/tags)
[![Clojars Project](https://img.shields.io/clojars/v/day8/lein-cofx.svg)](https://clojars.org/day8/lein-cofx)
[![GitHub issues](https://img.shields.io/github/issues-raw/day8/lein-cofx?style=flat)](https://github.com/day8/lein-cofx/issues)
[![GitHub pull requests](https://img.shields.io/github/issues-pr/day8/lein-cofx)](https://github.com/day8/lein-cofx/pulls)
[![License](https://img.shields.io/github/license/day8/lein-cofx.svg)](LICENSE)

# lein-cofx

A Leiningen middleware to inject `project.clj` with some
[execution context](http://tomasp.net/coeffects/).

Only a few useful known replacements are currently supported.

## Usage

### Step 1. Add Plugin

Add the following dependency into the `:plugins` vector of `project.clj`: <br>
[![Clojars Project](https://img.shields.io/clojars/v/day8/lein-cofx.svg)](https://clojars.org/day8/lein-cofx)

### Step 2. Add Middleware

Add the following to the `:middleware` vector of `project.clj`: <br>

```clojure
:middleware [leiningen.cofx/middleware]
```

### Step 3. Replace Values

Replace any value, at any level of nesting, in `project.clj` with a supported
keyword such as `:lein-cofx/git-status-to-version`.

#### Git-based version

```clojure
:lein-cofx/git-status-to-version
;; ->
"0.0.1"
```

#### ISO-like datetime

```clojure
:lein-cofx/iso-date-time
;; ->
"2019-11-18T00:05:02.273361"
 ```

#### ISO week-based date

```clojure
:lein-cofx/iso-week-date
;; ->
"2019-W47-2"
```

## Username

```clojure
:lein-cofx/user-name
;; ->
"isaac"
```

## License

Copyright © 2019 Day8 Technology Pty Ltd 

Derived from lein-git-version © 2017 Reid "arrdem" McKenzie

Derived from lein-git-version © 2016 Colin Steele

Derived from lein-git-version © 2011 Michał Marczyk

This program and the accompanying materials are made available under the
terms of the Eclipse Public License 2.0 which is available at
http://www.eclipse.org/legal/epl-2.0.

This Source Code may also be made available under the following Secondary
Licenses when the conditions for such availability set forth in the Eclipse
Public License, v. 2.0 are satisfied: GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or (at your
option) any later version, with the GNU Classpath Exception which is available
at https://www.gnu.org/software/classpath/license.html.
