The Clojure debug-repl
======================

[![Clojars Project](https://img.shields.io/clojars/v/dawcs/debug-repl.svg)](https://clojars.org/dawcs/debug-repl)

The interface is meant to be dead simple:
`(use 'dawcs.debug-repl)` loads it, and `(debug-repl)` invokes it.

That's about it.  When you enter the debug-repl, the regular
repl prompt will be replaced with `dr =>`

Available commands: 
```
:q - quit(continue thread execution)
:l - view locals
:h - display help
```

An example will make it clearer:

```clojure
user=>   (let [c 1 d 2]
    (defn a [b c]
      (debug-repl)
      d))
#'user/a

user=>   (a "foo" "bar")

dr-1-1 => c
"bar"

dr-1-1 => d
2

dr-1-1 => :l
{fn__104 #<user$eval__103 user$eval__103@5f6303>, c "bar", d 2, fn__106 #<user$eval__103$a__105 user$eval__103$a__105@179dce4>, b "foo", counter__56__auto__ 1001}

dr-1-1 => (str b c)
"foobar"

dr-1-1 => :q
2
user=>
```
