/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit.server;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.httpkit.HttpMethod;
import org.httpkit.HttpUtils;
import org.httpkit.HttpVersion;
import org.httpkit.LineReader;
import org.httpkit.LineTooLargeException;
import org.httpkit.ProtocolException;
import org.httpkit.RequestTooLargeException;
import org.httpkit.server.HttpRequest;
import org.httpkit.server.ProxyProtocolOption;

public class HttpDecoder {
    private static final String IPV4SEG = "(?:0|1\\d{0,2}|2(?:[0-4]\\d*|5[0-5]?|[6-9])?|[3-9]\\d?)";
    private static final String IPV4ADDR = "(?:0|1\\d{0,2}|2(?:[0-4]\\d*|5[0-5]?|[6-9])?|[3-9]\\d?)(?:\\.(?:0|1\\d{0,2}|2(?:[0-4]\\d*|5[0-5]?|[6-9])?|[3-9]\\d?)){3}";
    private static final String PORT = "[1-9]\\d{0,4}";
    private static final Pattern PROXY_PATTERN = Pattern.compile("PROXY\\x20TCP4\\x20((?:0|1\\d{0,2}|2(?:[0-4]\\d*|5[0-5]?|[6-9])?|[3-9]\\d?)(?:\\.(?:0|1\\d{0,2}|2(?:[0-4]\\d*|5[0-5]?|[6-9])?|[3-9]\\d?)){3})\\x20((?:0|1\\d{0,2}|2(?:[0-4]\\d*|5[0-5]?|[6-9])?|[3-9]\\d?)(?:\\.(?:0|1\\d{0,2}|2(?:[0-4]\\d*|5[0-5]?|[6-9])?|[3-9]\\d?)){3})\\x20([1-9]\\d{0,4})\\x20([1-9]\\d{0,4})");
    private State state;
    private ProxyProtocolOption proxyProtocolOption;
    private int readRemaining = 0;
    private int readCount = 0;
    private String xForwardedFor;
    private String xForwardedProto;
    private int xForwardedPort;
    HttpRequest request;
    private Map<String, Object> headers = new TreeMap<String, Object>();
    byte[] content;
    private final int maxBody;
    private final LineReader lineReader;

    public HttpDecoder(int maxBody, int maxLine, ProxyProtocolOption proxyProtocolOption) {
        this.maxBody = maxBody;
        this.lineReader = new LineReader(maxLine);
        this.proxyProtocolOption = proxyProtocolOption == null ? ProxyProtocolOption.DISABLED : proxyProtocolOption;
        this.state = proxyProtocolOption == ProxyProtocolOption.DISABLED ? State.READ_INITIAL : State.CONNECTION_OPEN;
    }

    private boolean parseProxyLine(String line) throws ProtocolException {
        if (!line.startsWith("PROXY ")) {
            return false;
        }
        Matcher m = PROXY_PATTERN.matcher(line);
        if (!m.matches()) {
            throw new ProtocolException("Unsupported or malformed proxy header: " + line);
        }
        try {
            InetAddress clientAddr = InetAddress.getByName(m.group(1));
            InetAddress proxyAddr = InetAddress.getByName(m.group(2));
            int clientPort = Integer.parseInt(m.group(3), 10);
            int proxyPort = Integer.parseInt(m.group(4), 10);
            if (((clientPort | proxyPort) & 0xFFFF0000) != 0) {
                throw new ProtocolException("Invalid port number: " + line);
            }
            this.xForwardedFor = clientAddr.getHostAddress();
            if (proxyPort == 80) {
                this.xForwardedProto = "http";
            } else if (proxyPort == 443) {
                this.xForwardedProto = "https";
            }
            this.xForwardedPort = proxyPort;
            return true;
        }
        catch (NumberFormatException ex) {
            throw new ProtocolException("Malformed port in: " + line);
        }
        catch (UnknownHostException ex) {
            throw new ProtocolException("Malformed address in: " + line);
        }
    }

    private void createRequest(String sb) throws ProtocolException {
        int cEnd;
        int aStart = HttpUtils.findNonWhitespace(sb, 0);
        int aEnd = HttpUtils.findWhitespace(sb, aStart);
        int bStart = HttpUtils.findNonWhitespace(sb, aEnd);
        int bEnd = HttpUtils.findWhitespace(sb, bStart);
        int cStart = HttpUtils.findNonWhitespace(sb, bEnd);
        if (cStart < (cEnd = HttpUtils.findEndOfString(sb, cStart))) {
            try {
                HttpMethod method = HttpMethod.valueOf(sb.substring(aStart, aEnd).toUpperCase());
                HttpVersion version = HttpVersion.HTTP_1_1;
                if ("HTTP/1.0".equals(sb.substring(cStart, cEnd))) {
                    version = HttpVersion.HTTP_1_0;
                }
                this.request = new HttpRequest(method, sb.substring(bStart, bEnd), version);
            }
            catch (Exception e) {
                throw new ProtocolException("method not understand");
            }
        } else {
            throw new ProtocolException("not http?");
        }
    }

    public boolean requiresContinue() {
        String expect = (String)this.headers.get("expect");
        return this.request != null && this.request.version == HttpVersion.HTTP_1_1 && expect != null && "100-continue".equalsIgnoreCase(expect);
    }

    public HttpRequest decode(ByteBuffer buffer) throws LineTooLargeException, ProtocolException, RequestTooLargeException {
        while (buffer.hasRemaining()) {
            switch (this.state) {
                case ALL_READ: {
                    return this.request;
                }
                case CONNECTION_OPEN: {
                    String line = this.lineReader.readLine(buffer);
                    if (line == null) break;
                    if (this.parseProxyLine(line)) {
                        this.state = State.READ_INITIAL;
                        break;
                    }
                    if (this.proxyProtocolOption == ProxyProtocolOption.OPTIONAL) {
                        this.createRequest(line);
                        this.state = State.READ_HEADER;
                        break;
                    }
                    throw new ProtocolException("Expected PROXY header, got: " + line);
                }
                case READ_INITIAL: {
                    String line = this.lineReader.readLine(buffer);
                    if (line == null) break;
                    this.createRequest(line);
                    this.state = State.READ_HEADER;
                    break;
                }
                case READ_HEADER: {
                    this.readHeaders(buffer);
                    break;
                }
                case READ_CHUNK_SIZE: {
                    String line = this.lineReader.readLine(buffer);
                    if (line == null) break;
                    this.readRemaining = HttpUtils.getChunkSize(line);
                    if (this.readRemaining == 0) {
                        this.state = State.READ_CHUNK_FOOTER;
                        break;
                    }
                    this.throwIfBodyIsTooLarge();
                    if (this.content == null) {
                        this.content = new byte[this.readRemaining];
                    } else if (this.content.length < this.readCount + this.readRemaining) {
                        int newLength = (int)((double)(this.readRemaining + this.readCount) * 1.3);
                        this.content = Arrays.copyOf(this.content, newLength);
                    }
                    this.state = State.READ_CHUNKED_CONTENT;
                    break;
                }
                case READ_FIXED_LENGTH_CONTENT: {
                    this.readFixedLength(buffer);
                    if (this.readRemaining != 0) break;
                    this.finish();
                    break;
                }
                case READ_CHUNKED_CONTENT: {
                    this.readFixedLength(buffer);
                    if (this.readRemaining != 0) break;
                    this.state = State.READ_CHUNK_DELIMITER;
                    break;
                }
                case READ_CHUNK_FOOTER: {
                    this.readEmptyLine(buffer);
                    this.finish();
                    break;
                }
                case READ_CHUNK_DELIMITER: {
                    this.readEmptyLine(buffer);
                    this.state = State.READ_CHUNK_SIZE;
                }
            }
        }
        return this.state == State.ALL_READ ? this.request : null;
    }

    private void finish() {
        this.state = State.ALL_READ;
        this.request.setBody(this.content, this.readCount);
    }

    void readEmptyLine(ByteBuffer buffer) {
        byte b = buffer.get();
        if (b == 13 && buffer.hasRemaining()) {
            buffer.get();
        }
    }

    void readFixedLength(ByteBuffer buffer) {
        int toRead = Math.min(buffer.remaining(), this.readRemaining);
        buffer.get(this.content, this.readCount, toRead);
        this.readRemaining -= toRead;
        this.readCount += toRead;
    }

    private void readHeaders(ByteBuffer buffer) throws LineTooLargeException, RequestTooLargeException, ProtocolException {
        if (this.proxyProtocolOption == ProxyProtocolOption.OPTIONAL || this.proxyProtocolOption == ProxyProtocolOption.ENABLED) {
            this.headers.put("x-forwarded-for", this.xForwardedFor);
            this.headers.put("x-forwarded-proto", this.xForwardedProto);
            this.headers.put("x-forwarded-port", this.xForwardedPort);
        }
        String line = this.lineReader.readLine(buffer);
        while (line != null && !line.isEmpty()) {
            HttpUtils.splitAndAddHeader(line, this.headers);
            line = this.lineReader.readLine(buffer);
        }
        if (line == null) {
            return;
        }
        this.request.setHeaders(this.headers);
        String te = HttpUtils.getStringValue(this.headers, "transfer-encoding");
        if ("chunked".equals(te)) {
            this.state = State.READ_CHUNK_SIZE;
        } else {
            String cl = HttpUtils.getStringValue(this.headers, "content-length");
            if (cl != null) {
                try {
                    this.readRemaining = Integer.parseInt(cl);
                    if (this.readRemaining > 0) {
                        this.throwIfBodyIsTooLarge();
                        this.content = new byte[this.readRemaining];
                        this.state = State.READ_FIXED_LENGTH_CONTENT;
                    }
                    this.state = State.ALL_READ;
                }
                catch (NumberFormatException e) {
                    throw new ProtocolException(e.getMessage());
                }
            } else {
                this.state = State.ALL_READ;
            }
        }
    }

    public void reset() {
        this.state = State.READ_INITIAL;
        this.headers = new TreeMap<String, Object>();
        this.readCount = 0;
        this.content = null;
        this.lineReader.reset();
        this.request = null;
    }

    private void throwIfBodyIsTooLarge() throws RequestTooLargeException {
        if (this.readCount + this.readRemaining > this.maxBody) {
            throw new RequestTooLargeException("request body " + (this.readCount + this.readRemaining) + "; max request body " + this.maxBody);
        }
    }

    public static enum State {
        ALL_READ,
        CONNECTION_OPEN,
        READ_INITIAL,
        READ_HEADER,
        READ_FIXED_LENGTH_CONTENT,
        READ_CHUNK_SIZE,
        READ_CHUNKED_CONTENT,
        READ_CHUNK_FOOTER,
        READ_CHUNK_DELIMITER;

    }
}

