(ns saldo.transact
  "Transactor functions."
  (:require [datahike.api :as d]))

(defn credit [db id amount unit]
  (let [e (d/entity db id)
        balance (+ (:account/balance e 0) amount)
        acc-unit (:account/unit e)]
    (when-not (= acc-unit unit)
      (throw (ex-info "Credit unit does not match account unit."
                      {:unit unit
                       :account acc-unit})))
    (if (>= balance 0)
      [[:db/add id :account/balance balance]]
      (throw (ex-info "Insufficient funds."
                      {:from id
                       :amount amount})))))

(defn transfer [db from to amount unit]
  [[:db.fn/call credit from (- amount) unit]
   [:db.fn/call credit to amount unit]])

