(ns saldo.query
  "Query building blocks. This namespace only contains values."
  (:require [datahike.api :as d]))

(def rules
  '[[(delegate ?c ?p) (?c :voting/delegate ?p)]
    [(delegate ?c ?p) (?c :voting/delegate ?c1) (delegate ?c1 ?p) ]])

(def accounts-query
  '[:find ?n ?b
    :where
    [?acc :account/balance ?b]
    [?acc :account/name ?n]])

(def transfers-query
  '[:find ?fn ?tn ?a ?u ?c
    :in $ ?block-height
    :where
    [?e :transfer/from ?f]
    [?f :account/name ?fn]
    [?e :transfer/to ?t]
    [?t :account/name ?tn]
    [?e :transfer/amount ?a]
    [?e :transfer/unit ?u]
    [?e :transfer/recorded ?c]
    [?e :block/height ?block-height]])

(def voters-query
  '[:find ?vn
    :in $ ?delegate
    :where
    [?v :account/name ?vn]
    [?v :voting/delegate ?d]
    [?d :account/name ?delegate]])

(def transitive-voters-query
  '[:find ?vn
    :in $ ?delegate %
    :where
    [?d :account/name ?delegate]
    (delegate ?v ?d)
    [?v :account/name ?vn]])
