# saldo

[saldo](https://it.wikipedia.org/wiki/Saldo) provides
[datalog](https://github.com/replikativ/datahike) primitives for accounting,
voting and management processes. It is supposed to provide a predefined,
general, composable set of attribute schemata, transaction and query primitives.

It can be integrated with backend systems to provide monetary booking primitives
for example. It is part of the [datopia](https://github.com/datopia/) project to
provide a neutrally managed datalog database on a blockchain.

## Usage

~~~clojure
(require '[datahike.api :as d]
         '[clojure.java.io :as io]
         '[saldo.transact :as transact]
         '[saldo.query :as query])
		 
	
(def uri "datahike:mem:///api-test")

(def schema (-> "schema.edn"
                io/resource
                slurp
                read-string))

(def example-txs (-> "example-txs.edn"
                    io/resource
                    slurp
                    read-string))

(d/create-database-with-schema uri schema) 

(def conn (d/connect uri))

;; lets insert some data
@(d/transact conn example-txs)


;; get all voters for Christian

(d/q query/voters-query
                  @conn
                  "Christian")

;; => #{["Danny"]}

;; all transitive voters for Moe
(d/q query/transitive-voters-query
                  @conn
                  "Moe"
                  query/rules)

;; => #{["Danny"] ["Christian"]}


(dispatch {:type :transfer
           :amount 5
           :from "Moe"
           :to "Christian"
		   :unit :dollar}
          conn)
~~~

## TODO

- use fully namespace qualified keywords
- split schema to allow cherry-picking

## References

- https://gist.github.com/pelle/2635666 as a basic example for Datomic
- https://gist.github.com/vizanto/91d7e51f8a130dd8a2df390be78cdbb0

## License

Copyright © 2018 Christian Weilbach

Distributed under the MIT License.
