(ns ksqldb.client.connector-api
  (:require [cheshire.core :as json]
            [clj-http.client :as http]
            [ksql.gen.protocol :as c]
            [clojure.tools.logging :as log]
            [ksql.gen.protocol :as p]))


; :connector-url  "http://localhost:8083/connectors"
(defn get-connector-url [client]
  (str (get client :connector-url) "/connectors"))

;;;;;;;;;;;;;;;;;;;;;;;;;;Connector

(defmethod c/invoke "conn-create-connector"
  [ {:keys [request]}]
  (let [w (json/generate-string request {:pretty true})]
    (println w)
    (http/post (get-connector-url p/context )
               {:body    w
                :headers {"X-Api-Version" "2"
                          "Content-Type"  "application/json"}
                :accept  :json})))


(defmethod c/invoke "conn-create-connector-batch"
  [ {:keys [request]}]
  (try (doseq [m request]

         (log/info "creating new connector " (:name m))
         (c/invoke  {:op "conn-create-connector" :request m}))
       (catch Exception e
         (do
          ; (println "--" (ex-data e))

           (log/info "connector fails " (-> (ex-data e)
                                            :body
                                            (json/parse-string true)))
          (throw (ex-info  "connector error " (-> (ex-data e)
                                                  :body
                                                  (json/parse-string true)) ))
           )
         )))

(defmethod c/invoke "conn-show-connectors"
  [ {:keys [request]}]
  (->> (http/get (get-connector-url p/context))
       :body
       (json/parse-string)
       (into #{})))

(defmethod c/invoke "conn-describe-connector"
  [{:keys [request]}]
  (-> (http/get (str (get-connector-url p/context) "/" request))
      (:body)
      (json/parse-string true)))


(defmethod c/invoke "conn-show-connectors-status"
  [ {:keys [request]}]
  (-> (http/get (str (get-connector-url p/context) "?expand=status"))
      :body
      (json/parse-string true)
      vals
      (->> (mapv vals))
      (flatten)))


(defmethod c/invoke "conn-delete-connector"
  [ {:keys [request]}]
  (http/delete (str (get-connector-url p/context) "/" request)))



(defmethod c/invoke "conn-pause-connector"
  [{:keys [request]}]
  (-> (http/put (str (get-connector-url p/context) "/" request "/pause"))
      (:body)))

(defmethod c/invoke "conn-resume-connector"
  [{:keys [request]}]
  (-> (http/put (str (get-connector-url p/context) "/" request "/resume"))
      (:body)))



(defmethod c/invoke "conn-delete-all-connector"
  [{:keys [request]}]
  (let [coll (c/invoke  {:op "conn-show-connectors-status"})]
    (doseq [c (into [] coll)]
      (http/delete (str (get-connector-url p/context) "/" (get c :name))))))


(defmethod c/invoke "conn-pause-all-source-connector"
  [{:keys [request]}]
  (let [connector-list (c/invoke  {:op "conn-show-connectors-status"})
        source-connector-list (filter #(= (get % :type) "source") connector-list)]
    (doseq [c source-connector-list]
      (try
        (c/invoke  {:op "conn-pause-connector" :request (get c :name)})
        (catch Exception e)))))


(defmethod c/invoke "conn-resume-all-source-connector"
  [ {:keys [request]}]
  (let [connector-list (c/invoke  {:op "conn-show-connectors-status"})
        source-connector-list (filter #(= (get % :type) "source") connector-list)]
    (doseq [c source-connector-list]
      (c/invoke  {:op "conn-resume-connector" :request (get c :name)}))))


(defmethod c/invoke "conn-pause-all-sink-connector"
  [ {:keys [request]}]
  (let [connector-list (c/invoke  {:op "conn-show-connectors-status"})
        source-connector-list (filter #(= (get % :type) "sink") connector-list)]
    (doseq [c source-connector-list]
      (try
        (c/invoke  {:op "conn-pause-connector" :request (get c :name)})
        (catch Exception e)))))


(defmethod c/invoke "conn-resume-all-sink-connector"
  [ {:keys [request]}]
  (let [connector-list (c/invoke  {:op "conn-show-connectors-status"})
        source-connector-list (filter #(= (get % :type) "sink") connector-list)]
    (doseq [c source-connector-list]
      (c/invoke  {:op "conn-resume-connector" :request (get c :name)}))))