(ns ksql.gen.reader.mapping-reader
  (:require [ksql.gen.file-util :as u]
            [ksql.gen.util :as gu]
            [ksql.gen.protocol :as p]
            [clojure.tools.reader.edn :as edn]
            [ksql.gen.core-error-msg :as emsg]
            [clojure.tools.logging :as log]))



(defn read-csv-mapping-file [file-name]
  (->> (u/read-csv-file file-name)
       (partition-by (fn [v]
                       (clojure.string/blank? (:name v))))
       ;(remove (fn ) )
       (remove (fn [v]
                 (every? clojure.string/blank? (mapv :name v))
                 #_(= 1 (count v))))))


(defn split-on-space [word]
  (clojure.string/split word #"\s"))


(defn remove-space [s-token]
  (if (string? s-token)
    (->> s-token
         split-on-space
         (filter #(not (clojure.string/blank? %)))
         (clojure.string/join " "))
    s-token))




(defn convert-quote-to-string [v]
  ;(clojure.pprint/pprint v)
  (let [v1 (seq v)]
    ; (println "--" v1)
    (loop [[f1 & r] v1
           toggle true
           out []]
      ; (println "--" out)
      (if (nil? f1)
        (apply str out)
        (if (= f1 \')
          (if toggle
            (recur r (not toggle) (conj out "\"'"))
            (recur r (not toggle) (conj out "'\"")))
          (recur r toggle (conj out f1))))))

  )


(defn read-transformation-string [w]
  (try
    (if (and (string? w)
             (clojure.string/starts-with? w "("))
      (-> w
          (convert-quote-to-string)
          (edn/read-string))
      w)
    (catch Exception e
      (do
        ;  (log/error e)
        ;   (p/log-v w)
        ; (println "---" w)
        (throw (emsg/ex-info-for-invalid-mapping w (.getMessage e) ) )))))



(comment


  (u/read-csv-file "app/azben/mapping/2test.csv")


  (read-csv-mapping-file "app/azben/mapping/2test.csv")




  (read-csv-mapping-file "app/azben/mapping/2test.csv")

  )



(defn as-transformation-fn [w]



  (cond (nil? w)

        ["null" ""]

        (sequential? w)
        (->> w
             (clojure.walk/postwalk (fn [v1]
                                      (cond (sequential? v1)
                                            (into [] v1)
                                            (gu/is-digit? v1) v1
                                            (string? v1) v1
                                            (symbol? v1) (str v1)
                                            :else
                                            v1
                                            ;(str v1)
                                            ))))

        (clojure.string/blank? w)
        ["null" w]

        (and (string? w)
             (clojure.string/starts-with? w "\""))
        (p/new-quote-string w)
        ;(list "constant" (p/new-quote-string v))
        ;(list "constant" v)

        (not (clojure.string/includes? w "/"))
        (p/new-constant w)

        :else
        ["as" w]))






(comment

  (as-transformation-fn "(from_edn_data {:f_name \"adsf\", :l_name \"asdf\", :address {:road_no 334}}  )")

  )

(defn tranformation-make-lower-case [v]
  (clojure.walk/postwalk (fn [w1]
                           (if (and
                                 (string? w1)
                                 (not (clojure.string/starts-with? w1 "'"))
                                 (clojure.string/includes? w1 "/"))
                             (clojure.string/lower-case w1)
                             w1)) v))





(defn is-transformation? [v]
  (if (or
        (sequential? v)
        (and (string? v)
             (clojure.string/starts-with? (clojure.string/trim v) "(")
             (clojure.string/ends-with? (clojure.string/trim v) ")")

             )
        )
    true false

    ))




(defn process-mapping-step-impl [step-m]
  ;(println "--" step-m)
  (let [tf (when-let [t (get step-m :transfer_fn)]
             (-> (remove-space t)
                 (read-transformation-string)
                 (as-transformation-fn)
                 (tranformation-make-lower-case)))

        [n t topic_name partition :as a] (if (string? (get step-m :name))
                                           (clojure.string/split (get step-m :name) #" ")
                                           (get step-m :name))


        [field-name & field-type] (when-let [field-name (get step-m :field_name)]
                                    (into [] (remove clojure.string/blank?) (clojure.string/split field-name #" ")))
        field-name (when field-name (clojure.string/lower-case field-name))

        out-m (-> {}
                  (assoc :name (clojure.string/lower-case n))
                  (cond-> t (assoc :stream-type t)
                          field-name (assoc :field_name field-name :field_type nil)
                          field-type (assoc :field_type (into [] field-type))
                          tf (assoc :transfer_fn tf)
                          topic_name (assoc :topic topic_name)
                          partition (assoc :partition partition)))

        v (when
            (and (= 2 (count field-type))
                 (= "key" (second field-type)))
            {:name       (get out-m :name)
             :transfer_fn ["key" field-name]})]
    (if v
      [out-m v]
      [out-m]
      )
    )
  )



(defn as-map [mapping]
  (if (map? mapping)
    mapping
    (condp = (count mapping)
      2
      (let [[f-tocken s-token] mapping]
        (if (is-transformation? s-token)
          {:name f-tocken :transfer_fn s-token}
          {:name f-tocken :field_name s-token}))
      (zipmap [:name :field_name :transfer_fn :field_type] mapping)))
  )


(defn do-process [mapping-coll]
  ;(clojure.pprint/pprint mapping-coll)
  (let [out (into [] (comp (map as-map) (map process-mapping-step-impl) cat) mapping-coll)
        w (mapv #(select-keys % [:stream-type :topic :partition]) out)

        ;        _ (println "--" w)
        w (reduce (fn [acc v]
                    (merge acc v)
                    ) {} (reverse w))  #_(apply merge-with merge (reverse w))
        ;       _ (println "--out " out)
        [f & r] out
        f (merge f w)

        r (into [] (map (fn [m]
                          (dissoc m :stream-type :topic :partition)
                          )) r)
        ]
    (into [f] r)
    )
  )



(defmethod p/read-req :default
  [_ mapping-coll-coll]
  (->> mapping-coll-coll
       (mapv do-process)
       ;(p/log-v)
       ))


(defmethod p/read-req :csv
  [_ v]
  (->> (read-csv-mapping-file v)
       (mapv do-process)))


(defn as-triple-vector [w]
  (loop [w w
         result []]
    (if (or (nil? w) (empty? w))
      result
      (let [first-entity-name (ffirst w)
            mapping-coll (into [] (take-while (fn [v] (= (first v) first-entity-name)) w))
            new-w (into [] (drop-while (fn [v]
                                         (= (first v) first-entity-name)) w))]
        (recur new-w (conj result mapping-coll))))))


#_(defn convert-to-mapping [w]
    (loop [w w
           result []]
      (if (or (nil? w) (empty? w))
        result
        (let [first-entity-name (ffirst w)
              mapping-coll (into [] (take-while (fn [v] (= (first v) first-entity-name)) w))
              new-w (into [] (drop-while (fn [v]
                                           (= (first v) first-entity-name)) w))]
          (recur new-w (conj result mapping-coll))))))


(defn convert-triple-from-comma [mapping]
  (let [mapping (into [] (map (fn [v]
                                (when (string? v)
                                  (clojure.string/trim v))
                                )) mapping)]
    (loop [mapping mapping
           result []]
      (if (or (nil? mapping)
              (empty? mapping))
        (as-triple-vector result)
        (let [mapping-coll (into [] (take-while (fn [v]
                                                  (not= v ";")) mapping))
              rest-mapping (doall (rest (drop-while (fn [v]
                                                      (not= v ";")) mapping)))]
          (recur rest-mapping (conj result mapping-coll)))))))



(defmethod p/read-req :comma-separator
  [_ v]
  (if (string? v)
    (->> (str "[" (slurp v) "]")
         (edn/read-string)
         ;(p/log-v )
         (convert-triple-from-comma)
         (mapv do-process)
         ;(p/log-v )
         #_(p/read-req :default))

    (->> (convert-triple-from-comma v)
         (mapv do-process)
         #_(p/read-req :default))))


(defn as-triple-vector2 [w]
  ;(clojure.pprint/pprint w)
  (loop [w w
         result []]
    (if (or (nil? w) (empty? w))
      result
      (let [first-entity-name (first (ffirst w))
            ;_ (println "" first-entity-name)
            mapping-coll (into [] (take-while (fn [v] (= (ffirst v) first-entity-name)) w))
            new-w (into [] (drop-while (fn [v]
                                         (= (ffirst v) first-entity-name)) w))]
        (recur new-w (conj result mapping-coll))))))



(defn convert-triple-from-vector [mapping]

  (->> mapping
       (into [] (map (fn [v]
                       (cond
                         (string? v)
                         (clojure.string/trim v)
                         (symbol? v)
                         (str v)
                         :else
                         v))))
       (partition-all 3)
       ;(p/log-v)
       (into [] (comp (map (fn [coll]
                             (into [] (comp
                                        #_(map (fn [v]

                                               ;(printl)
                                               (if (symbol? v) (str v) v)
                                               ))
                                        (remove (fn [v]
                                                  (if (string? v)
                                                    (clojure.string/blank? v)
                                                    false
                                                    )
                                                  ))) coll)))
                      (map (fn [coll]
                             (-> coll
                                 (update 0 clojure.string/split #" "))))))
       ;(p/log-v)
       (as-triple-vector2)
       ;(p/log-v)
       ))


(defn as-compiler-schema [v]
  ;(println "----------------")
  (->> v
       (into [] (map (fn [v]
                       (if (string? v)
                         (clojure.string/trim v)
                         v))))
       (partition-by (fn [v] (= ";" v)))
       (remove (fn [v] (= (list ";") v)))
       (map (fn [v] (condp = (count v)
                      1 (into (vector "_" "_") v)
                      2 (into (vector "_") v)
                      v
                      )))
       ;(p/log-v)
       (into [] (comp (map (fn [v]

                             (convert-triple-from-vector v)
                             ))
                      cat
                      ))

       ;(convert-triple-from-vector )
       (mapv do-process)))


(defn is-file [file-name]
  (clojure.string/ends-with? file-name ".edn"))

(defn read-request [v]

  (cond
    (and (string? v)
         (is-file v))
    (->> (str "[ " (slurp v) " ]")
         (edn/read-string))
    (string? v)
    (->> (str "[ "  v " ]")
         (edn/read-string))
    :else
    v)

  )


(defmethod p/read-req :triple
  [_ v]
  ;(println "---" v)

  (try

    (-> v
        (read-request)
        (as-compiler-schema)
        )

    #_(cond

      (and (string? v)
           (is-file v))
      (->> (str "[ " (slurp v) " ]")
           (edn/read-string)
           (as-compiler-schema))

      (string? v)
      (->> (str "[ "  v " ]")
           (edn/read-string)
           (as-compiler-schema))

      :else
      (as-compiler-schema v))

    (catch clojure.lang.ExceptionInfo e
      (throw e))
    (catch Exception e
      ; (println (.getMessage e))

      (throw (emsg/ex-info-for-invalid-mapping v (.getMessage e))))))




(comment

  (->> "test/example/demo2/party_mapping.edn"
       (p/read-req :triple )
      )

  (slurp "test/example/demo2/party_mapping.edn")


  (let [w ["email1 type" "" "(type_of string \"email\"  (< 2 (len \"#value\" )  ) )"

           "type_of_party_raw" "id" ""
           "type_of_party_raw" "f_name" ""
           "type_of_party_raw" "l_name" ""
           "type_of_party_raw" "email" ""
           "type_of_party_raw" "age " ""
           "type_of_party_raw" "" "(value_format 'json')"

           "type_of_party_refined" "" "(select type_of_party_raw/*)"
           "type_of_party_refined" "email email1" "type_of_party_raw/email"
           "type_of_party_refined" "age int" "type_of_party_raw/age"
           "type_of_party_refined" "" "(dq_check 'contain?' \"1,2,3\" type_of_party_raw/id)"
           "type_of_party_refined" "" "(dq_check (!=null type_of_party_raw/l_name  type_of_party_raw/f_name) )"
           "type_of_party_refined" "" "(dq_check (< 4 (len type_of_party_raw/l_name) ) )"
           ]]

    (->>
      ;(apply str  w)
      (slurp "test/example/demo2/party_mapping.edn")

      ;   (edn/read-string)
         (p/read-req :triple )
         ;  (invoke-dataflow "df-create-dataflow")
         ;(invoke-dataflow "df-update-dataflow")
         )
    )





  (re-matches #"([a-zA-Z]:)?(\\\\[a-zA-Z0-9_.-]+)+\\\\?" "hello.edn")



  ;  (clojure.string/)

  )


#_(defn read-req [v]
    (if (string? v)
      (->> (read-csv-mapping-file v)
           (mapv (fn [w]
                   (into [] processing-xf w))))
      (->> v
           (mapv (fn [v1]
                   (->> (as-request-mapping v1)
                        (into [] processing-xf)))))))




(comment


  ;(clojure.string/blank? "")

  (partition-all 3 [1 2 3 4 5 6 7 8 9 10 34 56])

  (p/read-req :comma-separator-file "test/change-detect-mapping.edn")

  (p/read-req :triple ["cust_raw" "id integer" ""
                       "cust_raw" "name" ""
                       "cust_raw_enrich" "id" "cust_raw/id"]
              )

  (convert-triple-from-vector ["cust_raw" "id integer" ""
                               "cust_raw" "name" ""
                               "cust_raw_enrich" "id" "cust_raw/id"])

  (convert-triple-from-comma ["cust_raw" "id integer" "; "
                              "cust_raw" "name" ";"
                              "cust_raw_enrich" "(change_key cust_raw)" ";"]
                             )


  (convert-triple-from-comma [["test" "a"]])

  #_(->> [[["raw_bnl_claim2"
            "LOCAL_CLAIM_ID"
            "(replace raw_bnl_claim/LOCAL_CLAIM_ID ',' '')"]
           ["raw_bnl_claim2"
            "EFFECTIVE_LOSS_DATE"
            "(replace raw_bnl_claim/EFFECTIVE_LOSS_DATE '/' '-')"]]]
         (read-req)

         )

  (let [w [["cust_stage" "id integer"]
           ["cust_stage" "name"]
           ["cust_stage" "(key id)"]

           ["cust_raw_enrich" "id" "cust_raw/id"]
           ["cust_raw_enrich" "old_id" "cust_stage_tab/id"]
           ["cust_raw_enrich" "name" "cust_raw/name"]
           ["cust_raw_enrich" "(left_join cust_raw/id cust_stage_tab/id )"]

           ["cust_stage" "id" "cust_raw_enrich/id"]
           ["cust_stage" "name" "cust_raw_enrich/name"]]]

    ;(drop-while (fn [v] (= (first v) "cust_stage") ) w )
    (loop [w w
           result []]
      (if (or (nil? w) (empty? w))
        result
        (let [first-entity-name (ffirst w)
              mapping-coll (into [] (take-while (fn [v] (= (first v) first-entity-name)) w))
              new-w (into [] (drop-while (fn [v]
                                           (= (first v) first-entity-name)) w))
              ]
          ;_ (println new-w)
          (recur new-w (conj result mapping-coll))

          )

        )

      ))


  (ffirst [[1 2 3] [4 5]])

  )





(defn update-key-set [mapping-coll]
  (let [xf (comp
             (filter (fn [m]
                       (if (and (nil? (get m :field_type))
                                (not= nil (get m :transfer_fn)) ;
                                (contains? #{"key"} (get-in m [:transfer_fn 0])))
                         true false)))
             (map :transfer_fn)
             (filter (fn [v]
                       (= "key" (first v))))
             (map (fn [[t v]] {v t})))
        k-m (into {} xf mapping-coll)

        ]
    (into [] (comp (remove (fn [m]
                             (if (and (nil? (get m :field_type))
                                      (contains? #{"key"} (get-in m [:transfer_fn 0])))
                               true false
                               )
                             ))
                   (map (fn [m]
                          (if (get k-m (get m :field_name))
                            (let [t (if (sequential? (get m :field_type))
                                      (first (get m :field_type))
                                      (or (get m :field_type) "string")
                                      )]
                              (assoc m :field_type [t "key"])
                              )

                            m
                            )

                          ))
                   )

          mapping-coll)
    ))


(defn update-type [mapping-coll]
  (let [xf (comp
             (filter (fn [m]
                       (if (and (nil? (get m :field_type))
                                (not= nil (get m :transfer_fn)) ;
                                (contains? #{"type"} (get-in m [:transfer_fn 0])))
                         true false)))
             (map :transfer_fn)
             (filter (fn [v]
                       (= "type" (first v)))))
        k-m (into {} xf mapping-coll)
        ;_ (println "--" k-m )
        mapping-coll (into [] (comp (remove (fn [m]
                                              (if (and (nil? (get m :field_type))
                                                       (contains? #{"type"} (get-in m [:transfer_fn 0])))
                                                true false
                                                )
                                              ))

                                    )

                           mapping-coll)

        mapping-coll (if (empty? k-m)
                       mapping-coll
                       (update-in mapping-coll [0] (fn [m]
                                                     (assoc m :stream-type (get k-m "type"))
                                                     ))
                       )

        ]
    ;(println "--" k-m )

    mapping-coll
    )

  )
