(ns ksql.gen.reader.file-reader
  (:require [ksql.gen.file-util :as u]
            [ksql.gen.reader.xmltojson :as xmltojson]
            [clojure.xml :as xml]
            [clojure.java.io :as io]
            [clojure.walk :as w :refer [postwalk]]
            [cheshire.core :as json]))


(defn load-template [template-path]
  (-> template-path
      (slurp)
      (json/parse-string true)))

(defn get-separator [file-name]
  (with-open [rdr (clojure.java.io/reader file-name)]
    (let [w (first (line-seq rdr))]
      (if (< (count (clojure.string/split w #"\;"))
             (count (clojure.string/split w #"\,")))
        \, \;))))


(comment


  (with-open [rdr (clojure.java.io/reader "app/azben/data/source/bnl_claim.csv")]
    (let [w (first (line-seq rdr))

          comma (if (< (count (clojure.string/split w #"\;"))
                       (count (clojure.string/split w #"\,")))
                  "," ";"
                  )

          ]
      (println "--" (count (clojure.string/split w #"\;")))
      (println "--" (count (clojure.string/split w #"\,")))
      comma

      )
    )


  ;(first (map #(clojure.string/split-lines ) (slurp "app/azben/data/source/bnl_claim.csv")) )

  )


(defn get-all-files [csv-folder-name t]
  (let [grammar-matcher (.getPathMatcher
                          (java.nio.file.FileSystems/getDefault)
                          t)]
    (->> csv-folder-name
         clojure.java.io/file
         file-seq
         (filter #(.isFile %))
         (filter #(.matches grammar-matcher (.getFileName (.toPath %)))))))


(defn get-all-file-name [folder-name type]
  (let [csv-file-list (get-all-files folder-name type)
        csv-file-path (into []
                            (comp
                              (remove (fn [v]
                                        (-> (.getAbsolutePath v)
                                            (clojure.string/includes? "/."))))
                              (map (fn [v]
                                     (let [file-path (.getAbsolutePath v)
                                           file-name (-> v
                                                         (.getName)
                                                         (clojure.string/split #"\.")
                                                         first)]
                                       [file-name file-path]))))
                            csv-file-list)
        w (into (sorted-set-by #(compare (first %1) (first %2))) csv-file-path)
        w (vec w)
        ]
    ;csv-file-path
    w
    ))




(defn read-csv-header
  ([csv-file-path] (read-csv-header csv-file-path (get-separator csv-file-path)))
  ([csv-file-path separator]
   (let [
         ;csv-file-path (str data-dir "/" entity-name ".csv")
         ; separator (get-in config [:config :csv.separator.char])
         ;separator (or separator \;) #_(if (= separator 59) \; \,)
         ]
     (->> csv-file-path
          (u/get-csv-header separator)
          (into [])))))

(defn format-csv-header [header]
  (mapv (fn [v]
          (-> v
              (clojure.string/trim)
              (.replaceAll " " "_")
              (.toLowerCase)
              (clojure.string/replace-first #"\"" "")
              (.replaceFirst (str "(?s)(.*)" "\"") (str "$1" "")))
          ) header))


(defn read-header [csv-file-path]
  (let [separator (get-separator csv-file-path) ]
    (->> csv-file-path
         (u/get-csv-header separator)
         (into #{}))))


(defn get-file-name [file-name]
  (-> (clojure.java.io/as-file file-name)
      (.getName)
      (clojure.string/split #"\.")
      (first)))





#_(defn unlazy
    [coll]
    (let [unlazy-item (fn [item]
                        (cond
                          (sequential? item) (vec item)
                          (map? item) (into {} item)
                          :else item))
          result (postwalk unlazy-item coll)]
      result))

(defn lowercase-keys
  "Recursively transforms all map keys from keywords to strings."
  {:added "1.1"}
  [m]
  (let [f (fn [[k v]] (if (keyword? k) [(keyword (clojure.string/lower-case (name k))) v] [k v]))]
    ;; only apply to maps
    (postwalk (fn [x] (if (map? x) (into {} (map f x)) x)) m)))


;"ISO-8859-1"
(defn convert-xml-to-edn [xml-str]
  (-> xml-str
      (clojure.string/replace "'" "")
      (.getBytes)
      (java.io.ByteArrayInputStream.)
      xml/parse
      (xmltojson/parse)
      (lowercase-keys)
      (xmltojson/format-map)
      ; (clojure.walk/stringify-keys)
      ; (p/log-v)
      )

  )

(comment


  (w/keywordize-keys)

  (-> (slurp "test/example/azuk/reqah1.xml")
      (convert-xml-to-edn)
      )

  (-> (slurp "test/resources/data/books.xml")
      (convert-xml-to-edn)
      ;(lowercase-keys)
      ;(pr-str)
      ;(pr-str)
      ;(clojure.tools.reader.edn/read-string)
      )
  )



(defn convert-xml-file-to-edn
  ([xml-file-path] (convert-xml-file-to-edn xml-file-path false))
  ([xml-file-path format-map?]
   ;(println "--xml file path " xml-file-path)
   (let [v (if (string? xml-file-path)
             (io/file xml-file-path)
             xml-file-path
             )]
     (if format-map?
       (->> v
            xml/parse
            (xmltojson/parse)
            (xmltojson/format-map))
       (->> v
            xml/parse
            (xmltojson/parse)
            #_(xmltojson/format-map))

       )
     ))


  )



(defn get-file-name [file-path]
  ;(println "---file path " file-path)
  (-> file-path
      (clojure.string/split #"/")
      (last)
      (clojure.string/split #"\.")
      (first))
  )


(comment


  (convert-xml-file-to-edn "/home/mamun/development/workspace/clj/ksql-gen/test/resources/data/books.xml")

  (clojure.string/split "")

  (->> [["app/allianz_life/config/csv_source.json" "app/allianz_life/data/Product.csv" "product_code" "product"]]
       (gen-schema-from-entity)
       )



  #_(gen-schema-from-entity "app/allianz_life/config/csv_source.json"
                            [["product" "product_code" "Product"]]
                            "app/allianz_life/data")



  ;"app/allianz_life/config/csv_source.json"

  )