(ns ksql.gen.macro.rekey-generator
  (:require [ksql.gen.protocol :as p]
            [clojure.tools.reader.edn :as edn]
            [ksql.gen.core_schema :as sch]
            ))



(def edn-readers {'ksql.gen.protocol.ConstantValue    p/map->ConstantValue
                  'ksql.gen.protocol.QuoteStringValue p/map->QuoteStringValue})





(defn update-mapping [mapping old-key new-key]
  ; (println "--" old-key "--new key " new-key)
  (let [new-key (str (clojure.string/lower-case new-key) "/")
        old-key (str (clojure.string/lower-case old-key) "/")]
    (edn/read-string {:readers edn-readers}
                     (-> (pr-str mapping)
                         ; (p/log-v)
                         (clojure.string/replace old-key new-key)

                         ))
    )

  )

(defn rekey-impl [md-repo mapping]
  ;  (clojure.pprint/pprint mapping)
  (let [join-list (into [] (comp (map :transfer_fn)
                                 (filter (fn [v] (contains? #{"outer_join" "join" "left_join"} (first v))))
                                 ) mapping)]

    (if (empty? join-list)
      [mapping]

      (let [df (fn [j]
                 (let [[j-entity-name j-entity-col-name :as w] (mapv clojure.string/lower-case (clojure.string/split (nth j 2) #"/"))
                       new-source-entity (sch/get-source-schema md-repo j-entity-name)
                       new-source-entity-name (clojure.string/lower-case (str j-entity-name "_BY_" j-entity-col-name))
                       ]
                   (when (not= (sch/get-key new-source-entity) #_(get new-source-entity :key)
                               j-entity-col-name)
                     (let [fields (get new-source-entity :fields)
                           fields (into [] (map (fn [f]
                                                  {:name        new-source-entity-name
                                                   :field_name  (get f :name)
                                                   :transfer_fn (list "as" (str j-entity-name "/" (get f :name))),
                                                   :field_type  (vector (get-in f [:schema :type]))
                                                   }
                                                  )) fields)
                           fields (into fields [{:name        new-source-entity-name
                                                 :transfer_fn (list "key" j-entity-col-name)}

                                                {:name        new-source-entity-name
                                                 :transfer_fn (list "rekey" true)}
                                                ;:rekey true
                                                ])]
                       {:mapping    fields
                        :old_source j-entity-name
                        :new_source new-source-entity-name}))))
            out (into [] (comp (map df)
                               (remove nil?)) join-list)

            ;     _ (clojure.pprint/pprint out)
            mapping-schema (reduce (fn [acc m]
                                     (update-mapping acc (get m :old_source) (get m :new_source))
                                     ) mapping out)

            all-schema (into #{} (sch/get-all-names md-repo))
            rekey-mapping (into [] (comp (map :mapping)
                                         (remove (fn [m]
                                                   (contains? all-schema (get (first m) :name))
                                                   ))) out)

            mapping (conj rekey-mapping mapping-schema)

            ]
        ; (println "--" out)
        ; (p/log-v out)
        ;[mapping]
        mapping
        )

      )

    )

  )