(ns ksql.gen.macro.map-data-vault-impl
  (:require [ksql.gen.protocol :as p]
            [ksql.gen.core_schema :as cs]
            [ksql.gen.core-error-msg :as emsg]
            [ksql.gen.util :as u]
            [ingestion.api.client.ns-repo-impl :as c]
            ))





(defn create-sat-field-map2 [refined-schema sat-entity-name [b-key b-key-refined]]
  (let [;[bk-key] (get refined-schema :assoc_dv_attr1)
        refined-name (get refined-schema :name)

        {:keys [gdp_src_sys_id gdp_oe_id gdp_pipeline_id]
         :or   {gdp_src_sys_id 1 gdp_oe_id 10 gdp_pipeline_id 100}
         } (get p/context :dv-attr {})

        fields (into [] (comp                               ;(map :name)
                          (map (fn [f]
                                 (if (= "string"
                                        (get-in f [:schema :type])
                                        )
                                   (str refined-name "/" (:name f))

                                   (str "(cast " (str refined-name "/" (:name f)) " string)")

                                   )

                                 )))
                     (get refined-schema :fields))
        field-str (interpose "'~'" fields)
        gdp_hashdiff (str "( hash (concat " (clojure.string/join " " field-str) " ) )")

        w [sat-entity-name "gdp_uiss" (str "(concat " refined-name "/" b-key-refined " '~' '" gdp_oe_id "' '~' '" gdp_src_sys_id "'" ")")
           sat-entity-name "hk" "(hash this/gdp_uiss)"
           sat-entity-name "gdp_hashdiff string key" gdp_hashdiff]

        out (into [] (comp (map (fn [v1]
                                  [sat-entity-name (get v1 :name) (str refined-name "/" (get v1 :name))]
                                  ))
                           cat
                           ) (get refined-schema :fields))]
    (into out w)))




(defn create-hub-field-map2 [refined-schema sat-entity-name [b-key-new b-key-refined]]
  (let [;[bk-key] (get refined-schema :assoc_dv_attr1)
        refined-name (get refined-schema :name)

        {:keys [gdp_src_sys_id gdp_oe_id gdp_pipeline_id]
         :or   {gdp_src_sys_id 1 gdp_oe_id 10 gdp_pipeline_id 100}
         } (get p/context :dv-attr {})]
    [sat-entity-name "gdp_src_sys_id" (str "(cast '" gdp_src_sys_id "' integer)")
     sat-entity-name "gdp_oe_id" (str "(cast '" gdp_oe_id "' integer)")
     sat-entity-name "gdp_pipeline_id" (str "(cast '" gdp_pipeline_id "' integer)")
     sat-entity-name "gdp_load_ts" (str "(timestamptostring " refined-name "/rowtime 'yyyy-MM-dd HH:mm:ss.SSSSSS')")
     sat-entity-name "gdp_uiss" (str "(concat " refined-name "/" b-key-refined " '~' '" gdp_oe_id "' '~' '" gdp_src_sys_id "'" ")")
     sat-entity-name "hk string key" "(hash this/gdp_uiss)"
     sat-entity-name b-key-new (str refined-name "/" b-key-refined)
     ]

    ))


(defn create-link-field-map2 [refined-schema link-entity-name [l-key-new1 l-key1-refined l-key-new2 l-key2-refined]]
  (let [refined-name (get refined-schema :name)

        {:keys [gdp_src_sys_id gdp_oe_id gdp_pipeline_id]
         :or   {gdp_src_sys_id 1 gdp_oe_id 10 gdp_pipeline_id 100}
         } (get p/context :dv-attr {})]


    [link-entity-name "gdp_src_sys_id" (str "(cast '" gdp_src_sys_id "' integer)")
     link-entity-name "gdp_oe_id" (str "(cast '" gdp_oe_id "' integer)")
     link-entity-name "gdp_pipeline_id" (str "(cast '" gdp_pipeline_id "' integer)")
     link-entity-name "gdp_load_ts" (str "(timestamptostring " refined-name "/rowtime 'yyyy-MM-dd HH:mm:ss.SSSSSS')")
     link-entity-name "gdp_uiss" (str "(concat "
                                      refined-name "/" l-key1-refined " '~' '" gdp_oe_id "' '~' '" gdp_src_sys_id "'"
                                      refined-name "/" l-key2-refined " '~' '" gdp_oe_id "' '~' '" gdp_src_sys_id "'"

                                      ")"
                                      )
     link-entity-name (str l-key-new1 "_hk") (str "(hash (concat " refined-name "/" l-key1-refined " '~' '" gdp_oe_id "' '~' '" gdp_src_sys_id "' ) ) ")
     link-entity-name (str l-key-new2 "_hk") (str "(hash (concat " refined-name "/" l-key2-refined " '~' '" gdp_oe_id "' '~' '" gdp_src_sys_id "' ) ) ")
     link-entity-name "lhk string key" "(hash this/gdp_uiss)"

     ]

    ))



(defn impl-dv-mapping [md-repo  refined-entity-name postfix]

  (let [s-name-postfix (or postfix "")
        entity-name (clojure.string/replace refined-entity-name s-name-postfix "")

        sat-entity-name (str entity-name "_sat")
        hub-entity-name (str entity-name "_hub")
        link-entity-name (str entity-name "_link")

        ;  rename-key-m {(str hk-prefix entity-name) "hk"}


        refined-schema (cs/get-source-schema md-repo refined-entity-name)
        assoc_dv_attr1 (get refined-schema :assoc_dv_attr)
        ;_ (println "--" assoc_dv_attr1)


        v (cond
            (= 2 (count assoc_dv_attr1))
            (-> (create-sat-field-map2 refined-schema sat-entity-name assoc_dv_attr1)
                (into (create-hub-field-map2 refined-schema hub-entity-name assoc_dv_attr1)))
            (= 4 (count assoc_dv_attr1))
            (create-link-field-map2 refined-schema link-entity-name assoc_dv_attr1)

            (= 6 (count assoc_dv_attr1))
            (-> (create-sat-field-map2 refined-schema sat-entity-name (first (split-at 2 assoc_dv_attr1)))
                (into (create-link-field-map2 refined-schema link-entity-name (second (split-at 2 assoc_dv_attr1)))))

            :else
            (throw  (emsg/ex-info-for-invalid-dv-attr assoc_dv_attr1 refined-entity-name)


                     )
            )

        ]

    [v]
    ;    (p/log-v (partition 3 link-field-map) )
    ;  [link-field-map]

    )
  )


(defmethod p/expand-flow "map_dv"
  [md-repo mapping]
  (let [[refined-entity-name postfix] (cs/get-object-from-mapping mapping)]
    (impl-dv-mapping md-repo refined-entity-name postfix)))