(ns ksql.gen.macro.expand-step-impl
  (:require [ksql.gen.protocol :as p]
            [ksql.gen.core-error-msg :as emsg]
            [ksql.gen.reader.mapping-reader :as mr]
            [ksql.gen.core_schema :as sg]
            [ksql.gen.util :as u]))



#_(defmethod p/expand-step "add_default"
    [schema-coll selected-fields mapping-fields]
    (let []

      )

    )


(defn as-json-fields [source-name fields]
  (let [w (into [] (map (fn [f]
                          (str "'" f ":'" " (ifnull " source-name "/" f " 'null'" ")")
                          )) fields)
        out (clojure.string/join " ',' " w)]
    (str "(concat '{' " out "  '}'  )")))




(comment

  (as-json-fields "test" ["asd" "sdf"])

  )

(defmethod p/expand-step "as_json_value"
  [md-repo selected-fields w]
  (let [[n f [t source-name]] w
        schema (sg/get-source-schema md-repo source-name)
        field-str (as-json-fields source-name (mapv :name (get schema :fields)))
        ]

    [n f field-str]

    ))


(defn apply-for-many-field [selected-fields field-name step-mapping]

  (let [[na f [n f-name ex-value source-name]] step-mapping
        t (clojure.string/replace field-name "*" "")
        w (comp
            (remove (fn [f] (nil? (:field_name f))))
            (map :transfer_fn)
            (map second)
            (filter string?)
            (map (fn [v]
                   (let [[e-name field-name] (clojure.string/split v #"/")]
                     (when (and field-name
                                (clojure.string/ends-with? field-name t))
                       [na "" (str "( " n " " f-name " \"" ex-value "\" " v " ) ")]
                       ))))
            (remove nil?)
            cat)]
    (into [] w selected-fields))

  )

(defmethod p/expand-step "dq_check"
  [md-repo selected-fields step-mapping]

  ;(clojure.pprint/pprint step-mapping)
  (let [[na f [n f-name & rr]] step-mapping
        [e-name field-name] (when (second rr) (clojure.string/split (second rr) #"/"))]
    (cond (and field-name
               (clojure.string/starts-with? field-name "*"))

          (-> (apply-for-many-field selected-fields field-name step-mapping)
              )

          (vector? f-name)
          (do
            (if (= "!=null" (first f-name))
              (into [] (comp (map (fn [v]
                                    [na f ["validation!" [(first f-name) v]]]))
                             cat
                             ) (rest f-name))
              [na f (into ["validation!" f-name] rr)]))
          :else
          step-mapping)))



(defmulti expand-step-internal (fn [_ _ mapping-fields] (first (get mapping-fields :transfer_fn))))

(defmethod expand-step-internal :default
  [_ _ m]
  (vector m))





(defmethod expand-step-internal "lookup"
  [_ _ mapping-field]
  (let [[t lookup-key w] (into [] (get mapping-field :transfer_fn))
        [_ source-key rel-key] (into [] w)]
    (vector
      (assoc mapping-field :transfer_fn (vector "as" lookup-key))
      (assoc mapping-field :transfer_fn (vector "left_join" source-key rel-key) :field_name nil))))


;latest_by_offset

(defmethod expand-step-internal "latest_by_offset"
  [md-repo selectd-fields mapping-field]
  ;(println "--rekey " )
  ;  (clojure.pprint/pprint (:field_type mapping-field))

  (if (:field_type mapping-field)
    [mapping-field]

    (let [sink-name (get mapping-field :name)
          [_ source-name key-name] (get mapping-field :transfer_fn)
          schema (sg/get-source-schema md-repo source-name)
          fields (get schema :fields)
          fields (map (fn [field]
                        (if (= key-name (get field :name))
                          [(-> field
                               (assoc :name sink-name)
                               (assoc :field_name (str "key_0" " " #_(get-in field [:schema :type]))   #_(get field :name))
                               (dissoc :schema)
                               (assoc :transfer_fn ["as" (str source-name "/" (get field :name))])
                               )
                           (-> field
                               (assoc :name sink-name)
                               (assoc :field_name (str (get field :name) " " #_(get-in field [:schema :type])))
                               (dissoc :schema)
                               (assoc :transfer_fn ["as_value" (str source-name "/" (get field :name))])
                               )

                           ]

                          [(-> field
                               (assoc :name sink-name)
                               (assoc :field_name (str (get field :name) " " #_(get-in field [:schema :type])))
                               (dissoc :schema)
                               (assoc :transfer_fn ["latest_by_offset" (str source-name "/" (get field :name))])
                               )]
                          )
                        ) fields #_(range))
          fields (into [] cat fields)


          fields (into fields [{:name        sink-name
                                :transfer_fn ["key" "key_0"]}
                               {:name        sink-name
                                :transfer_fn ["group_by" key-name]}
                               {:name        sink-name
                                :transfer_fn ["type" "table"]}])]
      ;(clojure.pprint/pprint fields)

      fields

      )
    )

  )



(defmethod expand-step-internal "rekey"
  [schema-coll selectd-fields mapping-field]
  ;(println "--rekey " )
  (let [sink-name (get mapping-field :name)
        [_ source-name key-name] (get mapping-field :transfer_fn)
        schema (sg/get-source-schema schema-coll source-name)
        fields (get schema :fields)
        fields (into []
                     (comp

                       (map (fn [field]

                              (-> field
                                  (assoc :name sink-name)
                                  (assoc :field_name (get field :name))
                                  (dissoc :schema)
                                  (assoc :transfer_fn ["as" (str source-name "/" (get field :name))])
                                  )
                              )))
                     fields)
        fields (into fields [{:name        sink-name
                              :transfer_fn ["key" key-name]}
                             #_{:name        sink-name
                                :transfer_fn ["ksql-gen-type" p/gen-ksql-rekey-stream-from-mapping]}])]

    fields

    )

  )




(defmethod expand-step-internal "select"
  [schema-coll selectd-fields mapping-field]
  ;(  selectd-fields)
  (let [field-names (rest (get mapping-field :transfer_fn))
        w (mapv (fn [v]
                  (clojure.string/split v #"/")
                  ) field-names)
        ;_ (println "--" w)
        entity-name (distinct (into [] (comp (map first)
                                             ) w))
        field-names (into #{} (distinct (into [] (comp
                                                   (map second)
                                                   (remove nil?)
                                                   (map clojure.string/upper-case)
                                                   ) w)))
        _ (when (or (< 1 (count entity-name))
                    (nil? (first entity-name))
                    )
            (throw (emsg/ex-info-for-more-source-ref entity-name mapping-field) ))
        ;_ (println "--fields names" field-names)

        source-name (clojure.string/lower-case (first entity-name))
        schema (sg/get-source-schema schema-coll source-name)
        _ (when (nil? schema)
            (let [available-schema (clojure.string/join ",\n " (mapv :name schema-coll))]
              (throw (emsg/ex-info-null-source-ref source-name available-schema mapping-field)  )))
        ;k (get schema :key)


        ;field-names (conj field-names k)

        fields (if (or
                     (empty? field-names)
                     (contains? field-names "*"))
                 (get schema :fields)
                 (into [] (filter (fn [v]
                                    (contains? field-names (clojure.string/upper-case (get v :name)))
                                    )) (get schema :fields)))
        _ (when (and (empty? fields)
                     (not (or
                            (empty? field-names)
                            (contains? field-names "*"))))
            (throw (emsg/ex-info-invalid-fields-name mapping-field field-names ) ))


        previous_field (into #{} (comp (map :field_name)
                                       (remove nil?)
                                       (map clojure.string/lower-case)) selectd-fields)


        fields (into []
                     (comp
                       (remove (fn [field]
                                 (contains? previous_field (clojure.string/lower-case (get field :name)))
                                 ))
                       (map (fn [field]

                              (-> field
                                  (assoc :name (get mapping-field :name))
                                  (assoc :field_name (get field :name))
                                  (dissoc :schema)
                                  (assoc :transfer_fn ["as" (str source-name "/" (get field :name))])))))
                     fields)
        ; _ (  fields)

        ]
    ;(println "---------------------" fields)
    ;[[]]
    fields
    )

  )

(defmethod expand-step-internal "where"
  [schema-coll mapping mapping-field]
  ;(  mapping-field)
  (let [field (into [] (comp (map :field_name)
                             (remove nil?)
                             (remove clojure.string/blank?)
                             ) mapping)]
    ; (println "--total count " (count field))

    (if (< 0 (count field))
      [mapping-field]
      (let [entity-name-list (->> mapping-field
                                  :transfer_fn
                                  (flatten)
                                  (filter (fn [v] (clojure.string/includes? v "/")))
                                  (map (fn [v]
                                         (first (clojure.string/split v #"/"))
                                         ))
                                  (distinct)
                                  )
            _ (when (< 1 (count entity-name-list))
                (throw (emsg/ex-info-for-more-source-ref entity-name-list mapping-field) #_(ex-info "where needs one source schema, found more than one "
                                {:e-name entity-name-list
                                 :e-ref  mapping-field
                                 :e-des  "where needs one source schema, found more than one "
                                 }))
                )
            ;entity-name (first entity-name-list)
            source-name (clojure.string/lower-case (first entity-name-list))
            ; schema (get schema-m source-name)
            schema (sg/get-source-schema schema-coll source-name)
            ; _ (  schema)
            fields (mapv (fn [field]
                           (-> field
                               (assoc :name (get mapping-field :name))
                               (assoc :field_name (get field :name))
                               (dissoc :schema)
                               (assoc :transfer_fn ["as" (str source-name "/" (get field :name))]))
                           ) (get schema :fields))

            fields (conj fields mapping-field)
            ;fields
            #_(conj fields {:name  (get mapping-field :name)
                            ; :transfer_fn ["generator-type" p/gen-ksql-stream-from-stream]
                            :topic (:topic schema)
                            })
            ]
        ;(println "--" source-name)
        fields
        )
      )

    )
  )




(comment



  (flatten ["where" ["=" "tnf_party/gender" "'F'" ["and "]]])

  )

