(ns ksql.gen.macro.expand-flow-impl
  (:require [ksql.gen.protocol :as p]
            [ksql.gen.util :as u]
            [ksql.gen.core_schema :as sg])
  )



(defmulti expand-flow-internal (fn [_ mapping-fields] (first (get (first mapping-fields) :transfer_fn))))


(defmethod expand-flow-internal :default
  [_ mapping]
  ;(println "--" mapping)
  [mapping]
  )




;csv-file-list (get-all-files csv-folder-name "glob:*.{csv}")


(defmethod expand-flow-internal "map_before_v1"
  [md-repo mapping]
  ;(  mapping)
  (let [mapping (first mapping)
        n (get mapping :name)
        ; n (get mapping :name)
        [_ source-name key-name] (get mapping :transfer_fn)
        schema (sg/get-source-schema md-repo source-name)
        fields (get schema :fields)
        stage-name (str source-name "_stage")
        stage-name-tab (str stage-name "_tab")
        ;statge-enrich (str source-name "_stage")

        stage-mapping-fields (into [] (map (fn [field]
                                             (-> field
                                                 (assoc :name stage-name)
                                                 (assoc :field_name (get field :name))
                                                 (dissoc :schema)
                                                 (assoc :transfer_fn ["as" (str source-name "/" (get field :name))])
                                                 )
                                             )) fields)

        stage-mapping-fields (conj stage-mapping-fields {:name        stage-name
                                                         :transfer_fn ["key" key-name]})

        cust_stage_tab-fields (into [] (map (fn [field]
                                              (-> field
                                                  (assoc :name stage-name-tab)
                                                  (assoc :field_name (get field :name))
                                                  (dissoc :schema)
                                                  (assoc :transfer_fn ["as" (str stage-name "/" (get field :name))])
                                                  )
                                              )) fields)

        cust_stage_tab-fields (into cust_stage_tab-fields [{:name        stage-name-tab
                                                            :transfer_fn ["key" key-name]}
                                                           {:name        stage-name-tab
                                                            :transfer_fn ["type" "table"]}])
        enrich-fields (into [] (map (fn [field]
                                      (-> field
                                          (assoc :name n)
                                          (assoc :field_name (get field :name))
                                          (dissoc :schema)
                                          (assoc :transfer_fn ["as" (str source-name "/" (get field :name))])
                                          )
                                      )) fields)


        enrich-fields_full (into enrich-fields (map (fn [field]
                                                      (-> field
                                                          (assoc :name n)
                                                          (assoc :field_name (str (get field :name) "_before"))
                                                          (dissoc :schema)
                                                          (assoc :transfer_fn ["as" (str stage-name-tab "/" (get field :name))])
                                                          )
                                                      )) fields)

        enrich-fields_full (into enrich-fields_full [{:name        n
                                                      :transfer_fn ["left_join"
                                                                    (str source-name "/" key-name)
                                                                    (str stage-name-tab "/" key-name)
                                                                    ]}
                                                     ])
        insert-fields (into [] (map (fn [field]
                                      (-> field
                                          (assoc :name stage-name)
                                          (assoc :field_name (get field :name))
                                          (dissoc :schema)
                                          (assoc :transfer_fn ["as" (str n "/" (get field :name))])
                                          )
                                      )) fields)]
    [stage-mapping-fields
     cust_stage_tab-fields
     enrich-fields_full
     insert-fields]))



(defmethod p/expand-flow "map_before_select_new"
  [md-before mapping]

  (let [mapping (first mapping)
        n (get mapping :name)
        ; n (get mapping :name)
        [_ source-name key-name] (get mapping :transfer_fn)
        schema (sg/get-source-schema md-before source-name)
        fields (get schema :fields)
        ; _ (println source-name "--" fields "--" mapping)
        select-fields (into [] (comp (map (fn [f] (get f :name)))
                                     (remove (fn [f]

                                               (clojure.string/ends-with? f "_before")))
                                     (map (fn [f]
                                            [n f (str source-name "/" f)]
                                            )

                                          )
                                     cat

                                     ) fields)
        select-fields (into select-fields [n "" (str "(where (=null " source-name "/" key-name "_before )) ")])

        ]
    ;(clojure.pprint/pprint select-fields)
    [select-fields]
    )
  )

(defmethod p/expand-flow "map_before"
  [md-before mapping]
  ;(  mapping)
  (let [mapping (first mapping)
        n (get mapping :name)
        ; n (get mapping :name)
        [_ source-name key-name] (get mapping :transfer_fn)
        schema (sg/get-source-schema md-before source-name)
        fields (get schema :fields)



        fields (sort-by (fn [m]
                          (if (= (get m :name) key-name)
                            0
                            1
                            )
                          ) fields)

        ;   _ (clojure.pprint/pprint fields)

        stage-name (str source-name "_stage")
        stage-name-tab (str stage-name "_tab")
        ;statge-enrich (str source-name "_stage")

        stage-mapping-fields (into [] (map (fn [field]
                                             (let [t (get-in field [:schema :type])]
                                               [stage-name
                                                (if (= (get field :name) key-name)
                                                  (str (get field :name) " string key ")
                                                  (str (get field :name) " " t))
                                                ""]))) fields)

        cust_stage_tab-fields [stage-name-tab "" (str "( latest_by_offset " stage-name " " key-name " )")]

        all-field (conj stage-mapping-fields cust_stage_tab-fields)

        ;;;;;;;;;;;;;;;;;;;;;;;;;

        enrich-fields (into all-field (map (fn [field]

                                             [n
                                              (get field :name)
                                              (str source-name "/" (get field :name))
                                              ]

                                             )) fields)


        enrich-fields_full (into enrich-fields (map (fn [field]
                                                      [n
                                                       (str (get field :name) "_before")
                                                       (str stage-name-tab "/" (get field :name))
                                                       ]

                                                      )) fields)

        enrich-fields_full (conj enrich-fields_full [n
                                                     ""
                                                     (str "(left_join " source-name "/" key-name " " stage-name-tab "/" "key_0 " " )")

                                                     ])
        insert-fields (into enrich-fields_full (map (fn [field]
                                                      [stage-name
                                                       (get field :name)
                                                       (str n "/" (get field :name))
                                                       ]

                                                      )) fields)
        ;    insert-fields (conj insert-fields [stage-name "" (str "( key " key-name  ")")   ])
        ;   _ (clojure.pprint/pprint insert-fields)
        insert-fields (into [] cat insert-fields)
        ]

    ;  (clojure.pprint/pprint (partition 3 insert-fields))
    [insert-fields]
    #_[stage-mapping-fields
       cust_stage_tab-fields
       enrich-fields_full
       insert-fields]))

#_(defmethod p/expand-flow "map_before2"
    [md-before mapping]
    ;(  mapping)
    (let [mapping (first mapping)
          n (get mapping :name)
          ; n (get mapping :name)
          [_ source-name key-name] (get mapping :transfer_fn)
          schema (p/get-source-schema md-before source-name)
          fields (get schema :fields)



          fields (sort-by (fn [m]
                            (if (= (get m :name) key-name)
                              0
                              1
                              )
                            ) fields)

          ;   _ (clojure.pprint/pprint fields)

          stage-name (str source-name "_stage")
          stage-name-tab (str stage-name "_tab")
          ;statge-enrich (str source-name "_stage")

          stage-mapping-fields (into [] (map (fn [field]
                                               (let [t (get-in field [:schema :type])]
                                                 [stage-name
                                                  (if (= (get field :name) key-name)
                                                    (str (get field :name) " string key ")
                                                    (str (get field :name) " " t))
                                                  ""]))) fields)

          cust_stage_tab-fields [stage-name-tab "" (str "( latest_by_offset " stage-name " " key-name " )")]

          all-field (conj stage-mapping-fields cust_stage_tab-fields)

          ;;;;;;;;;;;;;;;;;;;;;;;;;

          enrich-fields (into all-field (map (fn [field]

                                               [n
                                                (get field :name)
                                                (str source-name "/" (get field :name))
                                                ]

                                               )) fields)


          enrich-fields_full (into enrich-fields (map (fn [field]
                                                        [n
                                                         (str (get field :name) "_before")
                                                         (str stage-name-tab "/" (get field :name))
                                                         ]

                                                        )) fields)

          enrich-fields_full (conj enrich-fields_full [n
                                                       ""
                                                       (str "(left_join " source-name "/" key-name " " stage-name-tab "/" "key_0 " " )")

                                                       ])
          insert-fields (into enrich-fields_full (map (fn [field]
                                                        [stage-name
                                                         (get field :name)
                                                         (str n "/" (get field :name))
                                                         ]

                                                        )) fields)
          ;    insert-fields (conj insert-fields [stage-name "" (str "( key " key-name  ")")   ])
          ;   _ (clojure.pprint/pprint insert-fields)
          insert-fields (into [] cat insert-fields)
          ]

      ;  (clojure.pprint/pprint (partition 3 insert-fields))
      [insert-fields]
      #_[stage-mapping-fields
         cust_stage_tab-fields
         enrich-fields_full
         insert-fields]))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defn flatten-mapping-impl [md-repo mapping]
  ;(println "--" mapping)
  (let [mapping (first mapping)
        [_ source-name] (get mapping :transfer_fn)
        ;     _ (println "---" source-name)
        source-schema (reduce (fn [acc v]
                                (if (= (clojure.string/lower-case source-name)
                                       (clojure.string/lower-case (get v :name)))
                                  (reduced v)
                                  acc)
                                ) [] md-repo)

        ;    _ (when (= "body" source-name) (p/log-v w))
        source-fields (get source-schema :fields)
        source-fields (into [] (comp (filter (fn [m]
                                               (contains? #{"struct" "array"} (get-in m [:schema :type]))))
                                     (remove (fn [m]
                                               (and
                                                 (contains? #{"array"} (get-in m [:schema :type]))
                                                 (not= "struct" (get-in m [:schema :member_schema :type]))))))
                            source-fields)
        {:keys [source-array-fields source-struct-fields]} (group-by (fn [m]
                                                                       (if (= "array" (get-in m [:schema :type]))
                                                                         :source-array-fields
                                                                         :source-struct-fields)
                                                                       ) source-fields)
        mapping-for-struct (for [w source-struct-fields
                                 f (get-in w [:schema :fields])]
                             (let [t (if (= "struct" (get-in f [:schema :type]))
                                       (str source-name "_" (get w :name) "_" (get f :name) "_struct")
                                       (get-in f [:schema :type])
                                       )]
                               ;    (println "--" t)
                               [(str source-name "_" (get w :name))
                                (str (get f :name) " " t)
                                (str source-name "/" (get w :name) "->" (get f :name))]
                               )
                             )
        out-mapping (into [] mapping-for-struct)
        ;_ (p/log-v out-mapping)
        coll_postfix "_coll"

        mapping-for-explode (loop [[w & source-array-fields] source-array-fields
                                   out []
                                ;   e-name nil
                                   ]

                              (if (nil? w)
                                out
                                #_(if e-name
                                  (conj out [e-name nil (list "internal" true)])
                                  out)

                                (let [e-name (str source-name "_" (get w :name) coll_postfix)
                                      o [e-name
                                         (get w :name)
                                         (str "(explode " source-name "/" (get w :name) ")")]
                                      out (conj out o)
                                      out (conj out [e-name nil (list "internal" true)])

                                      ]
                                  (recur source-array-fields out )))

                              )



        mapping-for-array (for [w source-array-fields
                                f (get-in w [:schema :member_schema :fields])]
                            [
                             ;(get w :name)
                             (str source-name "_" (get w :name))
                             (str (get f :name) " " (get-in f [:schema :type]))
                             (str source-name "_" (get w :name) coll_postfix "/" (get w :name) "->" (get f :name))])


        ;_ (clojure.pprint/pprint array-list)
        out-mapping (into out-mapping mapping-for-explode)
        out-mapping (into out-mapping mapping-for-array)
        ;  out-mapping (into [] cat out-mapping)
        ]

    ;  (clojure.pprint/pprint out-mapping)
    out-mapping))



(defmethod p/expand-flow "flatten"
  [md-repo mapping]
  (let [out-mapping (flatten-mapping-impl md-repo mapping)
        out-mapping (into [] cat out-mapping)]
    [out-mapping]))



(defn get-mapping-impl [schema-coll mapping]
  ;(println "--" mapping)
  (let [mapping (first mapping)
        [_ source-name source-ref-name] (get mapping :transfer_fn)
        ;     _ (println "---" source-name)
        sink-name (get mapping :name)
        ;  _ (println "--" sink-name)

        w (reduce (fn [acc v]
                    (if (= (clojure.string/lower-case source-name)
                           (clojure.string/lower-case (get v :name)))
                      (reduced v)
                      acc)
                    ) [] schema-coll)

        ;    _ (when (= "body" source-name) (p/log-v w))
        fields (get w :fields)
        ;   _ (clojure.pprint/pprint fields)
        fields (into [] (comp
                          (filter (fn [m] (= (clojure.string/lower-case source-ref-name)
                                             (clojure.string/lower-case (get m :name)))))
                          (filter (fn [m]
                                    (contains? #{"struct" "array"} (get-in m [:schema :type]))))
                          (remove (fn [m]
                                    (and
                                      (contains? #{"array"} (get-in m [:schema :type]))
                                      (not= "struct" (get-in m [:schema :member_schema :type]))))))
                     fields)
        ;  _ (clojure.pprint/pprint fields)
        {:keys [source-array-fields source-struct-fields]} (group-by (fn [m]
                                                                       (if (= "array" (get-in m [:schema :type]))
                                                                         :source-array-fields
                                                                         :source-struct-fields)
                                                                       ) fields)
        struct-m (for [w source-struct-fields
                       f (get-in w [:schema :fields])]
                   (let [t (if (= "struct" (get-in f [:schema :type]))
                             (str source-name "_" (get w :name) "_" (get f :name) "_struct")
                             (get-in f [:schema :type])
                             )]
                     ;    (println "--" t)
                     [(str source-name "_" (get w :name))
                      (str (get f :name) " " t)
                      (str source-name "/" (get w :name) "->" (get f :name))]
                     )
                   )
        out-mapping (into [] struct-m)
        ;_ (p/log-v out-mapping)
        coll_postfix "_coll"

        v (for [w source-array-fields]
            [(str sink-name coll_postfix)
             (get w :name)
             (str "(explode " source-name "/" (get w :name) ")")])

        array-list (for [w source-array-fields
                         f (get-in w [:schema :member_schema :fields])]
                     (let [f-type (if (= "array"
                                         (get-in f [:schema :type]))
                                    (if (get-in f [:schema :member_schema :fields])
                                      (str source-name "_" (get w :name) "_" (get f :name) "_struct" " " (get-in f [:schema :type]))
                                      (str (get-in f [:schema :member_schema :type]) " " (get-in f [:schema :type])))
                                    (get-in f [:schema :type]))]
                       [sink-name
                        (str (get f :name) " " f-type)
                        (str sink-name coll_postfix "/" (get w :name) "->" (get f :name))]
                       )
                     )

        ;    _ (clojure.pprint/pprint array-list)
        out-mapping (into out-mapping v)
        out-mapping (into out-mapping array-list)]

    ; (clojure.pprint/pprint out-mapping)
    out-mapping))


(defmethod p/expand-flow "get"
  [schema-coll mapping]
  (let [out-mapping (get-mapping-impl schema-coll mapping)
        out-mapping (into [] cat out-mapping)]
    [out-mapping]))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;











#_(defmethod p/expand-flow "as_data_vault"
    [md-repo mapping]
    (let [[s-name] (p/get-object-value mapping)
          out (->> (p/get-all-subject-names md-repo)
                   (into [] (comp (filter (fn [v] (clojure.string/ends-with? v s-name))))))

          hash-diff "gdp_hashdiff"
          f1 (fn [source-name]
               (let [t-name (clojure.string/replace source-name s-name "")]
                 [(str t-name "_distinct") "" (str "(distinct " source-name " \"2 MINUTES \" " hash-diff ")")
                  (str t-name "_map_before") "" (str "(map_before " t-name "_distinct " hash-diff " )")
                  (str t-name "_dv_stage") "" (str "(map_before_select_new " t-name "_map_before " hash-diff " )")]))
          w (into [] (comp (map f1) cat) out)
          w (into w ["_" "_" (str "( map_dv " "_dv_stage" ")")])]

      [["dummy" "x" ""]
       w]))


