(ns ksql.gen.macro.expand-core
  (:require [ksql.gen.protocol :as p]
            [ksql.gen.reader.mapping-reader :as mr]
            [ksql.gen.core-error-msg :as emsg]
            [ksql.gen.core_schema :as sg]
            [ksql.gen.util :as u]
            [ksql.gen.macro.expand-flow-impl :as f]
            [ksql.gen.macro.expand-step-impl :as s]
            [ksql.gen.macro.metadata-crawler-impl]
            [ksql.gen.macro.map-data-vault-impl]
            [ksql.gen.macro.distinct-impl]
            [ksql.gen.macro.load-ns-impl]))




(defn replace-this-macro [field-m field]
  ;(println "" field-m)
  (let [

        field (if (= "as" (first field))
                (second field)
                field
                )]
    (clojure.walk/postwalk (fn [v]
                             (if (and (u/is-namespace? v)
                                      (clojure.string/includes? v "this/"))
                               (let [[_ fields-name] (clojure.string/split v #"/")
                                     v (get field-m fields-name)]
                                 (when (nil? v)
                                   (throw (emsg/ex-info-for-invalid-local-ref  field fields-name )))
                                 v)
                               v)) field)))


(defn expand-this-macro [mapping]
  ;  (p/log-v mapping)
  (let []
    (loop [[field & mapping] mapping
           out []]
      ;(p/log-v field)
      (if (nil? field)
        out
        (let [trans (get field :transfer_fn)
              new-trans (if (clojure.string/includes? (pr-str trans) "this/")
                          (let [m (into {} (comp (map (juxt :field_name :transfer_fn) #_(fn [v] (println v) [(second v) (nth 2 v)]))
                                                 (remove (fn [[v n]] (nil? v)))
                                                 ) out)]
                            (replace-this-macro m trans))
                          trans)
              new-field (assoc field :transfer_fn new-trans)]
          (recur mapping (conj out new-field))
          )
        )
      )
    )

  ;mapping
  )



(defn into-step [result new-steps]
  (let [field-name-set (into #{} (comp (map :field_name)
                                       (remove nil?)
                                       (remove clojure.string/blank?)
                                       ) new-steps)
        result (into [] (remove (fn [v] (contains? field-name-set (get v :field_name))) result))]
    (into result new-steps)))


(defn get-all-macros []
  (-> (into #{} (keys (methods p/expand-step)))
      (into (keys (methods s/expand-step-internal)))
      (into (keys (methods p/expand-flow)))
      (into (keys (methods f/expand-flow-internal)))
      )
  )


(defn expand-step-processor [schema-coll mapping-steps]
  (let [mapping-steps mapping-steps
        expand-step-list (-> (into #{} (keys (methods p/expand-step)))
                             (disj :default))
        exapnds-step-sets (-> expand-step-list
                              (into (keys (methods s/expand-step-internal)))
                              (disj :default))]

    ;  (clojure.pprint/pprint exapnds-step-sets)
    (loop [[f & r] mapping-steps
           result []]
      (if (nil? f)
        result
        (if (or (nil? (get f :transfer_fn))
                (not (contains? exapnds-step-sets (first (get f :transfer_fn)))))
          (recur r (into-step result [f]))

          (let [w (if (contains? expand-step-list (first (get f :transfer_fn)))
                    (->> ((juxt :name :field_name :transfer_fn) f)
                         (p/expand-step schema-coll result)
                         ;     (p/log-v)
                         (mr/as-compiler-schema)
                         ;    (p/log-v)
                         (into [] (comp
                                    cat
                                    (map (fn [f]
                                           (s/expand-step-internal schema-coll result f)))
                                    cat
                                    )))

                    (s/expand-step-internal schema-coll result f))

                out (into-step result w)]
            (recur r out)))))))



(defn do-expand-step [schema-coll mapping]
  (->> mapping
       (expand-step-processor schema-coll)
       (expand-this-macro)))






(defmethod p/expand-flow "apply"
  [md-repo mapping]
  (let [[op-name e] (sg/get-object-from-mapping mapping)

        opset (into #{} (-> (into #{} (keys (methods p/expand-flow)))
                          (disj :default "apply")))
        _ (when (nil? e)
            (throw (ex-info "post fix is missing" {:e-ref op-name :e-des "post fix is missing "} )))
        _ (when-not (contains? opset op-name)
            (throw (ex-info "op not found " {:e-ref op-name :e-des "op not found " :e-available opset} )))

        s-names (sg/get-all-names md-repo)

        out (into [] (filter (fn [v] (clojure.string/ends-with? v e))) s-names )

        _ (when (empty? out)
            (throw (ex-info "source not found " {:e-ref op-name :e-name e :e-des "source not found " :e-available s-names} ))
            )

        xf (comp #_(filter (fn [v] (clojure.string/ends-with? v e)))
                 (map (fn [w]
                        ["_" "_" (str "(" op-name " " w " " e ")") ";"])))]
    (into [["_dummy_" "x" ""]] xf out #_(sg/get-all-names md-repo))))



(defn do-expand-flow [schema-coll mapping]
  ;(clojure.pprint/pprint mapping)
  (let [expand-flow-set (-> (into #{} (keys (methods p/expand-flow)))
                            (disj :default))
        expand-flow-set (-> expand-flow-set
                            (into (keys (methods f/expand-flow-internal)))
                            (disj :default))
        op (first (get (first mapping) :transfer_fn))

        all-macrow (into #{"type_of"} (get-all-macros))
        ]



    (if (and
          ;(not (nil? op))
          ;(= 1  (count mapping) )
          (contains? expand-flow-set op #_(first (get (first mapping) :transfer_fn)))


             )

      (let [xf (comp (remove empty?)
                     (map (fn [v]
                            (if (p/is-terminate-step v)
                              [(p/get-expand-terminate-value v)]
                              (mr/as-compiler-schema v))))
                     cat
                     (remove empty?)
                     (map (fn [v] (f/expand-flow-internal schema-coll v)))
                     cat)]
        (->> (p/expand-flow schema-coll mapping)
             (into [] xf)))
      [ mapping ]
      #_(throw (ex-info "op not found " {:e-ref op :e-des "op not found " :e-available all-macrow #_(get-all-macros)} ))

)))



#_(defn do-expand-macro [schema-coll mapping]

    (->> (do-expand-flow schema-coll mapping)
         (into [] (map (fn [m] (do-expand-step schema-coll m))))
         ))
