(ns ksql.gen.emitter.ksql.ksql-gen-trans
  (:require [clojure.walk :as w]
            [clojure.zip :as zip]
            [ksql.gen.util :as u]
            [ksql.gen.core_schema :as sch]
            [ksql.gen.core-error-msg :as emsg]
            [ksql.gen.protocol :as p]))


(defn add-string-quote [v]
  (if (string? v)
    (let [v (clojure.string/trim v)]
      (if (clojure.string/starts-with? v "'")
        v
        (str "'" v "'")))
    v

    )
  )


(defn replace-forward-slap [v]
  (cond (number? v)
        v
        (clojure.string/includes? v ")") v
        (u/is-namespace? v)
        (let []
          (if (clojure.string/ends-with? v "*")
            "*"
            (clojure.string/replace v "/" ".")
            )

          )

        :else
        v))

(defn is-constant? [v]
  ;(println  v " --type--"  (type v))
  (if (or (clojure.string/includes? v "/")
          (clojure.string/includes? v ".")
          (clojure.string/includes? v "(")
          (number? v)
          )
    (do
      ;(println "--contant ")
      false
      )

    true
    )
  #_(not (clojure.string/includes? v "/")))

#_(defn constant-as-str [v]
    (str "'" v "'"))

(defn map-constant [v]
  (if (is-constant? v)

    (add-string-quote v)
    v
    )
  )




(defmethod p/transfer-fn :default
  [f]
  ;(  f)
  ;(println "--f " f)
  (let [[f & udf] f
        udf (mapv replace-forward-slap udf)
        uf (clojure.string/join " , " udf)
        uf (str " " f "(" uf " ) ")]
    uf))



(defmethod p/transfer-fn "as"
  [f]
  (let [[fn e-field] f]
    (replace-forward-slap e-field)))

(defmethod p/transfer-fn "gen_id"
  [f]
  (let [udf (rest f)
        udf (mapv map-constant udf)
        udf (mapv replace-forward-slap udf)
        uf (clojure.string/join " + '_' + " udf)]
    uf))

(defmethod p/transfer-fn "hash"
  [f]
  (let [udf (rest f)
        udf (mapv map-constant udf)
        udf (mapv replace-forward-slap udf)
        uf (clojure.string/join " + " udf)
        uf (str " md5 (  " uf "  ) ")]
    uf))


(defmethod p/transfer-fn "+"
  [f]
  (let [udf (rest f)
        ;_ (println "---" udf )
        udf (mapv map-constant udf)
        ; _ (println "---2" udf )
        udf (mapv replace-forward-slap udf)
        uf (clojure.string/join " + " udf)
        ;uf (str "( " uf " ) ")
        ]

    uf))


(defmethod p/transfer-fn "-"
  [f]
  (let [udf (rest f)
        udf (mapv map-constant udf)
        udf (mapv replace-forward-slap udf)
        uf (clojure.string/join " - " udf)
        ;uf (str "( " uf " ) ")
        ]
    uf))


(defmethod p/transfer-fn "/"
  [f]
  (let [udf (rest f)
        udf (mapv map-constant udf)
        udf (mapv replace-forward-slap udf)
        uf (clojure.string/join " / " udf)
        ;uf (str "( " uf " ) ")
        ]
    uf))

(defmethod p/transfer-fn "="
  [f]
  ;  (println "--"f)
  (let [udf (rest f)
        udf (mapv map-constant udf)
        [first-arg second-argv :as udf] (mapv replace-forward-slap udf)
        _ (when (or (nil? second-argv)
                    (nil? first-arg)
                    )
            (throw (emsg/ex-info-for-invalid-equal-fields first-arg second-argv) )
            )
        ;  _ (println "--" first-arg)
        ; _ (println "--" second-argv)
        o (condp = (clojure.string/lower-case second-argv)
            "'null'"
            (str "" first-arg " is null ")
            "null"
            (str "" first-arg " is null ")
            "'nil'"
            (str "" first-arg " is null ")
            "nil"
            (str "" first-arg " is null ")
            (str "" first-arg " = " " " second-argv " "))
        ; uf (clojure.string/join " = " udf)
        ]
    o))

;(split(raw_bnl_policy.inception_date , '/' )[1] )

(defmethod p/transfer-fn "is_null"
  [f]
  (let [[f v] f
        udf (map-constant v)
        udf (replace-forward-slap udf)

        uf (str " " udf " is null  ")]
    uf))


(defmethod p/transfer-fn "is_not_null"
  [f]
  (let [[f v] f
        udf (map-constant v)
        udf (replace-forward-slap udf)
        uf (str " " udf " is not null  ")]
    uf))



(defmethod p/transfer-fn "=null"
  [f]
  (let [[f v] f
        udf (map-constant v)
        udf (replace-forward-slap udf)

        uf (str " " udf " is null  ")]
    uf))


(defmethod p/transfer-fn "!=null"
  [f]
  (let [[f v] f
        udf (map-constant v)
        udf (replace-forward-slap udf)
        uf (str " " udf " is not null  ")]
    uf))


(defmethod p/transfer-fn "index_of"
  [f]
  (let [udf (rest f)
        udf (mapv map-constant udf)
        [first-arg second-argv :as udf] (mapv replace-forward-slap udf)
        _ (when (nil? second-argv)

            (throw  (emsg/ex-info-for-invalid-index   first-arg  second-argv) )
            )
        ;uf (clojure.string/join " and " udf)
        uf (str " " first-arg "[" second-argv "]  ")]
    uf))

(defmethod p/transfer-fn "and"
  [f]
  (let [udf (rest f)
        udf (mapv map-constant udf)
        udf (mapv replace-forward-slap udf)
        uf (clojure.string/join " and " udf)
        uf (str "( " uf " ) ")]
    uf))

(defmethod p/transfer-fn "or"
  [f]
  (let [udf (rest f)
        udf (mapv map-constant udf)
        udf (mapv replace-forward-slap udf)
        uf (clojure.string/join " or " udf)
        uf (str "( " uf " ) ")]
    uf))


(defmethod p/transfer-fn "*"
  [f]
  (let [udf (rest f)
        udf (mapv map-constant udf)
        udf (mapv replace-forward-slap udf)
        uf (clojure.string/join " * " udf)
        ;uf (str "( " uf " ) ")
        ]
    uf))

(defmethod p/transfer-fn "<>"
  [f]
  (let [udf (rest f)
        udf (mapv map-constant udf)
        udf (mapv replace-forward-slap udf)
        uf (clojure.string/join " <> " udf)
        ;uf (str "( " uf " ) ")
        ]
    uf))


(defmethod p/transfer-fn "<"
  [f]
  (let [udf (rest f)
        udf (mapv map-constant udf)
        udf (mapv replace-forward-slap udf)
        uf (clojure.string/join " < " udf)
        ;uf (str "( " uf " ) ")
        ]
    uf))


(defmethod p/transfer-fn ">"
  [f]
  (let [udf (rest f)
        udf (mapv map-constant udf)
        udf (mapv replace-forward-slap udf)
        uf (clojure.string/join " > " udf)
        ;uf (str "( " uf " ) ")
        ]
    uf))


(defmethod p/transfer-fn "!="
  [f]
  (let [udf (rest f)
        udf (mapv map-constant udf)
        udf (mapv replace-forward-slap udf)
        uf (clojure.string/join " != " udf)
        ;uf (str "( " uf " ) ")
        ]
    uf))


(defmethod p/transfer-fn "where"
  [f]
  (str "where " (apply str (rest f))))


(defmethod p/transfer-fn "having"
  [f]
  (str " having " (apply str (rest f))))



(defmethod p/transfer-fn "cast"
  [f]
  (let [udf (rest f)
        ;_ (println "---" udf )
        udf (mapv map-constant udf)
        [first-arg second-argv :as udf] (mapv replace-forward-slap udf)
        ;_ (println "--" second-argv)
        second-argv (clojure.string/replace second-argv "'" "")
        ; _ (println "---2" udf )
        ;udf (mapv replace-forward-slap udf)
        ;uf (clojure.string/join " + " udf)
        ]
    (str " CAST ( " first-arg " AS " second-argv " )  ")

    ))



(defmethod p/transfer-fn "(-)"
  [f]
  (str " ( " (second f) " ) " )
  #_(let [udf (rest f)
        ;_ (println "---" udf )
        udf (mapv map-constant udf)
        [first-arg second-argv :as udf] (mapv replace-forward-slap udf)
        ;_ (println "--" second-argv)
        second-argv (clojure.string/replace second-argv "'" "")
        ; _ (println "---2" udf )
        ;udf (mapv replace-forward-slap udf)
        ;uf (clojure.string/join " + " udf)
        ]
    (str " CAST ( " first-arg " AS " second-argv " )  ")

    ))


(defmethod p/transfer-fn "regex"
  [f]
  (let [[f regex-str regex-v] f
        regex-v (replace-forward-slap regex-v)
        ]
    (str f " ( '" regex-str "' , " regex-v " ) " )
    )
  )


(defmethod p/transfer-fn "validation!"
  [f]
  ;(println "--" f)

  ;(clojure.pprint/pprint f)
  (cond (< (count f) 3)
        (second f)
        (and
          (= (count f) 3)
          (string? (nth f 2)))
        (nth f 2)

        :else
        (let [[_ f-name & r] f

              r (into [] (map (fn [v]
                                (if (clojure.string/includes? v "/")
                                  (replace-forward-slap v)
                                  (if (clojure.string/starts-with? v "'")
                                    v
                                    (str "'" v "'"))))) r)
              r (clojure.string/join " , " r)]
          (str f-name " ( " r " ) "))
        )

  )



(defmethod p/transfer-fn "concat"
  [f]
  (let [udf (rest f)
        ;_ (println "---" udf )
        udf (mapv map-constant udf)
        ; _ (println "---2" udf )
        udf (mapv replace-forward-slap udf)
        uf (clojure.string/join " + " udf)]
    uf))



(defmethod p/transfer-fn "constant"
  [f]
  ; (println "--" f)
  (let [[fn e-field] f
        w (if (clojure.string/starts-with? e-field "'")
            e-field
            (add-string-quote e-field)
            ;(str "'" e-field "'")
            )
        ]
    (str " constant ( " w " ) ")))

(defmethod p/transfer-fn "null"
  [f]
  (let [[fn e-field] f]
    (str " vnull () ")))



(declare field-transformation)



(defn case-transfer-fn
  [f]
  ;  (  f)
  ;(println "--case tranformation " f)
  ; (println (sequential? (last f)) )
  (let [source-field (if (sequential? (second f))
                       (field-transformation (second f))
                       (replace-forward-slap (second f))
                       )
        f (if (sequential? (last f))
            f
            (->
              (into [] (butlast f))
              (into ["else"])
              (conj (last f))

              )

            )
        input-with-else (split-with (complement #{"else" "ELSE"}) f)
        else-block (first (rest (second input-with-else)))
        ;_ (println else-block)
        else-block2 (if (sequential? else-block)
                      (into [] else-block)
                      else-block
                      ) #_(into [] (first else-block))
        ;_ (println else-block2)
        ;_ (println "--" (type else-block2))
        ;_ (  else-block)
        ;  _ (println "--" (number? else-block2))
        else-block (cond (number? else-block2)
                         else-block2
                         (empty? else-block2)
                         "null"
                         (sequential? else-block2)
                         (field-transformation else-block2)
                         :else
                         (let [v (last f)]

                           (cond

                             (number? v)
                             v
                             (and (not (clojure.string/starts-with? v "'"))
                                  (u/is-namespace? v))
                             (clojure.string/replace v "/" ".")
                             (u/is-process-string? v)
                             v
                             :else
                             (add-string-quote v)
                             ;(str "'" v "'")
                             )
                           )

                         )

        format-v (fn [k]
                   (cond (number? k)
                         k
                         (sequential? k)
                         (field-transformation k)

                         (u/is-process-string? k)
                         k

                         (clojure.string/includes? k "/")
                         k

                         (boolean? k)
                         k

                         (= k "null")
                         "null"
                         :else
                         (add-string-quote k)
                         ))

        ;_ (println "--" else-block)
        ;f (if (sequential? (last f))          f            (into [] (butlast f)))
        ;_ (println "--" f)
        cases (into [] (drop 2 (first input-with-else)))  #_(into [] (drop 2 f))
        ;_ (println "--" cases)
        case-st (reduce (fn [acc [condition k v]]
                          ; (println "--" v "--" k  "--" (type k) )
                          (if (nil? v)
                            (str acc " WHEN " (field-transformation [condition source-field]) " THEN " k)
                            (let [
                                  k1 (format-v k)

                                  v1 (format-v v)
                                  k (if (string? k1)
                                      (replace-forward-slap k1)
                                      k1
                                      )
                                  v (if (string? v1)
                                      (replace-forward-slap v1)
                                      v1
                                      )
                                  ]
                              (str acc " WHEN " source-field " " condition "  " k " THEN " v)
                              )
                            )

                          ) "" cases)]
    (str "CASE " case-st " ELSE " else-block " END ")))


(defn replace-quote-by-constant [w]
  (cond (p/quote-string? w)
        (let [v (p/get-quote-value w)
              v (str " constant ( '" (clojure.string/join (rest (butlast (seq v)))) "' ) ")]
          v)
        (p/constant-string? w)
        (str " constant ( '" (p/get-quote-value w) "' ) ")
        :else
        w))


(defn replace-quote-value [w]

  (cond (p/quote-string? w)
        (let [v (p/get-quote-value w)
              v (if (string? v)
                  (str "'" (clojure.string/join (rest (butlast (seq v)))) "'")
                  v)]
          v)
        (p/constant-string? w)
        (p/get-quote-value w)

        :else
        w)
  )




(defn field-transformation [input]
  ;(println "----" input)
  (->> input
       (w/postwalk replace-quote-value)
       (w/postwalk (fn [w]
                     (if (and (sequential? w)
                              (= "case" (first w)))
                       (str "( " (case-transfer-fn w) " ) ")
                       w)))
       (w/postwalk (fn [w]
                     #_(println "---input " input)
                     (if (and (sequential? w)
                              (not (p/quote-string? w))
                              )
                       (let [

                             o (p/transfer-fn w)]
                         ;(println "--" (type o) "--" o)
                         o
                         )

                       w))))
  #_(if (= "case" (first input))
      (case-transfer-fn input)
      ))


#_(defn breadth-first-search [z]
    (letfn [(zip-children [loc]
              (when-let [first-child (zip/down loc)]
                (take-while (comp not nil?)
                            (iterate zip/right first-child))))]
      (loop [ret []
             queue (conj clojure.lang.PersistentQueue/EMPTY z)]
        (if (seq queue)
          (let [[node children] ((juxt zip/node zip-children) (peek queue))]
            (recur (conj ret node) (into (pop queue) children)))
          ret))
      )
    )




(defn where-transformation [input]
  (field-transformation input)
  )



(defn make-join-type [join-str]
  (condp = join-str
    "left_join" "left join"
    "join" "inner join"
    "outer_join" "outer join"
    "inner join"))


(defn join-transformation-one
  [context entity-schema-m join-input join-window]

  (let [join-window (or (get context :join-window) join-window)

        [join-type source-entity target-entity join-window-inline] join-input

        source-entity (field-transformation source-entity)

        join-window (or join-window-inline join-window)
        ;_ (println "--" input)
        join-type (make-join-type join-type)
        target-entity-name (first (clojure.string/split target-entity #"/"))
        source-field-name (clojure.string/replace source-entity #"/" ".")
        target-field-name (clojure.string/replace target-entity #"/" ".")
        ;  _ (println "----------" (keys entity-schema-m))
        buffer-frame (if (contains? #{"TABLE" "table"}
                                    (sch/get-type (get-in entity-schema-m [(clojure.string/lower-case target-entity-name)])))
                       ""
                       join-window)]
    (str " " join-type " " target-entity-name " " target-entity-name " " buffer-frame " ON " source-field-name " = " target-field-name)))


(defn join-transformation
  ([context entity-schema-m join-input] (join-transformation context entity-schema-m join-input "WITHIN 5 MINUTES"))
  ([context entity-schema-m join-input join-window]
   ;(println "--join " join-input)
   ;(   entity-schema-m)
   (clojure.string/join " " (mapv (fn [j]
                                    (join-transformation-one context entity-schema-m j join-window)
                                    ) join-input))))


