(ns ksql.gen.core-type-processor
  (:require [ksql.gen.protocol :as p]
            [ksql.gen.core-error-msg :as emsg]
            ))



(def arvo-p-type #{"string" "varchar" "bytes" "double" "float" "long" "int" "integer" "bigint" "boolean" "decimal" "null"})



(defn get-source-name-from-fields [transfer_fn]
  (->> transfer_fn
       rest
       (filter (fn [v]
                 (clojure.string/includes? v "/")))
       (remove (fn [v]
                 (clojure.string/starts-with? v "'")))
       (flatten)
       (first)))

(comment

  (get-source-name-from-fields ["as" "'ref_mapping2/id'"])

  )




(defn apply-type-cast? [source-type sink-type]
  (if (and source-type
           sink-type
           (contains? #{"int" "integer" "double" "bigint" "long"} (clojure.string/lower-case (first sink-type)))
           (contains? #{"string"} (clojure.string/lower-case (first source-type))))
    true
    false))


;SELECT PERSON_RAW3.id AS id , CAST ( PERSON_RAW3.value AS bigint ) AS value
;FROM PERSON_RAW3 PERSON_RAW3
;where  CAST ( person_raw3.value AS bigint ) <> 0 and  person_raw3.value is not null
;     or
;      CAST ( person_raw3.value AS bigint ) = 0
;emit changes ;

(defn build-expression-for-type-cast [s-name sink-type source-type]
  (let [[f & r :as w] s-name
        s-name (if (= "as" f)
                 (second w)
                 w)]
    ["validation!" "castable" s-name sink-type source-type]
    )
  )



(defn get-source-type [st]
  (let [source-type (loop [out []
                           m st]
                      (if (nil? m)
                        (into [] (reverse out))
                        (let [out (conj out (get m :type))]
                          (recur out (get m :member_schema)))))
        source-type (if (empty? source-type) nil source-type)]
    source-type))


(defn logical-type-condition [source-field l-type]
  (let [l-type2 (clojure.walk/postwalk (fn [v]
                                         (if (and (string? v)
                                                  (= v "#value"))
                                           source-field
                                           v)) (rest (get l-type :type_of)))
        l-type2 (into [] (map (fn [v]
                                (if (string? v)
                                  ["regex" v source-field]
                                  v))) l-type2)
        w (if (< 1 (count l-type2))
            [(into ["and"] l-type2)]
            l-type2)]
    w))

(defn map-logical-type [md-repo flow-mapping]
  (let [logical-m (into {} (comp (filter (fn [v]
                                           (= (get v :type) "type")))
                                 (map (fn [m]
                                        {(get m :name) (assoc m :type (first (get m :type_of)))}))
                                 ) md-repo)
        xf (fn [step-mapping]

             (if (and (get step-mapping :field_name)
                      (get step-mapping :field_type)
                      (get step-mapping :transfer_fn)
                      (get logical-m (get-in step-mapping [:field_type 0])))
               (let [tf (get step-mapping :transfer_fn)
                     source-field (if (= "as" (first tf))
                                    (second tf)
                                    tf)
                     l-type (get logical-m (get-in step-mapping [:field_type 0]))
                     condition (logical-type-condition source-field l-type)
                     w (-> step-mapping
                           (assoc-in [:field_type 0] (get l-type :type))
                           (assoc :logical-type (get l-type :name)))

                     w (if-not (empty? condition )
                         (assoc w :validation! (into ["validation!"] condition))
                         w
                         ) ]
                 [w])
               [step-mapping]))]
    (into [] (comp (map xf) cat) flow-mapping)))



(defn map-cast-for-source-type [md-repo flow-mapping]
  ;(p/log-v flow-mapping)
  (let [schema-m (reduce (fn [acc v]
                           (let [sink-name (get v :name)]
                             (if (get acc sink-name)
                               acc
                               (merge acc (into {} (map (fn [m]
                                                          {(str sink-name "/" (get m :name)) (get-in m [:schema])}
                                                          )) (get v :fields)))))
                           ) {} md-repo)
        ; _ (clojure.pprint/pprint schema-m)
        ;type-cast-expression (atom [])
        ;    error-expression (atom [])
        ; sink-name (get (first flow-mapping) :name)
        xf (map (fn [step-mapping]
                  ;       (println "--" step-mapping)
                  (if (get step-mapping :field_name)
                    (let [s-name (get-source-name-from-fields (get step-mapping :transfer_fn))
                          st (when-let [v (get schema-m s-name)] v)
                          source-type (get-source-type st)

                          sink-type (get-source-type (get schema-m (str (get step-mapping :name) "/" (get step-mapping :field_name))))

                          sink-type (or sink-type
                                        (get step-mapping :field_type)
                                        source-type
                                        ["string"])]

                      ;   (println source-type "--" sink-type "--"(get step-mapping :transfer_fn))

                      (if (apply-type-cast? source-type sink-type)
                        (let [c-validation (build-expression-for-type-cast (get step-mapping :transfer_fn) (first sink-type) (first source-type))]

                          (-> (assoc step-mapping :field_type sink-type :source-type st)
                              (update :transfer_fn (fn [[f & r :as w]]
                                                     (if (= "as" f)
                                                       ["as" ["cast" s-name (first sink-type)]]
                                                       ["cast" w (first sink-type)])))
                              (update :validation! (fn [v]
                                                     (into (or v []) c-validation #_(vec (rest)))

                                                     ))

                              ))
                        (assoc step-mapping :field_type sink-type :source-type st)))
                    step-mapping)))
        out (into [] xf flow-mapping)]

    out
    ))



(defn assoc-field-schema [md-repo mapping]
  ;(clojure.pprint/pprint mapping)
  ; (p/log-v mapping)
  (let [
        md-repo (into {} (map (fn [m]
                                {(get m :name) m}
                                )) md-repo)
        ;@todo key come as tranformation fn, need to remove this functionality. key should be attached as field
        key-field (->> mapping
                       (mapv :transfer_fn)
                       (remove nil?)
                       (filter (fn [v] (= "key" (first v))))
                       (first)
                       (second))

        other-mapping (into [] (filter (fn [v] (nil? (:field_name v)))) mapping)

        xf (comp
             (remove (fn [v] (nil? (:field_name v))))
             (map (fn [m]
                    ;(println "--" m )
                    (let [;tf (as-vector (get m :transfer_fn))
                          type (get m :field_type)
                          logical_type (get m :logical-type)
                          ;   _ (println "--type" type)
                          field_type (if (and (= (get m :field_name) key-field)
                                              (= 1 (count type)))
                                       (conj type "key")
                                       type)

                          ;   _ (println "--" m )
                          schema (loop [[ftype & type-coll] (reverse field_type)
                                        out {}]
                                   (if (nil? ftype)
                                     out
                                     (let [w (get md-repo ftype)
                                           t (get-in w [:type])

                                           _ (when (contains? #{"stream" "table"} t)
                                               (throw (emsg/ex-info-for-invalid-type-ref ftype)))

                                           schema (cond

                                                    (= t "type")
                                                    {:type         (get-in w [:type_of 0])
                                                     :logical-type ftype}

                                                    (= t "struct")
                                                    (select-keys w [:fields :type])

                                                    :else
                                                    {:type ftype :member_schema nil :fields nil :logical-type logical_type})


                                           out (if (empty? out)
                                                 schema
                                                 (assoc out :member_schema schema))]
                                       (recur type-coll out))))]

                      (-> m
                          (assoc :schema schema)
                          (dissoc :field_type)))))
             ; p/xf-log-v
             )
        ]
    (-> (into [] xf mapping)
        (into other-mapping)
        )

    )
  )
