(ns ksql.gen.core-gen-type
  (:require [ksql.gen.protocol :as p]
            [ksql.gen.util :as u]

            [ksql.gen.core_schema :as sg]
            ))


#_(defn map-insert-type [schema-coll current-mapping]
    (let [sink-name (get current-mapping :name)
          sink-schema (reduce (fn [acc v]
                                (if (= sink-name
                                       (get v :name)
                                       )
                                  (reduced v)
                                  acc)
                                ) nil schema-coll)]
      (-> current-mapping
          (assoc :sink-schema sink-schema
                 :sink-key (get sink-schema :key)
                 :ksql-gen-type p/gen-ksql-stream-insert-from-mapping))))


(defn map-table-type [schema-coll current-mapping]
  (let [source-names (u/get-all-source-name current-mapping)
        main-source-name (u/get-main-source-name current-mapping)

        source-schema-m (into {} (comp (map (partial sg/get-source-schema schema-coll))
                                       (remove nil?)
                                       (map (fn [m]
                                              {(get m :name) m}
                                              ))
                                       ) source-names)

        all-transformation-fn (mapv (fn [m]
                                      (first (get m :transfer_fn))
                                      ) (:fields current-mapping))
        ;  _ (println all-transformation-fn)
        create-table? (if (every? #{"as"} all-transformation-fn) true false)
        ]

    ;  (println "--" create-table?)
    ;(println "--" (keys schema-m) "--" main-source-name "--" (get schema-m main-source-name))
    (cond (and create-table?
               (=
                 (get current-mapping :key)
                 (get (get source-schema-m main-source-name) :key)))
          (do
            (assoc current-mapping :ksql-gen-type p/gen-ksql-create-table))

          (and
            create-table?
            (not=
              (get current-mapping :key)
              (get (get source-schema-m main-source-name) :key)))

          (assoc current-mapping :ksql-gen-type p/gen-ksql-table-from-stream-after-rekey)

          :else
          (assoc current-mapping :ksql-gen-type p/gen-ksql-create-table-as))))


(defn map-generation-type [md-repo md-schema]

  ;(println "----------" )
  (cond

    (not (sg/gen-type? md-schema))
    md-schema

    (= "mapping" (sg/get-type md-schema) #_(get md-schema "type"))

    (assoc md-schema :ksql-gen-type p/gen-ksql-stream-insert-from-mapping)


    (and (nil? (u/get-main-source-name md-schema))
         (= "table" (sg/get-type md-schema)))
    (assoc md-schema :ksql-gen-type p/gen-ksql-create-table)


    (and (nil? (u/get-main-source-name md-schema))
         (= "stream" (sg/get-type md-schema)))
    (assoc md-schema :ksql-gen-type p/gen-ksql-create-stream)



    (and (u/get-main-source-name md-schema)
         (= "table" (sg/get-type md-schema)))
    (map-table-type md-repo md-schema)



    :else
    (assoc md-schema :ksql-gen-type p/gen-ksql-stream-from-mapping)
    ))
