(ns ksql.gen.core-error-builder
  (:require [ksql.gen.protocol :as p]
            [ingestion.api.client.ns-repo-impl :as c]
            [ksql.gen.core_schema :as cs]))



(defn as-error-mapping [{:keys [cause source-name target-name source-value dq-condition]}]

  [{:name        (get p/context :error-stream-name "error")
    :field_name  "cause"
    :field_type  ["string"],
    :transfer_fn cause}

   {:name        (get p/context :error-stream-name "error")
    :field_name  "cause_des"
    :field_type  ["string"],
    :transfer_fn ["constant" (str "'dq error '")]}

   {:name        (get p/context :error-stream-name "error")
    :field_name  "cause_id"
    :field_type  ["string"],
    :transfer_fn ["concat" "1"]}

   {:name        (get p/context :error-stream-name "error")
    :field_name  "source_name"
    :field_type  ["string"],
    :transfer_fn ["constant" source-name]}

   {:name        (get p/context :error-stream-name "error")
    :field_name  "event_time_stamp"
    :field_type  ["string"],
    :transfer_fn ["TIMESTAMPTOSTRING" (str source-name "/rowtime") "'yyyy-MM-dd HH:mm:ss.SSS'"]}

   {:name        (get p/context :error-stream-name "error")
    :field_name  "target_name"
    :field_type  ["string"],
    :transfer_fn ["constant" target-name]}

   {:name        (get p/context :error-stream-name "error")
    :field_name  "source_value"
    :field_type  ["string"],
    :transfer_fn source-value}


   {:name        (get p/context :error-stream-name "error")
    :field_name  nil
    :transfer_fn ["where" dq-condition]}])



(defn as-json-fields [source-name fields]
  (let [w (reduce (fn [acc v]
                    (conj acc [(str "'" v ":'") ["cast" (str source-name "/" v) "string"]])

                    ) [] fields)
        w (interpose [","] w)
        w (apply concat w)
        w (into ["concat" "{"] w)
        w (conj w " }")]
    w
    ))


(comment
  (as-json-fields "test" (list "aa" "ba"))

  )



(defn as-readable-error-msg [v]

;  (println "---------------------" v)

  (let [v (into [] v)
        v (update v 0 (fn [ff] (clojure.string/replace-first ff "!" "")))]
    (str "'" (clojure.string/replace (clojure.string/join " " (flatten v)) "'" "") "'")))



(def revese-map {"!=null" "=null" "=null" "!=null"})


(defn is-null-check? [v]
  (get revese-map (get-in v [1 0])))


(defn with-parentheses [v]
  [(first v) (into ["(-)"] (rest v))])

(defn without-parentheses [v]
  (get-in v [1 1]))


(defn create-cause-statement [dq-conditions]
  (reduce (fn [acc v]
            (if (empty? (rest v))
              acc
              (let [w (if (sequential? (second v))
                        (if (is-null-check? v)
                          ["case" ["ifnull" (get-in v [1 1]) "'false'"]
                           ["=" "false" (as-readable-error-msg (second v))]]
                          ["case" (second v)
                           ["=" false (as-readable-error-msg (without-parentheses v))]])
                        ;;; external dq_udf call msg
                        ;; for [= false [validation! dq_check 'contain?' 1,2,3 party_raw/id]]
                        ["case" v ["=" false (as-readable-error-msg (rest v))]])]
                (if (empty? acc)
                  w
                  (conj (into w ["else"]) acc)))
              )

            ) [] dq-conditions))


(defn convert-to-where-clause [mapping]
  (into [] (comp
             (map :transfer_fn)
             (remove nil?)
             (distinct)
             (filter (fn [v] (= "validation!" (first v))))
             (map second)
             cat
             (map (fn [v]
                    (if (sequential? (second v))
                      (if (is-null-check? v)
                        (update-in v [1 0] (fn [w] (get revese-map w w)))
                        (with-parentheses v))
                      v)))
             ) mapping))


(defn as-or-condition [where-condition]
  (->> where-condition
       (into ["or"] (map (fn [v]
                           (if (and (sequential? (second v))
                                    (is-null-check? v))
                             v
                             ["=" false v])
                           )))))


(defn- map-to-error-model-impl [md-repo mapping]
  (let [where-condition (convert-to-where-clause mapping)]
    (when-not (empty? where-condition)
      (let [e-name-coll (into [] (comp
                                   (map :name)
                                   (remove nil?)
                                   (distinct)
                                   ) mapping)
            target-name (first e-name-coll)
            source-coll (into [] (comp (filter (fn [f]
                                                 (clojure.string/includes? f "/")
                                                 ))
                                       (distinct)
                                       (map (fn [v] (first (clojure.string/split v #"/"))))
                                       (distinct)
                                       ) (flatten where-condition))
            source-name (first source-coll)

            field-name (cs/get-property-names md-repo source-name)
            json-field (as-json-fields source-name field-name) #_(into [])

            ;r (rest dq-conditions)
            casue-fn (create-cause-statement (reverse where-condition))
            as-or-conditions (as-or-condition where-condition)]

        (as-error-mapping {:cause        casue-fn
                           :source-name  source-name
                           :target-name  target-name
                           :source-value json-field
                           :dq-condition as-or-conditions})))))



(defn map-to-error-model [md-repo mapping]
  (if-let [error-table (map-to-error-model-impl md-repo mapping)]
    [mapping error-table]
    [mapping]))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defn- get-validation-from-mapping [mapping]
  (into [] (comp
             (filter (fn [v]
                       (and
                         (nil? (:field_name v))
                         (contains? #{"validation!"} (first (get v :transfer_fn [""]))))))
             (map :transfer_fn)
             ) mapping))



(defn- get-dq-check-from-mapping [mapping]
  (into [] (comp
             (filter (fn [v]
                       (and
                         (nil? (:field_name v))
                         (contains? #{"dq_check"} (clojure.string/lower-case
                                                    (or (first (get v :transfer_fn [""])) "")
                                                    )))))
             (map :transfer_fn)
             (remove nil?)
             (map (fn [v] (into ["validation!"] v)))
             ) mapping))


;(defn map-validation-for-type [])


(defn merge-to-validator [mapping]

  (let [n-str (->> (mapv :name mapping)
                   (distinct)
                   (first))

        validation-coll (get-validation-from-mapping mapping)
        t-validation-coll (into [] (comp (map :validation!) (remove nil?)) mapping )
        validation-coll (into validation-coll t-validation-coll)
      ;  _ (clojure.pprint/pprint validation-coll2)
        dq-check-coll (get-dq-check-from-mapping mapping)
       ; _ (clojure.pprint/pprint validation-coll)


        ;_ (clojure.pprint/pprint validation-coll2)


        validation (->> (into dq-check-coll validation-coll)
                        (sort-by (fn [v]
                                   (if (sequential? (second v))
                                     0 1)))
                        (into []))

        mapping (into [] (remove (fn [m]
                                   (contains? #{"validation!"
                                                "dq_check"} (first (get m :transfer_fn [""])))
                                   )) mapping)]
    ;(clojure.pprint/pprint validation)
    (if (empty? validation)
      mapping
      (->> {:name        n-str
            :transfer_fn (conj ["validation!"] validation)}
           (conj mapping)))))


