(ns ksql.gen.core
  (:require [ingestion.api.client.ns-repo-impl :as c]
            [ksql.gen.macro.expand-join-impl :as mc2]
            [ksql.gen.macro.expand-core :as fi]
            [ksql.gen.protocol :as p]
            [ksql.gen.util :as u]
            [ksql.gen.core-error-msg :as einfo]
            [ksql.gen.macro.expand-step-impl :as si]
            [ksql.gen.core-type-processor :as tp]
            [ksql.gen.core_schema :as sg]
            [ksql.gen.macro.rekey-generator :as rekey]
            [ksql.gen.core-error-builder :as eb]
            [ksql.gen.core-gen-type :as gt]
            [clojure.tools.reader.edn :as edn]))


(defn reorder-key-field-position
  "Put key field will be first position of mapping "
  [md-repo mapping]
  ; (p/log-v mapping)
  (let [key-field-name (->> mapping
                            (filter (fn [f] (nil? (get f :field_name))))
                            (map :transfer_fn)
                            (filter (fn [v] (= (first v) "key")))
                            (first)
                            (second))
        mapping (sort-by (fn [m]
                           (if (or (= (get-in m [:field_type 1]) "key")
                                   (and
                                     key-field-name
                                     (= (get m :field_name) key-field-name))
                                   )
                             0
                             1)) mapping)]

    mapping))


(defn reorder-field-position
  "reorder field position "
  [md-repo mapping]
  (let [sink-name (first (map :name mapping))
        sink-schema (reduce (fn [acc v]
                              (if (= sink-name
                                     (get v :name))
                                (reduced v)
                                acc)
                              ) nil md-repo)]
    (if-not sink-schema
      mapping
      (let [sink-fields (when sink-schema (get sink-schema :fields))
            mapping-field-m (into {} (comp (filter :field_name)
                                           (map (fn [f]
                                                  {(get f :field_name) f}
                                                  ))
                                           ) mapping)
            others-field (into [] (remove :field_name) mapping)

            new-sink-fields (into [] (map (fn [v]
                                            (let [n (get v :name)]

                                              (if-let [mapping-field (get mapping-field-m n)]
                                                mapping-field
                                                {:transfer_fn ["vnull"]
                                                 :source-type (get-in v [:schema :type])
                                                 :field_name  (get v :name)
                                                 :name        sink-name}))
                                            )) sink-fields)
            out (into new-sink-fields others-field)]
        out
        )
      )
    )
  )



(defn into-metadata-repo [metadata-repo new-metadata-repo]
  (let [w (into #{} (map (juxt :name :source-name)) metadata-repo)]
    (into metadata-repo
          (remove (fn [mapping]
                    (contains? w ((juxt :name :source-name) mapping))))
          new-metadata-repo)))


(defn conj-metadata-repo [metadata-repo new-metadata-repo]
  ;(println "---------" ((juxt :name :source-name) new-metadata-repo))
  ;(p/log-v new-metadata-repo)
  (let [w (into #{} (map (juxt :name :source-name)) metadata-repo)]
    (if (contains? w ((juxt :name :source-name) new-metadata-repo))
      metadata-repo
      (conj metadata-repo new-metadata-repo))))





(defn assoc-source-schema [md-repo current-mapping]
 ; (p/log-v current-mapping)
  ;(p/log-v (u/get-main-source-name current-mapping))
  (if-not (u/get-main-source-name current-mapping)
    current-mapping
    (let [
          ;t (sg/get-source-schema md-repo (clojure.string/lower-case (get current-mapping :name)))
          source-names (u/get-all-source-name current-mapping)
          source-schema-m (into {} (comp (map (partial sg/get-source-schema md-repo))
                                         (remove nil?)
                                         (map (fn [m]
                                                {(get m :name) (select-keys m [:type])}))
                                         ) source-names)]
   ;   (p/log-v source-names)
      (assoc current-mapping :source-schema-type source-schema-m
                             :source-name source-names)
      #_(cond->
              t (assoc :ksql-gen-type p/gen-ksql-stream-insert-from-mapping )
              )
      )

    )
  )




(defn do-post-validation [schema-m]
  (when (and (= (get schema-m :type) "table")
             (nil? (get schema-m :key))
             )
    (throw (ex-info (p/msg :500) (select-keys schema-m [:name :key])))))





(defn do-mapping-pre-validtion! [md-repo mapping]
  ;  (clojure.pprint/pprint mapping)

  (doseq [m mapping]
    (when (and (nil? (get m :transfer_fn ))
               (nil? (get m :field_name)))
      (throw (einfo/ex-info-for-null-field-or-transformation m))))

  (let [sink-name (first (map :name mapping))
        sink-schema (reduce (fn [acc v]
                              (if (= sink-name
                                     (get v :name))
                                (reduced v)
                                acc)
                              ) nil md-repo)
        transformation-field (into [] (comp (map :transfer_fn)
                                            (remove nil?)
                                            (remove (fn [v] (= "from_edn_data" (first v))))
                                            (map (fn [v] (flatten v)))
                                            cat
                                            (remove nil?)
                                            (filter (fn [v]
                                                      ;(println "--" v)
                                                      (clojure.string/includes? v "/")))
                                            (remove (fn [v]
                                                      ;    (println "--" v)
                                                      (or
                                                        (clojure.string/starts-with? v "'")
                                                        (= "\"\"" v)
                                                        (= "/" v)
                                                        (clojure.string/includes? v "/*")
                                                        (clojure.string/includes? v "->")


                                                        (not (= 2
                                                                (count (clojure.string/split v #"/"))
                                                                )

                                                             )

                                                        )))
                                            (map (fn [v] (clojure.string/trim v)))

                                            (map (fn [v]
                                                   (let [w (clojure.string/split v #"/")]
                                                     (conj w v))))
                                            ;  (cat)
                                            (remove (fn [v] (contains? #{"rowtime" "*"} (second v))))
                                            ) mapping)

        rf-g (group-by first transformation-field)
        rf-g (dissoc rf-g "this")]

    ;; apply only when there is mapping between source and target
    (when (and sink-schema
               (not (empty? rf-g))
               )
      (let [mapping-fields (into #{} (comp (filter :field_name)
                                           (map :field_name)
                                           ) mapping)
            sink-fields (into #{} (map :name) (get sink-schema :fields))]

        (when-not (clojure.set/subset? mapping-fields sink-fields)
          (throw (einfo/ex-info-for-invalid-field sink-name mapping mapping-fields sink-fields)))))

    (when-not (empty? rf-g)
      (doseq [[k v] rf-g]
        (let [sink-schema (reduce (fn [acc v]
                                    (if (= k (get v :name))
                                      (reduced v)
                                      acc)
                                    ) nil md-repo)
              _ (when-not sink-schema
                  (throw (einfo/ex-info-for-invalid-source-ref k v) ))

              sink-fields (into #{} (comp (map :name) (map clojure.string/trim)) (get sink-schema :fields))
              source-field (into #{} (comp (map second) (map clojure.string/trim)) v)]
          (when-not (clojure.set/subset? source-field sink-fields)
            (throw  (einfo/ex-info-for-invalid-source-field-ref sink-name source-field sink-fields ) )))))))


(defn- do-compile-impl
  "Expand mapping after apply expand-flow, expand-step, this macro, split join if configuration is set true, implicit rekey impl "
  [md-repo mapping]

  (do-mapping-pre-validtion! md-repo mapping)
  (let [mapping-coll (fi/do-expand-flow md-repo mapping)
        [f-mapping & expand-rest-mapping] mapping-coll
        f-mapping (into [] (remove (fn [m] (= (get m :name) "_dummy_"))) f-mapping)]
    (if (empty? f-mapping)
      [nil expand-rest-mapping]
      (let [[f-mapping & r-mapping] (into [] (comp
                                               (map (fn [mapping] (fi/do-expand-step md-repo mapping)))
                                               (map (partial reorder-key-field-position md-repo))
                                               (map (fn [mapping] (reorder-field-position md-repo mapping)))
                                               (map (fn [mapping] (-> (tp/map-logical-type md-repo mapping)
                                                                      #_(p/log-v ))  ))

                                               (map (fn [mapping] (tp/map-cast-for-source-type md-repo mapping)))
                                              ;  p/xf-log-v
                                               (map (fn [mapping] (eb/merge-to-validator mapping)))
                                               (map (fn [mapping] (eb/map-to-error-model md-repo mapping)))
                                               cat
                                               (map (fn [mapping]
                                                      (if (get p/context :join-split false)
                                                        (mc2/join-expand mapping)
                                                        [mapping])))
                                               cat
                                               (map (fn [mapping] (rekey/rekey-impl md-repo mapping)))
                                               cat
                                               ) [f-mapping])


            f-mapping (->> f-mapping
                           (tp/assoc-field-schema md-repo)
                           (sg/convert-mapping-to-md-schema md-repo)
                           ;p/log-v
                           (assoc-source-schema md-repo)
                           (gt/map-generation-type md-repo))
            ;_ (p/log-v f-mapping)
            r-mapping (if r-mapping
                        (into (into [] r-mapping) expand-rest-mapping)
                        expand-rest-mapping)
            ]
       ; (p/log-v f-mapping)
        [f-mapping r-mapping]))))



(defn do-compile-batch
  "Compile mapping and produce metadata repo, return new meta data repo "
  [md-repo mapping-coll]
  (loop [[mapping & r] mapping-coll
         new-md-repo []
         t-md-repo md-repo]

    (if (nil? mapping)
      (->> t-md-repo
          ; (p/log-v)
           )

      (let [[f-mapping exapnd-mapping] (do-compile-impl t-md-repo mapping)
            ;_ (p/log-v (count t-md-repo))
            t-md-repo (if f-mapping
                           (->> f-mapping
                                (conj-metadata-repo t-md-repo))
                           t-md-repo)
            ;_ (p/log-v "---" (count t-md-repo))
            ;_ (p/log-v t-md-repo)
            r-mapping (if exapnd-mapping
                        (into (vec exapnd-mapping) r)
                        r)]
        (recur r-mapping new-md-repo t-md-repo)))))


