(ns ksql.gen.connector.core
  (:require [cheshire.core :as json]
            [ksql.gen.protocol :as p]
            ;[ksql.client :as client]
            [ingestion.api.client.ns-repo-impl :as c]
            [ksql.gen.connector.config-generator]
            [ksql.gen.reader.file-reader :as r]
            [ksql.gen.file-util :as fio]))


(defn is-file-name? [file-name]
  (clojure.string/includes? file-name ".")
  #_(clojure.string/ends-with? file-name ".edn"))

(comment

  ;(clojure.string/includes? "hellozip" ".")


  )

#_(defn is-template-name [ds-file]
  (not (clojure.string/includes? ds-file ".") )
  )


(defn format-input [base-dir req]
  (as-> req {:keys [connector-config input-file key topic-name ref_name] :as m}
        (if (and connector-config
                 (is-file-name? connector-config)
                 )
          (assoc m :connector-config (str base-dir (clojure.string/trim connector-config)))
          m)
        (if (and input-file
                 (is-file-name? input-file))
          (assoc m :input-file (str base-dir (clojure.string/trim input-file)))
          m)
        (if key
          (assoc m :key (if (sequential? key)
                          (mapv clojure.string/trim key)
                          (clojure.string/trim key)
                          ))
          m)
        (if topic-name
          (assoc m :topic-name (clojure.string/trim topic-name))
          m)
        (if ref_name
          (assoc m :ref_name (clojure.string/trim ref_name))
          m)
        m))


(defn get-template [template-name]
  (if (is-file-name? template-name)
    (r/load-template template-name)
    (let [m @(get (c/get-context) :connector-template-m)]
      (when (or (nil? template-name)
                (clojure.string/blank? template-name))
        (throw (ex-info "connector template name will not be null" {:connector-config-name template-name} )))
      (get m template-name ""))))


(defn get-template-name [template-name]
  (if (is-file-name? template-name)
    (r/get-file-name template-name)
    template-name
    )
  )


(defn as-sink-connector-schema [base-dir v]
  (let [out (if (string? v)
              (fio/read-csv-file v)
              (mapv (fn [req]
                      (zipmap [:connector-config :topic-name :key :ref_name] req)) v))
        xf (comp
             (map (fn [m]
                    ;  (println "--------" m)
                    (if (clojure.string/blank? (get m :key))
                      (assoc m :key nil)
                      m
                      )
                    ))
             (remove (fn [m] (or (nil? (get m :connector-config))
                                 (clojure.string/blank? (get m :connector-config))
                                 )))
             (map (fn [w] (format-input base-dir w)))
             (map (fn [w] #_(format-input base-dir w)
                    (let [template   (get-template (get w :connector-config))
                          template-file-name (get-template-name (get w :connector-config))]
                      (assoc w :connector-config template :connector-config-file-name template-file-name))))
             (map (fn [v]
                    (-> v
                        (update :topic-name (comp clojure.string/trim clojure.string/lower-case))
                        (update :key (fn [v] (when v (clojure.string/trim v)))))))
             (map (fn [v]
                    (if (nil? (get v :key))
                      v
                      (let [k (clojure.string/trim (get v :key))
                            k (clojure.string/split k #" ")]
                        (if (= (count k) 1)
                          (assoc v :key (first k))
                          (assoc v :key k)))))))]
    (into [] xf out)))

(defn- gen-schema-from-entity-one [e]
  ; (  e)
  (let [template-path (get e :connector-config)
        input-file (get e :input-file)
        pk-name (get e :key)
        e-name (get e :topic-name)
        e-name (if (clojure.string/blank? e-name)
                 nil
                 e-name)
        tn (get-template-name template-path)
        t (get-template template-path)
        connector_ref_name (r/get-file-name input-file)]
    {:name               (or e-name connector_ref_name)
     :key                pk-name
     :topic-name        e-name
     :ref_name           connector_ref_name
     :connector-config           t
     :connector-config-file-name tn
     :input-file          input-file
;     :connector_ref_name connector_ref_name
    ; :connector_source   tn
     ;:connector          t

     }))


(defn as-source-connector-schema [base-dir connector-mapping]
  (let [
        out (if (and (string? connector-mapping)
                     (is-file-name? connector-mapping)
                     )
              (fio/read-csv-file connector-mapping)
              (mapv (fn [req]
                      (zipmap [:connector-config :input-file :key :topic-name] req)) connector-mapping))
        ;_ (pritln )
        xf (comp (map (fn [m]
                        (if (or (nil? (get m :key)) (clojure.string/blank? (get m :key)))
                          (assoc m :key nil)
                          m
                          )
                        ))
                 (map (fn [m]
                        (if (:key m)
                          (let [k (clojure.string/trim (:key m))
                                keys (clojure.string/split k #" ")]
                            (if (< 1 (count keys))
                              (assoc m :key keys)
                              m))
                          m)))
                 (remove (fn [m] (or (nil? (get m :connector-config))
                                     (clojure.string/blank? (get m :connector-config))
                                     )))

                 (map (fn [w] (format-input base-dir w)))
                 (map gen-schema-from-entity-one))]
    (into [] xf out)))

