(ns azure.client.ns-repo
  (:require [clojure.tools.reader.edn :as edn]
            [ksql.gen.protocol :as p]
            [azure.client.blob-storage :as bs]
            [clojure.java.io :as io]
            [ksqldb.client :as client]
            [clojure.tools.logging :as log]))


(defrecord BlobNSStore [storage-account storage-key container-name ns-context-m]
  p/NS-Store
  (-get-ns-names [this]
    (-> (bs/blob-service-client storage-account storage-key)
        (bs/blob-list container-name)
        (into (keys @ns-context-m))
        distinct))

  (-get-ns-by-name [this ns-name]
    (if (contains? (into #{} (keys @ns-context-m)) ns-name)
      (get @ns-context-m ns-name)
      (let [ns-set (into #{} (-> (bs/blob-service-client storage-account storage-key)
                                 (bs/blob-list container-name)))]
        (when (contains? ns-set ns-name)
          (let [out (-> (bs/blob-service-client storage-account storage-key)
                        (bs/download container-name ns-name)
                        (edn/read-string)
                        (p/edn-data->context))]
            (swap! ns-context-m (fn [m] (assoc m ns-name out)))
            out)))))

  (-persist-ns [this ns-name ns-v closed?]
    (if closed?
      (swap! ns-context-m (fn [m] (dissoc m ns-name)))
      (swap! ns-context-m (fn [m] (assoc m ns-name ns-v))))

    (let [ns-v (-> (p/context->edn-data ns-v)
                   (pr-str))]
      (-> (bs/blob-service-client storage-account storage-key)
          (bs/upload container-name ns-name ns-v)))

    #_(persist-to-file base-dir ns-name ns-v)
    #_(swap! mapping-context (fn [m] (assoc m ns-name ns-v))))
  (-ns-exits? [this ns-name]
    (let [out-set (-> (into #{} (-> (bs/blob-service-client storage-account storage-key)
                                    (bs/blob-list container-name)))
                      (into (keys @ns-context-m))
                      )]
      (contains? out-set ns-name))))


(defn new-blob-store
  ([storage-account storage-key ]
   (new-blob-store storage-account storage-key  "mdrepo") )
  ([storage-account storage-key container-name ]
   ;(println "--" storage-account "-- " storage-key)
   (let [c (->BlobNSStore storage-account storage-key container-name (atom {}))]
     (p/get-ns-names c)
     c
     )
   )
  )
