goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_40803 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_40803(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_40806 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_40806(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__40152 = coll;
var G__40153 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__40152,G__40153) : shadow.dom.lazy_native_coll_seq.call(null,G__40152,G__40153));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4126__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__40174 = arguments.length;
switch (G__40174) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__40179 = arguments.length;
switch (G__40179) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__40182 = arguments.length;
switch (G__40182) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__40186 = arguments.length;
switch (G__40186) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__40201 = arguments.length;
switch (G__40201) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__40214 = arguments.length;
switch (G__40214) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e40222){if((e40222 instanceof Object)){
var e = e40222;
return console.log("didnt support attachEvent",el,e);
} else {
throw e40222;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__40227 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__40228 = null;
var count__40229 = (0);
var i__40230 = (0);
while(true){
if((i__40230 < count__40229)){
var el = chunk__40228.cljs$core$IIndexed$_nth$arity$2(null,i__40230);
var handler_40862__$1 = ((function (seq__40227,chunk__40228,count__40229,i__40230,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__40227,chunk__40228,count__40229,i__40230,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_40862__$1);


var G__40863 = seq__40227;
var G__40864 = chunk__40228;
var G__40865 = count__40229;
var G__40866 = (i__40230 + (1));
seq__40227 = G__40863;
chunk__40228 = G__40864;
count__40229 = G__40865;
i__40230 = G__40866;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__40227);
if(temp__5720__auto__){
var seq__40227__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__40227__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__40227__$1);
var G__40869 = cljs.core.chunk_rest(seq__40227__$1);
var G__40870 = c__4556__auto__;
var G__40871 = cljs.core.count(c__4556__auto__);
var G__40872 = (0);
seq__40227 = G__40869;
chunk__40228 = G__40870;
count__40229 = G__40871;
i__40230 = G__40872;
continue;
} else {
var el = cljs.core.first(seq__40227__$1);
var handler_40873__$1 = ((function (seq__40227,chunk__40228,count__40229,i__40230,el,seq__40227__$1,temp__5720__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__40227,chunk__40228,count__40229,i__40230,el,seq__40227__$1,temp__5720__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_40873__$1);


var G__40874 = cljs.core.next(seq__40227__$1);
var G__40875 = null;
var G__40876 = (0);
var G__40877 = (0);
seq__40227 = G__40874;
chunk__40228 = G__40875;
count__40229 = G__40876;
i__40230 = G__40877;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__40241 = arguments.length;
switch (G__40241) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__40251 = cljs.core.seq(events);
var chunk__40252 = null;
var count__40253 = (0);
var i__40254 = (0);
while(true){
if((i__40254 < count__40253)){
var vec__40273 = chunk__40252.cljs$core$IIndexed$_nth$arity$2(null,i__40254);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40273,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40273,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__40881 = seq__40251;
var G__40882 = chunk__40252;
var G__40883 = count__40253;
var G__40884 = (i__40254 + (1));
seq__40251 = G__40881;
chunk__40252 = G__40882;
count__40253 = G__40883;
i__40254 = G__40884;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__40251);
if(temp__5720__auto__){
var seq__40251__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__40251__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__40251__$1);
var G__40886 = cljs.core.chunk_rest(seq__40251__$1);
var G__40887 = c__4556__auto__;
var G__40888 = cljs.core.count(c__4556__auto__);
var G__40889 = (0);
seq__40251 = G__40886;
chunk__40252 = G__40887;
count__40253 = G__40888;
i__40254 = G__40889;
continue;
} else {
var vec__40276 = cljs.core.first(seq__40251__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40276,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40276,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__40891 = cljs.core.next(seq__40251__$1);
var G__40892 = null;
var G__40893 = (0);
var G__40894 = (0);
seq__40251 = G__40891;
chunk__40252 = G__40892;
count__40253 = G__40893;
i__40254 = G__40894;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__40279 = cljs.core.seq(styles);
var chunk__40280 = null;
var count__40281 = (0);
var i__40282 = (0);
while(true){
if((i__40282 < count__40281)){
var vec__40294 = chunk__40280.cljs$core$IIndexed$_nth$arity$2(null,i__40282);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40294,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40294,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__40903 = seq__40279;
var G__40904 = chunk__40280;
var G__40905 = count__40281;
var G__40906 = (i__40282 + (1));
seq__40279 = G__40903;
chunk__40280 = G__40904;
count__40281 = G__40905;
i__40282 = G__40906;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__40279);
if(temp__5720__auto__){
var seq__40279__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__40279__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__40279__$1);
var G__40907 = cljs.core.chunk_rest(seq__40279__$1);
var G__40908 = c__4556__auto__;
var G__40909 = cljs.core.count(c__4556__auto__);
var G__40910 = (0);
seq__40279 = G__40907;
chunk__40280 = G__40908;
count__40281 = G__40909;
i__40282 = G__40910;
continue;
} else {
var vec__40297 = cljs.core.first(seq__40279__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40297,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40297,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__40916 = cljs.core.next(seq__40279__$1);
var G__40917 = null;
var G__40918 = (0);
var G__40919 = (0);
seq__40279 = G__40916;
chunk__40280 = G__40917;
count__40281 = G__40918;
i__40282 = G__40919;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__40300_40920 = key;
var G__40300_40921__$1 = (((G__40300_40920 instanceof cljs.core.Keyword))?G__40300_40920.fqn:null);
switch (G__40300_40921__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_40926 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__4126__auto__ = goog.string.startsWith(ks_40926,"data-");
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return goog.string.startsWith(ks_40926,"aria-");
}
})())){
el.setAttribute(ks_40926,value);
} else {
(el[ks_40926] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__40302){
var map__40303 = p__40302;
var map__40303__$1 = (((((!((map__40303 == null))))?(((((map__40303.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40303.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40303):map__40303);
var props = map__40303__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40303__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__40306 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40306,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40306,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40306,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__40309 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__40309,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__40309;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__40312 = arguments.length;
switch (G__40312) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5720__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5720__auto__)){
var n = temp__5720__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5720__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5720__auto__)){
var n = temp__5720__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__40316){
var vec__40317 = p__40316;
var seq__40318 = cljs.core.seq(vec__40317);
var first__40319 = cljs.core.first(seq__40318);
var seq__40318__$1 = cljs.core.next(seq__40318);
var nn = first__40319;
var first__40319__$1 = cljs.core.first(seq__40318__$1);
var seq__40318__$2 = cljs.core.next(seq__40318__$1);
var np = first__40319__$1;
var nc = seq__40318__$2;
var node = vec__40317;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__40320 = nn;
var G__40321 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__40320,G__40321) : create_fn.call(null,G__40320,G__40321));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__40322 = nn;
var G__40323 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__40322,G__40323) : create_fn.call(null,G__40322,G__40323));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__40324 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40324,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40324,(1),null);
var seq__40327_40950 = cljs.core.seq(node_children);
var chunk__40328_40951 = null;
var count__40329_40952 = (0);
var i__40330_40953 = (0);
while(true){
if((i__40330_40953 < count__40329_40952)){
var child_struct_40955 = chunk__40328_40951.cljs$core$IIndexed$_nth$arity$2(null,i__40330_40953);
var children_40956 = shadow.dom.dom_node(child_struct_40955);
if(cljs.core.seq_QMARK_(children_40956)){
var seq__40357_40957 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_40956));
var chunk__40359_40958 = null;
var count__40360_40959 = (0);
var i__40361_40960 = (0);
while(true){
if((i__40361_40960 < count__40360_40959)){
var child_40964 = chunk__40359_40958.cljs$core$IIndexed$_nth$arity$2(null,i__40361_40960);
if(cljs.core.truth_(child_40964)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_40964);


var G__40965 = seq__40357_40957;
var G__40966 = chunk__40359_40958;
var G__40967 = count__40360_40959;
var G__40968 = (i__40361_40960 + (1));
seq__40357_40957 = G__40965;
chunk__40359_40958 = G__40966;
count__40360_40959 = G__40967;
i__40361_40960 = G__40968;
continue;
} else {
var G__40969 = seq__40357_40957;
var G__40970 = chunk__40359_40958;
var G__40971 = count__40360_40959;
var G__40972 = (i__40361_40960 + (1));
seq__40357_40957 = G__40969;
chunk__40359_40958 = G__40970;
count__40360_40959 = G__40971;
i__40361_40960 = G__40972;
continue;
}
} else {
var temp__5720__auto___40975 = cljs.core.seq(seq__40357_40957);
if(temp__5720__auto___40975){
var seq__40357_40977__$1 = temp__5720__auto___40975;
if(cljs.core.chunked_seq_QMARK_(seq__40357_40977__$1)){
var c__4556__auto___40978 = cljs.core.chunk_first(seq__40357_40977__$1);
var G__40979 = cljs.core.chunk_rest(seq__40357_40977__$1);
var G__40980 = c__4556__auto___40978;
var G__40981 = cljs.core.count(c__4556__auto___40978);
var G__40982 = (0);
seq__40357_40957 = G__40979;
chunk__40359_40958 = G__40980;
count__40360_40959 = G__40981;
i__40361_40960 = G__40982;
continue;
} else {
var child_40983 = cljs.core.first(seq__40357_40977__$1);
if(cljs.core.truth_(child_40983)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_40983);


var G__40984 = cljs.core.next(seq__40357_40977__$1);
var G__40985 = null;
var G__40986 = (0);
var G__40987 = (0);
seq__40357_40957 = G__40984;
chunk__40359_40958 = G__40985;
count__40360_40959 = G__40986;
i__40361_40960 = G__40987;
continue;
} else {
var G__40991 = cljs.core.next(seq__40357_40977__$1);
var G__40992 = null;
var G__40993 = (0);
var G__40994 = (0);
seq__40357_40957 = G__40991;
chunk__40359_40958 = G__40992;
count__40360_40959 = G__40993;
i__40361_40960 = G__40994;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_40956);
}


var G__40997 = seq__40327_40950;
var G__40998 = chunk__40328_40951;
var G__40999 = count__40329_40952;
var G__41000 = (i__40330_40953 + (1));
seq__40327_40950 = G__40997;
chunk__40328_40951 = G__40998;
count__40329_40952 = G__40999;
i__40330_40953 = G__41000;
continue;
} else {
var temp__5720__auto___41001 = cljs.core.seq(seq__40327_40950);
if(temp__5720__auto___41001){
var seq__40327_41002__$1 = temp__5720__auto___41001;
if(cljs.core.chunked_seq_QMARK_(seq__40327_41002__$1)){
var c__4556__auto___41003 = cljs.core.chunk_first(seq__40327_41002__$1);
var G__41004 = cljs.core.chunk_rest(seq__40327_41002__$1);
var G__41005 = c__4556__auto___41003;
var G__41006 = cljs.core.count(c__4556__auto___41003);
var G__41007 = (0);
seq__40327_40950 = G__41004;
chunk__40328_40951 = G__41005;
count__40329_40952 = G__41006;
i__40330_40953 = G__41007;
continue;
} else {
var child_struct_41009 = cljs.core.first(seq__40327_41002__$1);
var children_41011 = shadow.dom.dom_node(child_struct_41009);
if(cljs.core.seq_QMARK_(children_41011)){
var seq__40378_41012 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_41011));
var chunk__40380_41013 = null;
var count__40381_41014 = (0);
var i__40382_41015 = (0);
while(true){
if((i__40382_41015 < count__40381_41014)){
var child_41016 = chunk__40380_41013.cljs$core$IIndexed$_nth$arity$2(null,i__40382_41015);
if(cljs.core.truth_(child_41016)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_41016);


var G__41017 = seq__40378_41012;
var G__41018 = chunk__40380_41013;
var G__41019 = count__40381_41014;
var G__41020 = (i__40382_41015 + (1));
seq__40378_41012 = G__41017;
chunk__40380_41013 = G__41018;
count__40381_41014 = G__41019;
i__40382_41015 = G__41020;
continue;
} else {
var G__41024 = seq__40378_41012;
var G__41025 = chunk__40380_41013;
var G__41026 = count__40381_41014;
var G__41027 = (i__40382_41015 + (1));
seq__40378_41012 = G__41024;
chunk__40380_41013 = G__41025;
count__40381_41014 = G__41026;
i__40382_41015 = G__41027;
continue;
}
} else {
var temp__5720__auto___41028__$1 = cljs.core.seq(seq__40378_41012);
if(temp__5720__auto___41028__$1){
var seq__40378_41029__$1 = temp__5720__auto___41028__$1;
if(cljs.core.chunked_seq_QMARK_(seq__40378_41029__$1)){
var c__4556__auto___41030 = cljs.core.chunk_first(seq__40378_41029__$1);
var G__41031 = cljs.core.chunk_rest(seq__40378_41029__$1);
var G__41032 = c__4556__auto___41030;
var G__41033 = cljs.core.count(c__4556__auto___41030);
var G__41034 = (0);
seq__40378_41012 = G__41031;
chunk__40380_41013 = G__41032;
count__40381_41014 = G__41033;
i__40382_41015 = G__41034;
continue;
} else {
var child_41035 = cljs.core.first(seq__40378_41029__$1);
if(cljs.core.truth_(child_41035)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_41035);


var G__41036 = cljs.core.next(seq__40378_41029__$1);
var G__41037 = null;
var G__41038 = (0);
var G__41039 = (0);
seq__40378_41012 = G__41036;
chunk__40380_41013 = G__41037;
count__40381_41014 = G__41038;
i__40382_41015 = G__41039;
continue;
} else {
var G__41040 = cljs.core.next(seq__40378_41029__$1);
var G__41041 = null;
var G__41042 = (0);
var G__41043 = (0);
seq__40378_41012 = G__41040;
chunk__40380_41013 = G__41041;
count__40381_41014 = G__41042;
i__40382_41015 = G__41043;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_41011);
}


var G__41044 = cljs.core.next(seq__40327_41002__$1);
var G__41045 = null;
var G__41046 = (0);
var G__41047 = (0);
seq__40327_40950 = G__41044;
chunk__40328_40951 = G__41045;
count__40329_40952 = G__41046;
i__40330_40953 = G__41047;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__40408 = cljs.core.seq(node);
var chunk__40409 = null;
var count__40410 = (0);
var i__40411 = (0);
while(true){
if((i__40411 < count__40410)){
var n = chunk__40409.cljs$core$IIndexed$_nth$arity$2(null,i__40411);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__41050 = seq__40408;
var G__41051 = chunk__40409;
var G__41052 = count__40410;
var G__41053 = (i__40411 + (1));
seq__40408 = G__41050;
chunk__40409 = G__41051;
count__40410 = G__41052;
i__40411 = G__41053;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__40408);
if(temp__5720__auto__){
var seq__40408__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__40408__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__40408__$1);
var G__41054 = cljs.core.chunk_rest(seq__40408__$1);
var G__41055 = c__4556__auto__;
var G__41056 = cljs.core.count(c__4556__auto__);
var G__41057 = (0);
seq__40408 = G__41054;
chunk__40409 = G__41055;
count__40410 = G__41056;
i__40411 = G__41057;
continue;
} else {
var n = cljs.core.first(seq__40408__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__41058 = cljs.core.next(seq__40408__$1);
var G__41059 = null;
var G__41060 = (0);
var G__41061 = (0);
seq__40408 = G__41058;
chunk__40409 = G__41059;
count__40410 = G__41060;
i__40411 = G__41061;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__40419 = arguments.length;
switch (G__40419) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__40427 = arguments.length;
switch (G__40427) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__40440 = arguments.length;
switch (G__40440) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4126__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41088 = arguments.length;
var i__4737__auto___41089 = (0);
while(true){
if((i__4737__auto___41089 < len__4736__auto___41088)){
args__4742__auto__.push((arguments[i__4737__auto___41089]));

var G__41090 = (i__4737__auto___41089 + (1));
i__4737__auto___41089 = G__41090;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__40459_41096 = cljs.core.seq(nodes);
var chunk__40460_41097 = null;
var count__40461_41098 = (0);
var i__40462_41099 = (0);
while(true){
if((i__40462_41099 < count__40461_41098)){
var node_41100 = chunk__40460_41097.cljs$core$IIndexed$_nth$arity$2(null,i__40462_41099);
fragment.appendChild(shadow.dom._to_dom(node_41100));


var G__41101 = seq__40459_41096;
var G__41102 = chunk__40460_41097;
var G__41103 = count__40461_41098;
var G__41104 = (i__40462_41099 + (1));
seq__40459_41096 = G__41101;
chunk__40460_41097 = G__41102;
count__40461_41098 = G__41103;
i__40462_41099 = G__41104;
continue;
} else {
var temp__5720__auto___41107 = cljs.core.seq(seq__40459_41096);
if(temp__5720__auto___41107){
var seq__40459_41108__$1 = temp__5720__auto___41107;
if(cljs.core.chunked_seq_QMARK_(seq__40459_41108__$1)){
var c__4556__auto___41109 = cljs.core.chunk_first(seq__40459_41108__$1);
var G__41110 = cljs.core.chunk_rest(seq__40459_41108__$1);
var G__41111 = c__4556__auto___41109;
var G__41112 = cljs.core.count(c__4556__auto___41109);
var G__41113 = (0);
seq__40459_41096 = G__41110;
chunk__40460_41097 = G__41111;
count__40461_41098 = G__41112;
i__40462_41099 = G__41113;
continue;
} else {
var node_41114 = cljs.core.first(seq__40459_41108__$1);
fragment.appendChild(shadow.dom._to_dom(node_41114));


var G__41119 = cljs.core.next(seq__40459_41108__$1);
var G__41120 = null;
var G__41121 = (0);
var G__41122 = (0);
seq__40459_41096 = G__41119;
chunk__40460_41097 = G__41120;
count__40461_41098 = G__41121;
i__40462_41099 = G__41122;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq40450){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40450));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__40469_41125 = cljs.core.seq(scripts);
var chunk__40470_41126 = null;
var count__40471_41127 = (0);
var i__40472_41128 = (0);
while(true){
if((i__40472_41128 < count__40471_41127)){
var vec__40480_41129 = chunk__40470_41126.cljs$core$IIndexed$_nth$arity$2(null,i__40472_41128);
var script_tag_41130 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40480_41129,(0),null);
var script_body_41131 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40480_41129,(1),null);
eval(script_body_41131);


var G__41132 = seq__40469_41125;
var G__41133 = chunk__40470_41126;
var G__41134 = count__40471_41127;
var G__41135 = (i__40472_41128 + (1));
seq__40469_41125 = G__41132;
chunk__40470_41126 = G__41133;
count__40471_41127 = G__41134;
i__40472_41128 = G__41135;
continue;
} else {
var temp__5720__auto___41136 = cljs.core.seq(seq__40469_41125);
if(temp__5720__auto___41136){
var seq__40469_41137__$1 = temp__5720__auto___41136;
if(cljs.core.chunked_seq_QMARK_(seq__40469_41137__$1)){
var c__4556__auto___41138 = cljs.core.chunk_first(seq__40469_41137__$1);
var G__41139 = cljs.core.chunk_rest(seq__40469_41137__$1);
var G__41140 = c__4556__auto___41138;
var G__41141 = cljs.core.count(c__4556__auto___41138);
var G__41142 = (0);
seq__40469_41125 = G__41139;
chunk__40470_41126 = G__41140;
count__40471_41127 = G__41141;
i__40472_41128 = G__41142;
continue;
} else {
var vec__40487_41148 = cljs.core.first(seq__40469_41137__$1);
var script_tag_41149 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40487_41148,(0),null);
var script_body_41150 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40487_41148,(1),null);
eval(script_body_41150);


var G__41152 = cljs.core.next(seq__40469_41137__$1);
var G__41153 = null;
var G__41154 = (0);
var G__41155 = (0);
seq__40469_41125 = G__41152;
chunk__40470_41126 = G__41153;
count__40471_41127 = G__41154;
i__40472_41128 = G__41155;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__40490){
var vec__40491 = p__40490;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40491,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40491,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__40507 = arguments.length;
switch (G__40507) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__40525 = cljs.core.seq(style_keys);
var chunk__40526 = null;
var count__40527 = (0);
var i__40528 = (0);
while(true){
if((i__40528 < count__40527)){
var it = chunk__40526.cljs$core$IIndexed$_nth$arity$2(null,i__40528);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__41170 = seq__40525;
var G__41171 = chunk__40526;
var G__41172 = count__40527;
var G__41173 = (i__40528 + (1));
seq__40525 = G__41170;
chunk__40526 = G__41171;
count__40527 = G__41172;
i__40528 = G__41173;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__40525);
if(temp__5720__auto__){
var seq__40525__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__40525__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__40525__$1);
var G__41179 = cljs.core.chunk_rest(seq__40525__$1);
var G__41180 = c__4556__auto__;
var G__41181 = cljs.core.count(c__4556__auto__);
var G__41182 = (0);
seq__40525 = G__41179;
chunk__40526 = G__41180;
count__40527 = G__41181;
i__40528 = G__41182;
continue;
} else {
var it = cljs.core.first(seq__40525__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__41183 = cljs.core.next(seq__40525__$1);
var G__41184 = null;
var G__41185 = (0);
var G__41186 = (0);
seq__40525 = G__41183;
chunk__40526 = G__41184;
count__40527 = G__41185;
i__40528 = G__41186;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k40530,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__40534 = k40530;
var G__40534__$1 = (((G__40534 instanceof cljs.core.Keyword))?G__40534.fqn:null);
switch (G__40534__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k40530,else__4383__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__40538){
var vec__40539 = p__40538;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40539,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40539,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__40529){
var self__ = this;
var G__40529__$1 = this;
return (new cljs.core.RecordIter((0),G__40529__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this40531,other40532){
var self__ = this;
var this40531__$1 = this;
return (((!((other40532 == null)))) && ((this40531__$1.constructor === other40532.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40531__$1.x,other40532.x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40531__$1.y,other40532.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40531__$1.__extmap,other40532.__extmap)));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__40529){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__40543 = cljs.core.keyword_identical_QMARK_;
var expr__40544 = k__4388__auto__;
if(cljs.core.truth_((pred__40543.cljs$core$IFn$_invoke$arity$2 ? pred__40543.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__40544) : pred__40543.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__40544)))){
return (new shadow.dom.Coordinate(G__40529,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__40543.cljs$core$IFn$_invoke$arity$2 ? pred__40543.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__40544) : pred__40543.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__40544)))){
return (new shadow.dom.Coordinate(self__.x,G__40529,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__40529),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__40529){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__40529,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__40533){
var extmap__4419__auto__ = (function (){var G__40566 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__40533,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__40533)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__40566);
} else {
return G__40566;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__40533),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__40533),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k40569,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__40576 = k40569;
var G__40576__$1 = (((G__40576 instanceof cljs.core.Keyword))?G__40576.fqn:null);
switch (G__40576__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k40569,else__4383__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__40580){
var vec__40581 = p__40580;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40581,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40581,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Size{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__40568){
var self__ = this;
var G__40568__$1 = this;
return (new cljs.core.RecordIter((0),G__40568__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this40570,other40571){
var self__ = this;
var this40570__$1 = this;
return (((!((other40571 == null)))) && ((this40570__$1.constructor === other40571.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40570__$1.w,other40571.w)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40570__$1.h,other40571.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40570__$1.__extmap,other40571.__extmap)));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__40568){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__40591 = cljs.core.keyword_identical_QMARK_;
var expr__40592 = k__4388__auto__;
if(cljs.core.truth_((pred__40591.cljs$core$IFn$_invoke$arity$2 ? pred__40591.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__40592) : pred__40591.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__40592)))){
return (new shadow.dom.Size(G__40568,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__40591.cljs$core$IFn$_invoke$arity$2 ? pred__40591.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__40592) : pred__40591.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__40592)))){
return (new shadow.dom.Size(self__.w,G__40568,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__40568),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__40568){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__40568,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__40575){
var extmap__4419__auto__ = (function (){var G__40603 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__40575,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__40575)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__40603);
} else {
return G__40603;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__40575),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__40575),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4610__auto__ = opts;
var l__4611__auto__ = a__4610__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4611__auto__)){
var G__41239 = (i + (1));
var G__41240 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__41239;
ret = G__41240;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__40621){
var vec__40623 = p__40621;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40623,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40623,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__40630 = arguments.length;
switch (G__40630) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5718__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5718__auto__)){
var child = temp__5718__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__41256 = ps;
var G__41257 = (i + (1));
el__$1 = G__41256;
i = G__41257;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__40648 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40648,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40648,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40648,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__40651_41265 = cljs.core.seq(props);
var chunk__40652_41266 = null;
var count__40653_41267 = (0);
var i__40654_41268 = (0);
while(true){
if((i__40654_41268 < count__40653_41267)){
var vec__40664_41269 = chunk__40652_41266.cljs$core$IIndexed$_nth$arity$2(null,i__40654_41268);
var k_41270 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40664_41269,(0),null);
var v_41271 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40664_41269,(1),null);
el.setAttributeNS((function (){var temp__5720__auto__ = cljs.core.namespace(k_41270);
if(cljs.core.truth_(temp__5720__auto__)){
var ns = temp__5720__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_41270),v_41271);


var G__41277 = seq__40651_41265;
var G__41278 = chunk__40652_41266;
var G__41279 = count__40653_41267;
var G__41280 = (i__40654_41268 + (1));
seq__40651_41265 = G__41277;
chunk__40652_41266 = G__41278;
count__40653_41267 = G__41279;
i__40654_41268 = G__41280;
continue;
} else {
var temp__5720__auto___41283 = cljs.core.seq(seq__40651_41265);
if(temp__5720__auto___41283){
var seq__40651_41284__$1 = temp__5720__auto___41283;
if(cljs.core.chunked_seq_QMARK_(seq__40651_41284__$1)){
var c__4556__auto___41285 = cljs.core.chunk_first(seq__40651_41284__$1);
var G__41286 = cljs.core.chunk_rest(seq__40651_41284__$1);
var G__41287 = c__4556__auto___41285;
var G__41288 = cljs.core.count(c__4556__auto___41285);
var G__41289 = (0);
seq__40651_41265 = G__41286;
chunk__40652_41266 = G__41287;
count__40653_41267 = G__41288;
i__40654_41268 = G__41289;
continue;
} else {
var vec__40667_41290 = cljs.core.first(seq__40651_41284__$1);
var k_41291 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40667_41290,(0),null);
var v_41292 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40667_41290,(1),null);
el.setAttributeNS((function (){var temp__5720__auto____$1 = cljs.core.namespace(k_41291);
if(cljs.core.truth_(temp__5720__auto____$1)){
var ns = temp__5720__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_41291),v_41292);


var G__41294 = cljs.core.next(seq__40651_41284__$1);
var G__41295 = null;
var G__41296 = (0);
var G__41297 = (0);
seq__40651_41265 = G__41294;
chunk__40652_41266 = G__41295;
count__40653_41267 = G__41296;
i__40654_41268 = G__41297;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__40671 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40671,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40671,(1),null);
var seq__40674_41304 = cljs.core.seq(node_children);
var chunk__40676_41305 = null;
var count__40677_41306 = (0);
var i__40678_41307 = (0);
while(true){
if((i__40678_41307 < count__40677_41306)){
var child_struct_41308 = chunk__40676_41305.cljs$core$IIndexed$_nth$arity$2(null,i__40678_41307);
if((!((child_struct_41308 == null)))){
if(typeof child_struct_41308 === 'string'){
var text_41309 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_41309),child_struct_41308].join(''));
} else {
var children_41310 = shadow.dom.svg_node(child_struct_41308);
if(cljs.core.seq_QMARK_(children_41310)){
var seq__40710_41313 = cljs.core.seq(children_41310);
var chunk__40712_41314 = null;
var count__40713_41315 = (0);
var i__40714_41316 = (0);
while(true){
if((i__40714_41316 < count__40713_41315)){
var child_41318 = chunk__40712_41314.cljs$core$IIndexed$_nth$arity$2(null,i__40714_41316);
if(cljs.core.truth_(child_41318)){
node.appendChild(child_41318);


var G__41319 = seq__40710_41313;
var G__41320 = chunk__40712_41314;
var G__41321 = count__40713_41315;
var G__41322 = (i__40714_41316 + (1));
seq__40710_41313 = G__41319;
chunk__40712_41314 = G__41320;
count__40713_41315 = G__41321;
i__40714_41316 = G__41322;
continue;
} else {
var G__41323 = seq__40710_41313;
var G__41324 = chunk__40712_41314;
var G__41325 = count__40713_41315;
var G__41326 = (i__40714_41316 + (1));
seq__40710_41313 = G__41323;
chunk__40712_41314 = G__41324;
count__40713_41315 = G__41325;
i__40714_41316 = G__41326;
continue;
}
} else {
var temp__5720__auto___41327 = cljs.core.seq(seq__40710_41313);
if(temp__5720__auto___41327){
var seq__40710_41328__$1 = temp__5720__auto___41327;
if(cljs.core.chunked_seq_QMARK_(seq__40710_41328__$1)){
var c__4556__auto___41331 = cljs.core.chunk_first(seq__40710_41328__$1);
var G__41332 = cljs.core.chunk_rest(seq__40710_41328__$1);
var G__41333 = c__4556__auto___41331;
var G__41334 = cljs.core.count(c__4556__auto___41331);
var G__41335 = (0);
seq__40710_41313 = G__41332;
chunk__40712_41314 = G__41333;
count__40713_41315 = G__41334;
i__40714_41316 = G__41335;
continue;
} else {
var child_41339 = cljs.core.first(seq__40710_41328__$1);
if(cljs.core.truth_(child_41339)){
node.appendChild(child_41339);


var G__41340 = cljs.core.next(seq__40710_41328__$1);
var G__41341 = null;
var G__41342 = (0);
var G__41343 = (0);
seq__40710_41313 = G__41340;
chunk__40712_41314 = G__41341;
count__40713_41315 = G__41342;
i__40714_41316 = G__41343;
continue;
} else {
var G__41344 = cljs.core.next(seq__40710_41328__$1);
var G__41345 = null;
var G__41346 = (0);
var G__41347 = (0);
seq__40710_41313 = G__41344;
chunk__40712_41314 = G__41345;
count__40713_41315 = G__41346;
i__40714_41316 = G__41347;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_41310);
}
}


var G__41348 = seq__40674_41304;
var G__41349 = chunk__40676_41305;
var G__41350 = count__40677_41306;
var G__41351 = (i__40678_41307 + (1));
seq__40674_41304 = G__41348;
chunk__40676_41305 = G__41349;
count__40677_41306 = G__41350;
i__40678_41307 = G__41351;
continue;
} else {
var G__41352 = seq__40674_41304;
var G__41353 = chunk__40676_41305;
var G__41354 = count__40677_41306;
var G__41355 = (i__40678_41307 + (1));
seq__40674_41304 = G__41352;
chunk__40676_41305 = G__41353;
count__40677_41306 = G__41354;
i__40678_41307 = G__41355;
continue;
}
} else {
var temp__5720__auto___41356 = cljs.core.seq(seq__40674_41304);
if(temp__5720__auto___41356){
var seq__40674_41357__$1 = temp__5720__auto___41356;
if(cljs.core.chunked_seq_QMARK_(seq__40674_41357__$1)){
var c__4556__auto___41358 = cljs.core.chunk_first(seq__40674_41357__$1);
var G__41359 = cljs.core.chunk_rest(seq__40674_41357__$1);
var G__41360 = c__4556__auto___41358;
var G__41361 = cljs.core.count(c__4556__auto___41358);
var G__41362 = (0);
seq__40674_41304 = G__41359;
chunk__40676_41305 = G__41360;
count__40677_41306 = G__41361;
i__40678_41307 = G__41362;
continue;
} else {
var child_struct_41363 = cljs.core.first(seq__40674_41357__$1);
if((!((child_struct_41363 == null)))){
if(typeof child_struct_41363 === 'string'){
var text_41364 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_41364),child_struct_41363].join(''));
} else {
var children_41365 = shadow.dom.svg_node(child_struct_41363);
if(cljs.core.seq_QMARK_(children_41365)){
var seq__40724_41367 = cljs.core.seq(children_41365);
var chunk__40726_41368 = null;
var count__40727_41369 = (0);
var i__40728_41370 = (0);
while(true){
if((i__40728_41370 < count__40727_41369)){
var child_41372 = chunk__40726_41368.cljs$core$IIndexed$_nth$arity$2(null,i__40728_41370);
if(cljs.core.truth_(child_41372)){
node.appendChild(child_41372);


var G__41373 = seq__40724_41367;
var G__41374 = chunk__40726_41368;
var G__41375 = count__40727_41369;
var G__41376 = (i__40728_41370 + (1));
seq__40724_41367 = G__41373;
chunk__40726_41368 = G__41374;
count__40727_41369 = G__41375;
i__40728_41370 = G__41376;
continue;
} else {
var G__41377 = seq__40724_41367;
var G__41378 = chunk__40726_41368;
var G__41379 = count__40727_41369;
var G__41380 = (i__40728_41370 + (1));
seq__40724_41367 = G__41377;
chunk__40726_41368 = G__41378;
count__40727_41369 = G__41379;
i__40728_41370 = G__41380;
continue;
}
} else {
var temp__5720__auto___41381__$1 = cljs.core.seq(seq__40724_41367);
if(temp__5720__auto___41381__$1){
var seq__40724_41382__$1 = temp__5720__auto___41381__$1;
if(cljs.core.chunked_seq_QMARK_(seq__40724_41382__$1)){
var c__4556__auto___41383 = cljs.core.chunk_first(seq__40724_41382__$1);
var G__41385 = cljs.core.chunk_rest(seq__40724_41382__$1);
var G__41386 = c__4556__auto___41383;
var G__41387 = cljs.core.count(c__4556__auto___41383);
var G__41388 = (0);
seq__40724_41367 = G__41385;
chunk__40726_41368 = G__41386;
count__40727_41369 = G__41387;
i__40728_41370 = G__41388;
continue;
} else {
var child_41390 = cljs.core.first(seq__40724_41382__$1);
if(cljs.core.truth_(child_41390)){
node.appendChild(child_41390);


var G__41391 = cljs.core.next(seq__40724_41382__$1);
var G__41392 = null;
var G__41393 = (0);
var G__41394 = (0);
seq__40724_41367 = G__41391;
chunk__40726_41368 = G__41392;
count__40727_41369 = G__41393;
i__40728_41370 = G__41394;
continue;
} else {
var G__41395 = cljs.core.next(seq__40724_41382__$1);
var G__41396 = null;
var G__41397 = (0);
var G__41398 = (0);
seq__40724_41367 = G__41395;
chunk__40726_41368 = G__41396;
count__40727_41369 = G__41397;
i__40728_41370 = G__41398;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_41365);
}
}


var G__41399 = cljs.core.next(seq__40674_41357__$1);
var G__41400 = null;
var G__41401 = (0);
var G__41402 = (0);
seq__40674_41304 = G__41399;
chunk__40676_41305 = G__41400;
count__40677_41306 = G__41401;
i__40678_41307 = G__41402;
continue;
} else {
var G__41403 = cljs.core.next(seq__40674_41357__$1);
var G__41404 = null;
var G__41405 = (0);
var G__41406 = (0);
seq__40674_41304 = G__41403;
chunk__40676_41305 = G__41404;
count__40677_41306 = G__41405;
i__40678_41307 = G__41406;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

goog.object.set(shadow.dom._to_svg,"string",(function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

goog.object.set(shadow.dom.SVGElement,"null",true);

goog.object.set(shadow.dom._to_svg,"null",(function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41408 = arguments.length;
var i__4737__auto___41409 = (0);
while(true){
if((i__4737__auto___41409 < len__4736__auto___41408)){
args__4742__auto__.push((arguments[i__4737__auto___41409]));

var G__41411 = (i__4737__auto___41409 + (1));
i__4737__auto___41409 = G__41411;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq40738){
var G__40739 = cljs.core.first(seq40738);
var seq40738__$1 = cljs.core.next(seq40738);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__40739,seq40738__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__40750 = arguments.length;
switch (G__40750) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__4115__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4115__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4115__auto__;
}
})())){
var c__39997__auto___41417 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__39998__auto__ = (function (){var switch__39959__auto__ = (function (state_40771){
var state_val_40772 = (state_40771[(1)]);
if((state_val_40772 === (1))){
var state_40771__$1 = state_40771;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40771__$1,(2),once_or_cleanup);
} else {
if((state_val_40772 === (2))){
var inst_40765 = (state_40771[(2)]);
var inst_40766 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_40771__$1 = (function (){var statearr_40774 = state_40771;
(statearr_40774[(7)] = inst_40765);

return statearr_40774;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_40771__$1,inst_40766);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__39960__auto__ = null;
var shadow$dom$state_machine__39960__auto____0 = (function (){
var statearr_40780 = [null,null,null,null,null,null,null,null];
(statearr_40780[(0)] = shadow$dom$state_machine__39960__auto__);

(statearr_40780[(1)] = (1));

return statearr_40780;
});
var shadow$dom$state_machine__39960__auto____1 = (function (state_40771){
while(true){
var ret_value__39961__auto__ = (function (){try{while(true){
var result__39962__auto__ = switch__39959__auto__(state_40771);
if(cljs.core.keyword_identical_QMARK_(result__39962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__39962__auto__;
}
break;
}
}catch (e40781){if((e40781 instanceof Object)){
var ex__39963__auto__ = e40781;
var statearr_40782_41431 = state_40771;
(statearr_40782_41431[(5)] = ex__39963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_40771);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40781;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__39961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41435 = state_40771;
state_40771 = G__41435;
continue;
} else {
return ret_value__39961__auto__;
}
break;
}
});
shadow$dom$state_machine__39960__auto__ = function(state_40771){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__39960__auto____0.call(this);
case 1:
return shadow$dom$state_machine__39960__auto____1.call(this,state_40771);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__39960__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__39960__auto____0;
shadow$dom$state_machine__39960__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__39960__auto____1;
return shadow$dom$state_machine__39960__auto__;
})()
})();
var state__39999__auto__ = (function (){var statearr_40786 = f__39998__auto__();
(statearr_40786[(6)] = c__39997__auto___41417);

return statearr_40786;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__39999__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
