(ns {{name}}.core
  (:use [cljs.core.async :only [chan put! close!]])
  (:require [cljs.reader :as reader]
            [d3c.core :as d3c]
            [goog.net.XhrIo :as xhr])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(defn fetch [parser path]
  (let [out (chan)]
    (xhr/send path
              (fn [event]
                (put! out (-> event .-target .getResponseText parser))
                (close! out)))
    out))

(def fetch-edn (partial fetch reader/read-string))

(def fetch-json (partial fetch #(.parse js/JSON %)))
