/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.httpkit.HeaderMap;
import org.httpkit.HttpUtils;
import org.httpkit.LineTooLargeException;
import org.httpkit.ProtocolException;
import org.httpkit.RequestTooLargeException;
import org.httpkit.server.AsyncChannel;
import org.httpkit.server.Frame;
import org.httpkit.server.HttpAtta;
import org.httpkit.server.HttpRequest;
import org.httpkit.server.IHandler;
import org.httpkit.server.PendingKey;
import org.httpkit.server.RespCallback;
import org.httpkit.server.ServerAtta;
import org.httpkit.server.WsAtta;

public class HttpServer
implements Runnable {
    static final String THREAD_NAME = "server-loop";
    private final IHandler handler;
    private final int maxBody;
    private final int maxLine;
    private final int maxWs;
    private final Selector selector;
    private final ServerSocketChannel serverChannel;
    private Thread serverThread;
    private final ConcurrentLinkedQueue<PendingKey> pending = new ConcurrentLinkedQueue();
    private final ByteBuffer buffer = ByteBuffer.allocateDirect(65536);

    public HttpServer(String ip, int port, IHandler handler, int maxBody, int maxLine, int maxWs) throws IOException {
        this.handler = handler;
        this.maxLine = maxLine;
        this.maxBody = maxBody;
        this.maxWs = maxWs;
        this.selector = Selector.open();
        this.serverChannel = ServerSocketChannel.open();
        this.serverChannel.configureBlocking(false);
        this.serverChannel.socket().bind(new InetSocketAddress(ip, port));
        this.serverChannel.register(this.selector, 16);
    }

    void accept(SelectionKey key) {
        ServerSocketChannel ch = (ServerSocketChannel)key.channel();
        try {
            SocketChannel s;
            while ((s = ch.accept()) != null) {
                s.configureBlocking(false);
                HttpAtta atta = new HttpAtta(this.maxBody, this.maxLine);
                SelectionKey k = s.register(this.selector, 1, atta);
                atta.channel = new AsyncChannel(k, this);
            }
        }
        catch (Exception e) {
            HttpUtils.printError("accept incoming request", e);
        }
    }

    private void closeKey(SelectionKey key, int status) {
        try {
            key.channel().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ServerAtta att = (ServerAtta)key.attachment();
        if (att instanceof HttpAtta) {
            this.handler.clientClose(att.channel, -1);
        } else if (att != null) {
            this.handler.clientClose(att.channel, status);
        }
    }

    private void decodeHttp(HttpAtta atta, SelectionKey key, SocketChannel ch) {
        try {
            do {
                AsyncChannel channel = atta.channel;
                HttpRequest request = atta.decoder.decode(this.buffer);
                if (request == null) continue;
                channel.reset(request);
                if (request.isWebSocket) {
                    key.attach(new WsAtta(channel, this.maxWs));
                } else {
                    atta.keepalive = request.isKeepAlive;
                }
                request.channel = channel;
                request.remoteAddr = (InetSocketAddress)ch.socket().getRemoteSocketAddress();
                this.handler.handle(request, new RespCallback(key, this));
                atta.decoder.reset();
            } while (this.buffer.hasRemaining());
        }
        catch (ProtocolException e) {
            this.closeKey(key, -1);
        }
        catch (RequestTooLargeException e) {
            atta.keepalive = false;
            this.tryWrite(key, HttpUtils.HttpEncode(413, new HeaderMap(), e.getMessage()));
        }
        catch (LineTooLargeException e) {
            atta.keepalive = false;
            this.tryWrite(key, HttpUtils.HttpEncode(414, new HeaderMap(), e.getMessage()));
        }
    }

    private void decodeWs(WsAtta atta, SelectionKey key) {
        try {
            do {
                Frame frame;
                if ((frame = atta.decoder.decode(this.buffer)) instanceof Frame.TextFrame || frame instanceof Frame.BinaryFrame) {
                    this.handler.handle(atta.channel, frame);
                    atta.decoder.reset();
                    continue;
                }
                if (frame instanceof Frame.PingFrame) {
                    atta.decoder.reset();
                    this.tryWrite(key, HttpUtils.WsEncode((byte)10, frame.data));
                    continue;
                }
                if (frame instanceof Frame.PongFrame) {
                    atta.decoder.reset();
                    this.tryWrite(key, HttpUtils.WsEncode((byte)9, frame.data));
                    continue;
                }
                if (!(frame instanceof Frame.CloseFrame)) continue;
                this.handler.clientClose(atta.channel, ((Frame.CloseFrame)frame).getStatus());
                atta.keepalive = false;
                this.tryWrite(key, HttpUtils.WsEncode((byte)8, frame.data));
            } while (this.buffer.hasRemaining());
        }
        catch (ProtocolException e) {
            System.err.printf("%s [%s] WARN - %s\n", new Date(), THREAD_NAME, e.getMessage());
            this.closeKey(key, 1009);
        }
    }

    private void doRead(SelectionKey key) {
        SocketChannel ch = (SocketChannel)key.channel();
        try {
            this.buffer.clear();
            int read = ch.read(this.buffer);
            if (read == -1) {
                this.closeKey(key, 1001);
            } else if (read > 0) {
                this.buffer.flip();
                ServerAtta atta = (ServerAtta)key.attachment();
                if (atta instanceof HttpAtta) {
                    this.decodeHttp((HttpAtta)atta, key, ch);
                } else {
                    this.decodeWs((WsAtta)atta, key);
                }
            }
        }
        catch (IOException e) {
            this.closeKey(key, 1001);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWrite(SelectionKey key) {
        ServerAtta atta = (ServerAtta)key.attachment();
        SocketChannel ch = (SocketChannel)key.channel();
        try {
            ServerAtta serverAtta = atta;
            synchronized (serverAtta) {
                LinkedList<ByteBuffer> toWrites = atta.toWrites;
                int size = toWrites.size();
                if (size == 1) {
                    ch.write(toWrites.get(0));
                } else if (size > 0) {
                    ByteBuffer[] buffers = new ByteBuffer[size];
                    toWrites.toArray(buffers);
                    ch.write(buffers, 0, buffers.length);
                }
                Iterator ite = toWrites.iterator();
                while (ite.hasNext()) {
                    if (((ByteBuffer)ite.next()).hasRemaining()) continue;
                    ite.remove();
                }
                if (toWrites.size() == 0) {
                    if (atta.isKeepAlive()) {
                        key.interestOps(1);
                    } else {
                        this.closeKey(key, 1000);
                    }
                }
            }
        }
        catch (IOException e) {
            this.closeKey(key, 1001);
        }
    }

    public void tryWrite(SelectionKey key, ByteBuffer ... buffers) {
        this.tryWrite(key, false, buffers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryWrite(SelectionKey key, boolean chunkInprogress, ByteBuffer ... buffers) {
        ServerAtta atta;
        ServerAtta serverAtta = atta = (ServerAtta)key.attachment();
        synchronized (serverAtta) {
            atta.chunkedResponseInprogress(chunkInprogress);
            if (atta.toWrites.isEmpty()) {
                SocketChannel ch = (SocketChannel)key.channel();
                try {
                    ch.write(buffers, 0, buffers.length);
                    if (buffers[buffers.length - 1].hasRemaining()) {
                        for (ByteBuffer b : buffers) {
                            if (!b.hasRemaining()) continue;
                            atta.toWrites.add(b);
                        }
                        this.pending.add(new PendingKey(key, -1));
                        this.selector.wakeup();
                    } else if (!atta.isKeepAlive()) {
                        this.pending.add(new PendingKey(key, 1000));
                    }
                }
                catch (IOException e) {
                    this.pending.add(new PendingKey(key, 1001));
                }
            } else {
                Collections.addAll(atta.toWrites, buffers);
                this.pending.add(new PendingKey(key, -1));
                this.selector.wakeup();
            }
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    PendingKey k;
                    if ((k = this.pending.poll()) != null) {
                        if (k.Op == -1) {
                            if (!k.key.isValid()) continue;
                            k.key.interestOps(4);
                            continue;
                        }
                        this.closeKey(k.key, k.Op);
                        continue;
                    }
                    if (this.selector.select() <= 0) continue;
                    Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
                    for (SelectionKey key : selectedKeys) {
                        if (!key.isValid()) continue;
                        if (key.isAcceptable()) {
                            this.accept(key);
                            continue;
                        }
                        if (key.isReadable()) {
                            this.doRead(key);
                            continue;
                        }
                        if (!key.isWritable()) continue;
                        this.doWrite(key);
                    }
                    selectedKeys.clear();
                }
            }
            catch (ClosedSelectorException ignore) {
                return;
            }
            catch (Throwable e) {
                HttpUtils.printError("http server loop error, should not happen", e);
                continue;
            }
            break;
        }
    }

    public void start() throws IOException {
        this.serverThread = new Thread((Runnable)this, THREAD_NAME);
        this.serverThread.start();
    }

    public void stop(int timeout) {
        try {
            this.serverChannel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.handler.close(timeout);
        if (this.selector.isOpen()) {
            SelectionKey[] keys;
            Set<SelectionKey> t = this.selector.keys();
            for (SelectionKey k : keys = t.toArray(new SelectionKey[t.size()])) {
                if (k == null) continue;
                this.closeKey(k, 0);
            }
            try {
                this.selector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public int getPort() {
        return this.serverChannel.socket().getLocalPort();
    }
}

